/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.resource;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Maturity;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FilterOperator;
import com.ibm.fhir.model.type.code.PublicationStatus;
import com.ibm.fhir.model.type.code.StandardsStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Maturity(level=5, status=StandardsStatus.Value.NORMATIVE)
@Constraints(value={@Constraint(id="vsd-0", level="Warning", location="(base)", description="Name should be usable as an identifier for the module by machine processing applications such as code generation", expression="name.matches('[A-Z]([A-Za-z0-9_]){0,254}')", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-1", level="Rule", location="ValueSet.compose.include", description="A value set include/exclude SHALL have a value set or a system", expression="valueSet.exists() or system.exists()", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-2", level="Rule", location="ValueSet.compose.include", description="A value set with concepts or filters SHALL include a system", expression="(concept.exists() or filter.exists()) implies system.exists()", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-3", level="Rule", location="ValueSet.compose.include", description="Cannot have both concept and filter", expression="concept.empty() or filter.empty()", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-6", level="Rule", location="ValueSet.expansion.contains", description="SHALL have a code or a display", expression="code.exists() or display.exists()", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-9", level="Rule", location="ValueSet.expansion.contains", description="Must have a code if not abstract", expression="code.exists() or abstract = true", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="vsd-10", level="Rule", location="ValueSet.expansion.contains", description="Must have a system if a code is present", expression="code.empty() or system.exists()", source="http://hl7.org/fhir/StructureDefinition/ValueSet"), @Constraint(id="valueSet-11", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/jurisdiction", expression="jurisdiction.exists() implies (jurisdiction.all(memberOf('http://hl7.org/fhir/ValueSet/jurisdiction', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/ValueSet", generated=true), @Constraint(id="valueSet-12", level="Warning", location="compose.include.concept.designation.language", description="SHOULD contain a code from value set http://hl7.org/fhir/ValueSet/languages", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/languages', 'preferred')", source="http://hl7.org/fhir/StructureDefinition/ValueSet", generated=true), @Constraint(id="valueSet-13", level="Warning", location="compose.include.concept.designation.use", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/designation-use", expression="$this.memberOf('http://hl7.org/fhir/ValueSet/designation-use', 'extensible')", source="http://hl7.org/fhir/StructureDefinition/ValueSet", generated=true)})
public class ValueSet
extends DomainResource {
    @Summary
    private final Uri url;
    @Summary
    private final List<Identifier> identifier;
    @Summary
    private final String version;
    @Summary
    private final String name;
    @Summary
    private final String title;
    @Summary
    @Binding(bindingName="PublicationStatus", strength=BindingStrength.Value.REQUIRED, description="The lifecycle status of an artifact.", valueSet="http://hl7.org/fhir/ValueSet/publication-status|4.0.1")
    @Required
    private final PublicationStatus status;
    @Summary
    private final Boolean experimental;
    @Summary
    private final DateTime date;
    @Summary
    private final String publisher;
    @Summary
    private final List<ContactDetail> contact;
    private final Markdown description;
    @Summary
    private final List<UsageContext> useContext;
    @Summary
    @Binding(bindingName="Jurisdiction", strength=BindingStrength.Value.EXTENSIBLE, description="Countries and regions within which this artifact is targeted for use.", valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    private final List<CodeableConcept> jurisdiction;
    @Summary
    private final Boolean immutable;
    private final Markdown purpose;
    private final Markdown copyright;
    private final Compose compose;
    private final Expansion expansion;

    private ValueSet(Builder builder) {
        super(builder);
        this.url = builder.url;
        this.identifier = Collections.unmodifiableList(builder.identifier);
        this.version = builder.version;
        this.name = builder.name;
        this.title = builder.title;
        this.status = builder.status;
        this.experimental = builder.experimental;
        this.date = builder.date;
        this.publisher = builder.publisher;
        this.contact = Collections.unmodifiableList(builder.contact);
        this.description = builder.description;
        this.useContext = Collections.unmodifiableList(builder.useContext);
        this.jurisdiction = Collections.unmodifiableList(builder.jurisdiction);
        this.immutable = builder.immutable;
        this.purpose = builder.purpose;
        this.copyright = builder.copyright;
        this.compose = builder.compose;
        this.expansion = builder.expansion;
    }

    public Uri getUrl() {
        return this.url;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public PublicationStatus getStatus() {
        return this.status;
    }

    public Boolean getExperimental() {
        return this.experimental;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public List<ContactDetail> getContact() {
        return this.contact;
    }

    public Markdown getDescription() {
        return this.description;
    }

    public List<UsageContext> getUseContext() {
        return this.useContext;
    }

    public List<CodeableConcept> getJurisdiction() {
        return this.jurisdiction;
    }

    public Boolean getImmutable() {
        return this.immutable;
    }

    public Markdown getPurpose() {
        return this.purpose;
    }

    public Markdown getCopyright() {
        return this.copyright;
    }

    public Compose getCompose() {
        return this.compose;
    }

    public Expansion getExpansion() {
        return this.expansion;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.url != null || !this.identifier.isEmpty() || this.version != null || this.name != null || this.title != null || this.status != null || this.experimental != null || this.date != null || this.publisher != null || !this.contact.isEmpty() || this.description != null || !this.useContext.isEmpty() || !this.jurisdiction.isEmpty() || this.immutable != null || this.purpose != null || this.copyright != null || this.compose != null || this.expansion != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.meta, "meta", visitor);
                this.accept(this.implicitRules, "implicitRules", visitor);
                this.accept(this.language, "language", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.contained, "contained", visitor, Resource.class);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.url, "url", visitor);
                this.accept(this.identifier, "identifier", visitor, Identifier.class);
                this.accept(this.version, "version", visitor);
                this.accept(this.name, "name", visitor);
                this.accept(this.title, "title", visitor);
                this.accept(this.status, "status", visitor);
                this.accept(this.experimental, "experimental", visitor);
                this.accept(this.date, "date", visitor);
                this.accept(this.publisher, "publisher", visitor);
                this.accept(this.contact, "contact", visitor, ContactDetail.class);
                this.accept(this.description, "description", visitor);
                this.accept(this.useContext, "useContext", visitor, UsageContext.class);
                this.accept(this.jurisdiction, "jurisdiction", visitor, CodeableConcept.class);
                this.accept(this.immutable, "immutable", visitor);
                this.accept(this.purpose, "purpose", visitor);
                this.accept(this.copyright, "copyright", visitor);
                this.accept(this.compose, "compose", visitor);
                this.accept(this.expansion, "expansion", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.meta, other.meta) && Objects.equals(this.implicitRules, other.implicitRules) && Objects.equals(this.language, other.language) && Objects.equals(this.text, other.text) && Objects.equals(this.contained, other.contained) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.url, other.url) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.version, other.version) && Objects.equals(this.name, other.name) && Objects.equals(this.title, other.title) && Objects.equals(this.status, other.status) && Objects.equals(this.experimental, other.experimental) && Objects.equals(this.date, other.date) && Objects.equals(this.publisher, other.publisher) && Objects.equals(this.contact, other.contact) && Objects.equals(this.description, other.description) && Objects.equals(this.useContext, other.useContext) && Objects.equals(this.jurisdiction, other.jurisdiction) && Objects.equals(this.immutable, other.immutable) && Objects.equals(this.purpose, other.purpose) && Objects.equals(this.copyright, other.copyright) && Objects.equals(this.compose, other.compose) && Objects.equals(this.expansion, other.expansion);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.meta, this.implicitRules, this.language, this.text, this.contained, this.extension, this.modifierExtension, this.url, this.identifier, this.version, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.immutable, this.purpose, this.copyright, this.compose, this.expansion);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Expansion
    extends BackboneElement {
        private final Uri identifier;
        @Required
        private final DateTime timestamp;
        private final Integer total;
        private final Integer offset;
        private final List<Parameter> parameter;
        private final List<Contains> contains;

        private Expansion(Builder builder) {
            super(builder);
            this.identifier = builder.identifier;
            this.timestamp = builder.timestamp;
            this.total = builder.total;
            this.offset = builder.offset;
            this.parameter = Collections.unmodifiableList(builder.parameter);
            this.contains = Collections.unmodifiableList(builder.contains);
        }

        public Uri getIdentifier() {
            return this.identifier;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public Integer getTotal() {
            return this.total;
        }

        public Integer getOffset() {
            return this.offset;
        }

        public List<Parameter> getParameter() {
            return this.parameter;
        }

        public List<Contains> getContains() {
            return this.contains;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.identifier != null || this.timestamp != null || this.total != null || this.offset != null || !this.parameter.isEmpty() || !this.contains.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.identifier, "identifier", visitor);
                    this.accept(this.timestamp, "timestamp", visitor);
                    this.accept(this.total, "total", visitor);
                    this.accept(this.offset, "offset", visitor);
                    this.accept(this.parameter, "parameter", visitor, Parameter.class);
                    this.accept(this.contains, "contains", visitor, Contains.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Expansion other = (Expansion)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.total, other.total) && Objects.equals(this.offset, other.offset) && Objects.equals(this.parameter, other.parameter) && Objects.equals(this.contains, other.contains);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.identifier, this.timestamp, this.total, this.offset, this.parameter, this.contains);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Contains
        extends BackboneElement {
            private final Uri system;
            private final Boolean _abstract;
            private final Boolean inactive;
            private final String version;
            private final Code code;
            private final String display;
            private final List<Compose.Include.Concept.Designation> designation;
            private final List<Contains> contains;

            private Contains(Builder builder) {
                super(builder);
                this.system = builder.system;
                this._abstract = builder._abstract;
                this.inactive = builder.inactive;
                this.version = builder.version;
                this.code = builder.code;
                this.display = builder.display;
                this.designation = Collections.unmodifiableList(builder.designation);
                this.contains = Collections.unmodifiableList(builder.contains);
            }

            public Uri getSystem() {
                return this.system;
            }

            public Boolean getAbstract() {
                return this._abstract;
            }

            public Boolean getInactive() {
                return this.inactive;
            }

            public String getVersion() {
                return this.version;
            }

            public Code getCode() {
                return this.code;
            }

            public String getDisplay() {
                return this.display;
            }

            public List<Compose.Include.Concept.Designation> getDesignation() {
                return this.designation;
            }

            public List<Contains> getContains() {
                return this.contains;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.system != null || this._abstract != null || this.inactive != null || this.version != null || this.code != null || this.display != null || !this.designation.isEmpty() || !this.contains.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.system, "system", visitor);
                        this.accept(this._abstract, "abstract", visitor);
                        this.accept(this.inactive, "inactive", visitor);
                        this.accept(this.version, "version", visitor);
                        this.accept(this.code, "code", visitor);
                        this.accept(this.display, "display", visitor);
                        this.accept(this.designation, "designation", visitor, Compose.Include.Concept.Designation.class);
                        this.accept(this.contains, "contains", visitor, Contains.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Contains other = (Contains)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.system, other.system) && Objects.equals(this._abstract, other._abstract) && Objects.equals(this.inactive, other.inactive) && Objects.equals(this.version, other.version) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.designation, other.designation) && Objects.equals(this.contains, other.contains);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.system, this._abstract, this.inactive, this.version, this.code, this.display, this.designation, this.contains);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Uri system;
                private Boolean _abstract;
                private Boolean inactive;
                private String version;
                private Code code;
                private String display;
                private List<Compose.Include.Concept.Designation> designation = new ArrayList<Compose.Include.Concept.Designation>();
                private List<Contains> contains = new ArrayList<Contains>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder system(Uri system) {
                    this.system = system;
                    return this;
                }

                public Builder _abstract(Boolean _abstract) {
                    this._abstract = _abstract;
                    return this;
                }

                public Builder inactive(Boolean inactive) {
                    this.inactive = inactive;
                    return this;
                }

                public Builder version(String version) {
                    this.version = version;
                    return this;
                }

                public Builder code(Code code) {
                    this.code = code;
                    return this;
                }

                public Builder display(String display) {
                    this.display = display;
                    return this;
                }

                public Builder designation(Compose.Include.Concept.Designation ... designation) {
                    for (Compose.Include.Concept.Designation value : designation) {
                        this.designation.add(value);
                    }
                    return this;
                }

                public Builder designation(Collection<Compose.Include.Concept.Designation> designation) {
                    this.designation = new ArrayList<Compose.Include.Concept.Designation>(designation);
                    return this;
                }

                public Builder contains(Contains ... contains) {
                    for (Contains value : contains) {
                        this.contains.add(value);
                    }
                    return this;
                }

                public Builder contains(Collection<Contains> contains) {
                    this.contains = new ArrayList<Contains>(contains);
                    return this;
                }

                @Override
                public Contains build() {
                    Contains contains = new Contains(this);
                    if (this.validating) {
                        this.validate(contains);
                    }
                    return contains;
                }

                protected void validate(Contains contains) {
                    super.validate(contains);
                    ValidationSupport.checkList(contains.designation, "designation", Compose.Include.Concept.Designation.class);
                    ValidationSupport.checkList(contains.contains, "contains", Contains.class);
                    ValidationSupport.requireValueOrChildren(contains);
                }

                protected Builder from(Contains contains) {
                    super.from(contains);
                    this.system = contains.system;
                    this._abstract = contains._abstract;
                    this.inactive = contains.inactive;
                    this.version = contains.version;
                    this.code = contains.code;
                    this.display = contains.display;
                    this.designation.addAll(contains.designation);
                    this.contains.addAll(contains.contains);
                    return this;
                }
            }
        }

        public static class Parameter
        extends BackboneElement {
            @Required
            private final String name;
            @Choice(value={String.class, Boolean.class, Integer.class, Decimal.class, Uri.class, Code.class, DateTime.class})
            private final Element value;

            private Parameter(Builder builder) {
                super(builder);
                this.name = builder.name;
                this.value = builder.value;
            }

            public String getName() {
                return this.name;
            }

            public Element getValue() {
                return this.value;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.name != null || this.value != null;
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.name, "name", visitor);
                        this.accept(this.value, "value", visitor);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Parameter other = (Parameter)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.name, this.value);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends BackboneElement.Builder {
                private String name;
                private Element value;

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder name(String name) {
                    this.name = name;
                    return this;
                }

                public Builder value(Element value) {
                    this.value = value;
                    return this;
                }

                @Override
                public Parameter build() {
                    Parameter parameter = new Parameter(this);
                    if (this.validating) {
                        this.validate(parameter);
                    }
                    return parameter;
                }

                protected void validate(Parameter parameter) {
                    super.validate(parameter);
                    ValidationSupport.requireNonNull(parameter.name, "name");
                    ValidationSupport.choiceElement(parameter.value, "value", String.class, Boolean.class, Integer.class, Decimal.class, Uri.class, Code.class, DateTime.class);
                    ValidationSupport.requireValueOrChildren(parameter);
                }

                protected Builder from(Parameter parameter) {
                    super.from(parameter);
                    this.name = parameter.name;
                    this.value = parameter.value;
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Uri identifier;
            private DateTime timestamp;
            private Integer total;
            private Integer offset;
            private List<Parameter> parameter = new ArrayList<Parameter>();
            private List<Contains> contains = new ArrayList<Contains>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder identifier(Uri identifier) {
                this.identifier = identifier;
                return this;
            }

            public Builder timestamp(DateTime timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder total(Integer total) {
                this.total = total;
                return this;
            }

            public Builder offset(Integer offset) {
                this.offset = offset;
                return this;
            }

            public Builder parameter(Parameter ... parameter) {
                for (Parameter value : parameter) {
                    this.parameter.add(value);
                }
                return this;
            }

            public Builder parameter(Collection<Parameter> parameter) {
                this.parameter = new ArrayList<Parameter>(parameter);
                return this;
            }

            public Builder contains(Contains ... contains) {
                for (Contains value : contains) {
                    this.contains.add(value);
                }
                return this;
            }

            public Builder contains(Collection<Contains> contains) {
                this.contains = new ArrayList<Contains>(contains);
                return this;
            }

            @Override
            public Expansion build() {
                Expansion expansion = new Expansion(this);
                if (this.validating) {
                    this.validate(expansion);
                }
                return expansion;
            }

            protected void validate(Expansion expansion) {
                super.validate(expansion);
                ValidationSupport.requireNonNull(expansion.timestamp, "timestamp");
                ValidationSupport.checkList(expansion.parameter, "parameter", Parameter.class);
                ValidationSupport.checkList(expansion.contains, "contains", Contains.class);
                ValidationSupport.requireValueOrChildren(expansion);
            }

            protected Builder from(Expansion expansion) {
                super.from(expansion);
                this.identifier = expansion.identifier;
                this.timestamp = expansion.timestamp;
                this.total = expansion.total;
                this.offset = expansion.offset;
                this.parameter.addAll(expansion.parameter);
                this.contains.addAll(expansion.contains);
                return this;
            }
        }
    }

    public static class Compose
    extends BackboneElement {
        @Summary
        private final Date lockedDate;
        @Summary
        private final Boolean inactive;
        @Summary
        @Required
        private final List<Include> include;
        private final List<Include> exclude;

        private Compose(Builder builder) {
            super(builder);
            this.lockedDate = builder.lockedDate;
            this.inactive = builder.inactive;
            this.include = Collections.unmodifiableList(builder.include);
            this.exclude = Collections.unmodifiableList(builder.exclude);
        }

        public Date getLockedDate() {
            return this.lockedDate;
        }

        public Boolean getInactive() {
            return this.inactive;
        }

        public List<Include> getInclude() {
            return this.include;
        }

        public List<Include> getExclude() {
            return this.exclude;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.lockedDate != null || this.inactive != null || !this.include.isEmpty() || !this.exclude.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.lockedDate, "lockedDate", visitor);
                    this.accept(this.inactive, "inactive", visitor);
                    this.accept(this.include, "include", visitor, Include.class);
                    this.accept(this.exclude, "exclude", visitor, Include.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Compose other = (Compose)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.lockedDate, other.lockedDate) && Objects.equals(this.inactive, other.inactive) && Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.lockedDate, this.inactive, this.include, this.exclude);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Include
        extends BackboneElement {
            @Summary
            private final Uri system;
            @Summary
            private final String version;
            private final List<Concept> concept;
            @Summary
            private final List<Filter> filter;
            @Summary
            private final List<Canonical> valueSet;

            private Include(Builder builder) {
                super(builder);
                this.system = builder.system;
                this.version = builder.version;
                this.concept = Collections.unmodifiableList(builder.concept);
                this.filter = Collections.unmodifiableList(builder.filter);
                this.valueSet = Collections.unmodifiableList(builder.valueSet);
            }

            public Uri getSystem() {
                return this.system;
            }

            public String getVersion() {
                return this.version;
            }

            public List<Concept> getConcept() {
                return this.concept;
            }

            public List<Filter> getFilter() {
                return this.filter;
            }

            public List<Canonical> getValueSet() {
                return this.valueSet;
            }

            @Override
            public boolean hasChildren() {
                return super.hasChildren() || this.system != null || this.version != null || !this.concept.isEmpty() || !this.filter.isEmpty() || !this.valueSet.isEmpty();
            }

            @Override
            public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                if (visitor.preVisit(this)) {
                    visitor.visitStart(elementName, elementIndex, this);
                    if (visitor.visit(elementName, elementIndex, this)) {
                        this.accept(this.id, "id", visitor);
                        this.accept(this.extension, "extension", visitor, Extension.class);
                        this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                        this.accept(this.system, "system", visitor);
                        this.accept(this.version, "version", visitor);
                        this.accept(this.concept, "concept", visitor, Concept.class);
                        this.accept(this.filter, "filter", visitor, Filter.class);
                        this.accept(this.valueSet, "valueSet", visitor, Canonical.class);
                    }
                    visitor.visitEnd(elementName, elementIndex, this);
                    visitor.postVisit(this);
                }
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Include other = (Include)obj;
                return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.system, other.system) && Objects.equals(this.version, other.version) && Objects.equals(this.concept, other.concept) && Objects.equals(this.filter, other.filter) && Objects.equals(this.valueSet, other.valueSet);
            }

            public int hashCode() {
                int result = this.hashCode;
                if (result == 0) {
                    this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.system, this.version, this.concept, this.filter, this.valueSet);
                }
                return result;
            }

            @Override
            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Filter
            extends BackboneElement {
                @Summary
                @Required
                private final Code property;
                @Summary
                @Binding(bindingName="FilterOperator", strength=BindingStrength.Value.REQUIRED, description="The kind of operation to perform as a part of a property based filter.", valueSet="http://hl7.org/fhir/ValueSet/filter-operator|4.0.1")
                @Required
                private final FilterOperator op;
                @Summary
                @Required
                private final String value;

                private Filter(Builder builder) {
                    super(builder);
                    this.property = builder.property;
                    this.op = builder.op;
                    this.value = builder.value;
                }

                public Code getProperty() {
                    return this.property;
                }

                public FilterOperator getOp() {
                    return this.op;
                }

                public String getValue() {
                    return this.value;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.property != null || this.op != null || this.value != null;
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.property, "property", visitor);
                            this.accept(this.op, "op", visitor);
                            this.accept(this.value, "value", visitor);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Filter other = (Filter)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.property, other.property) && Objects.equals(this.op, other.op) && Objects.equals(this.value, other.value);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.property, this.op, this.value);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Code property;
                    private FilterOperator op;
                    private String value;

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder property(Code property) {
                        this.property = property;
                        return this;
                    }

                    public Builder op(FilterOperator op) {
                        this.op = op;
                        return this;
                    }

                    public Builder value(String value) {
                        this.value = value;
                        return this;
                    }

                    @Override
                    public Filter build() {
                        Filter filter = new Filter(this);
                        if (this.validating) {
                            this.validate(filter);
                        }
                        return filter;
                    }

                    protected void validate(Filter filter) {
                        super.validate(filter);
                        ValidationSupport.requireNonNull(filter.property, "property");
                        ValidationSupport.requireNonNull(filter.op, "op");
                        ValidationSupport.requireNonNull(filter.value, "value");
                        ValidationSupport.requireValueOrChildren(filter);
                    }

                    protected Builder from(Filter filter) {
                        super.from(filter);
                        this.property = filter.property;
                        this.op = filter.op;
                        this.value = filter.value;
                        return this;
                    }
                }
            }

            public static class Concept
            extends BackboneElement {
                @Required
                private final Code code;
                private final String display;
                private final List<Designation> designation;

                private Concept(Builder builder) {
                    super(builder);
                    this.code = builder.code;
                    this.display = builder.display;
                    this.designation = Collections.unmodifiableList(builder.designation);
                }

                public Code getCode() {
                    return this.code;
                }

                public String getDisplay() {
                    return this.display;
                }

                public List<Designation> getDesignation() {
                    return this.designation;
                }

                @Override
                public boolean hasChildren() {
                    return super.hasChildren() || this.code != null || this.display != null || !this.designation.isEmpty();
                }

                @Override
                public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                    if (visitor.preVisit(this)) {
                        visitor.visitStart(elementName, elementIndex, this);
                        if (visitor.visit(elementName, elementIndex, this)) {
                            this.accept(this.id, "id", visitor);
                            this.accept(this.extension, "extension", visitor, Extension.class);
                            this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                            this.accept(this.code, "code", visitor);
                            this.accept(this.display, "display", visitor);
                            this.accept(this.designation, "designation", visitor, Designation.class);
                        }
                        visitor.visitEnd(elementName, elementIndex, this);
                        visitor.postVisit(this);
                    }
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Concept other = (Concept)obj;
                    return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.code, other.code) && Objects.equals(this.display, other.display) && Objects.equals(this.designation, other.designation);
                }

                public int hashCode() {
                    int result = this.hashCode;
                    if (result == 0) {
                        this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.code, this.display, this.designation);
                    }
                    return result;
                }

                @Override
                public Builder toBuilder() {
                    return new Builder().from(this);
                }

                public static Builder builder() {
                    return new Builder();
                }

                public static class Designation
                extends BackboneElement {
                    @Binding(bindingName="Language", strength=BindingStrength.Value.PREFERRED, description="A human language.", valueSet="http://hl7.org/fhir/ValueSet/languages", maxValueSet="http://hl7.org/fhir/ValueSet/all-languages")
                    private final Code language;
                    @Binding(bindingName="ConceptDesignationUse", strength=BindingStrength.Value.EXTENSIBLE, description="Details of how a designation would be used.", valueSet="http://hl7.org/fhir/ValueSet/designation-use")
                    private final Coding use;
                    @Required
                    private final String value;

                    private Designation(Builder builder) {
                        super(builder);
                        this.language = builder.language;
                        this.use = builder.use;
                        this.value = builder.value;
                    }

                    public Code getLanguage() {
                        return this.language;
                    }

                    public Coding getUse() {
                        return this.use;
                    }

                    public String getValue() {
                        return this.value;
                    }

                    @Override
                    public boolean hasChildren() {
                        return super.hasChildren() || this.language != null || this.use != null || this.value != null;
                    }

                    @Override
                    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
                        if (visitor.preVisit(this)) {
                            visitor.visitStart(elementName, elementIndex, this);
                            if (visitor.visit(elementName, elementIndex, this)) {
                                this.accept(this.id, "id", visitor);
                                this.accept(this.extension, "extension", visitor, Extension.class);
                                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                                this.accept(this.language, "language", visitor);
                                this.accept(this.use, "use", visitor);
                                this.accept(this.value, "value", visitor);
                            }
                            visitor.visitEnd(elementName, elementIndex, this);
                            visitor.postVisit(this);
                        }
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Designation other = (Designation)obj;
                        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.language, other.language) && Objects.equals(this.use, other.use) && Objects.equals(this.value, other.value);
                    }

                    public int hashCode() {
                        int result = this.hashCode;
                        if (result == 0) {
                            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.language, this.use, this.value);
                        }
                        return result;
                    }

                    @Override
                    public Builder toBuilder() {
                        return new Builder().from(this);
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    public static class Builder
                    extends BackboneElement.Builder {
                        private Code language;
                        private Coding use;
                        private String value;

                        private Builder() {
                        }

                        @Override
                        public Builder id(java.lang.String id) {
                            return (Builder)super.id(id);
                        }

                        @Override
                        public Builder extension(Extension ... extension) {
                            return (Builder)super.extension(extension);
                        }

                        @Override
                        public Builder extension(Collection<Extension> extension) {
                            return (Builder)super.extension((Collection)extension);
                        }

                        @Override
                        public Builder modifierExtension(Extension ... modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        @Override
                        public Builder modifierExtension(Collection<Extension> modifierExtension) {
                            return (Builder)super.modifierExtension(modifierExtension);
                        }

                        public Builder language(Code language) {
                            this.language = language;
                            return this;
                        }

                        public Builder use(Coding use) {
                            this.use = use;
                            return this;
                        }

                        public Builder value(String value) {
                            this.value = value;
                            return this;
                        }

                        @Override
                        public Designation build() {
                            Designation designation = new Designation(this);
                            if (this.validating) {
                                this.validate(designation);
                            }
                            return designation;
                        }

                        protected void validate(Designation designation) {
                            super.validate(designation);
                            ValidationSupport.requireNonNull(designation.value, "value");
                            ValidationSupport.checkValueSetBinding(designation.language, "language", "http://hl7.org/fhir/ValueSet/all-languages", "urn:ietf:bcp:47", new java.lang.String[0]);
                            ValidationSupport.requireValueOrChildren(designation);
                        }

                        protected Builder from(Designation designation) {
                            super.from(designation);
                            this.language = designation.language;
                            this.use = designation.use;
                            this.value = designation.value;
                            return this;
                        }
                    }
                }

                public static class Builder
                extends BackboneElement.Builder {
                    private Code code;
                    private String display;
                    private List<Designation> designation = new ArrayList<Designation>();

                    private Builder() {
                    }

                    @Override
                    public Builder id(java.lang.String id) {
                        return (Builder)super.id(id);
                    }

                    @Override
                    public Builder extension(Extension ... extension) {
                        return (Builder)super.extension(extension);
                    }

                    @Override
                    public Builder extension(Collection<Extension> extension) {
                        return (Builder)super.extension((Collection)extension);
                    }

                    @Override
                    public Builder modifierExtension(Extension ... modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    @Override
                    public Builder modifierExtension(Collection<Extension> modifierExtension) {
                        return (Builder)super.modifierExtension(modifierExtension);
                    }

                    public Builder code(Code code) {
                        this.code = code;
                        return this;
                    }

                    public Builder display(String display) {
                        this.display = display;
                        return this;
                    }

                    public Builder designation(Designation ... designation) {
                        for (Designation value : designation) {
                            this.designation.add(value);
                        }
                        return this;
                    }

                    public Builder designation(Collection<Designation> designation) {
                        this.designation = new ArrayList<Designation>(designation);
                        return this;
                    }

                    @Override
                    public Concept build() {
                        Concept concept = new Concept(this);
                        if (this.validating) {
                            this.validate(concept);
                        }
                        return concept;
                    }

                    protected void validate(Concept concept) {
                        super.validate(concept);
                        ValidationSupport.requireNonNull(concept.code, "code");
                        ValidationSupport.checkList(concept.designation, "designation", Designation.class);
                        ValidationSupport.requireValueOrChildren(concept);
                    }

                    protected Builder from(Concept concept) {
                        super.from(concept);
                        this.code = concept.code;
                        this.display = concept.display;
                        this.designation.addAll(concept.designation);
                        return this;
                    }
                }
            }

            public static class Builder
            extends BackboneElement.Builder {
                private Uri system;
                private String version;
                private List<Concept> concept = new ArrayList<Concept>();
                private List<Filter> filter = new ArrayList<Filter>();
                private List<Canonical> valueSet = new ArrayList<Canonical>();

                private Builder() {
                }

                @Override
                public Builder id(java.lang.String id) {
                    return (Builder)super.id(id);
                }

                @Override
                public Builder extension(Extension ... extension) {
                    return (Builder)super.extension(extension);
                }

                @Override
                public Builder extension(Collection<Extension> extension) {
                    return (Builder)super.extension((Collection)extension);
                }

                @Override
                public Builder modifierExtension(Extension ... modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                @Override
                public Builder modifierExtension(Collection<Extension> modifierExtension) {
                    return (Builder)super.modifierExtension(modifierExtension);
                }

                public Builder system(Uri system) {
                    this.system = system;
                    return this;
                }

                public Builder version(String version) {
                    this.version = version;
                    return this;
                }

                public Builder concept(Concept ... concept) {
                    for (Concept value : concept) {
                        this.concept.add(value);
                    }
                    return this;
                }

                public Builder concept(Collection<Concept> concept) {
                    this.concept = new ArrayList<Concept>(concept);
                    return this;
                }

                public Builder filter(Filter ... filter) {
                    for (Filter value : filter) {
                        this.filter.add(value);
                    }
                    return this;
                }

                public Builder filter(Collection<Filter> filter) {
                    this.filter = new ArrayList<Filter>(filter);
                    return this;
                }

                public Builder valueSet(Canonical ... valueSet) {
                    for (Canonical value : valueSet) {
                        this.valueSet.add(value);
                    }
                    return this;
                }

                public Builder valueSet(Collection<Canonical> valueSet) {
                    this.valueSet = new ArrayList<Canonical>(valueSet);
                    return this;
                }

                @Override
                public Include build() {
                    Include include = new Include(this);
                    if (this.validating) {
                        this.validate(include);
                    }
                    return include;
                }

                protected void validate(Include include) {
                    super.validate(include);
                    ValidationSupport.checkList(include.concept, "concept", Concept.class);
                    ValidationSupport.checkList(include.filter, "filter", Filter.class);
                    ValidationSupport.checkList(include.valueSet, "valueSet", Canonical.class);
                    ValidationSupport.requireValueOrChildren(include);
                }

                protected Builder from(Include include) {
                    super.from(include);
                    this.system = include.system;
                    this.version = include.version;
                    this.concept.addAll(include.concept);
                    this.filter.addAll(include.filter);
                    this.valueSet.addAll(include.valueSet);
                    return this;
                }
            }
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Date lockedDate;
            private Boolean inactive;
            private List<Include> include = new ArrayList<Include>();
            private List<Include> exclude = new ArrayList<Include>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder lockedDate(Date lockedDate) {
                this.lockedDate = lockedDate;
                return this;
            }

            public Builder inactive(Boolean inactive) {
                this.inactive = inactive;
                return this;
            }

            public Builder include(Include ... include) {
                for (Include value : include) {
                    this.include.add(value);
                }
                return this;
            }

            public Builder include(Collection<Include> include) {
                this.include = new ArrayList<Include>(include);
                return this;
            }

            public Builder exclude(Include ... exclude) {
                for (Include value : exclude) {
                    this.exclude.add(value);
                }
                return this;
            }

            public Builder exclude(Collection<Include> exclude) {
                this.exclude = new ArrayList<Include>(exclude);
                return this;
            }

            @Override
            public Compose build() {
                Compose compose = new Compose(this);
                if (this.validating) {
                    this.validate(compose);
                }
                return compose;
            }

            protected void validate(Compose compose) {
                super.validate(compose);
                ValidationSupport.checkNonEmptyList(compose.include, "include", Include.class);
                ValidationSupport.checkList(compose.exclude, "exclude", Include.class);
                ValidationSupport.requireValueOrChildren(compose);
            }

            protected Builder from(Compose compose) {
                super.from(compose);
                this.lockedDate = compose.lockedDate;
                this.inactive = compose.inactive;
                this.include.addAll(compose.include);
                this.exclude.addAll(compose.exclude);
                return this;
            }
        }
    }

    public static class Builder
    extends DomainResource.Builder {
        private Uri url;
        private List<Identifier> identifier = new ArrayList<Identifier>();
        private String version;
        private String name;
        private String title;
        private PublicationStatus status;
        private Boolean experimental;
        private DateTime date;
        private String publisher;
        private List<ContactDetail> contact = new ArrayList<ContactDetail>();
        private Markdown description;
        private List<UsageContext> useContext = new ArrayList<UsageContext>();
        private List<CodeableConcept> jurisdiction = new ArrayList<CodeableConcept>();
        private Boolean immutable;
        private Markdown purpose;
        private Markdown copyright;
        private Compose compose;
        private Expansion expansion;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder meta(Meta meta) {
            return (Builder)super.meta(meta);
        }

        @Override
        public Builder implicitRules(Uri implicitRules) {
            return (Builder)super.implicitRules(implicitRules);
        }

        @Override
        public Builder language(Code language) {
            return (Builder)super.language(language);
        }

        @Override
        public Builder text(Narrative text) {
            return (Builder)super.text(text);
        }

        @Override
        public Builder contained(Resource ... contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder contained(Collection<Resource> contained) {
            return (Builder)super.contained(contained);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder url(Uri url) {
            this.url = url;
            return this;
        }

        public Builder identifier(Identifier ... identifier) {
            for (Identifier value : identifier) {
                this.identifier.add(value);
            }
            return this;
        }

        public Builder identifier(Collection<Identifier> identifier) {
            this.identifier = new ArrayList<Identifier>(identifier);
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder status(PublicationStatus status) {
            this.status = status;
            return this;
        }

        public Builder experimental(Boolean experimental) {
            this.experimental = experimental;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public Builder contact(ContactDetail ... contact) {
            for (ContactDetail value : contact) {
                this.contact.add(value);
            }
            return this;
        }

        public Builder contact(Collection<ContactDetail> contact) {
            this.contact = new ArrayList<ContactDetail>(contact);
            return this;
        }

        public Builder description(Markdown description) {
            this.description = description;
            return this;
        }

        public Builder useContext(UsageContext ... useContext) {
            for (UsageContext value : useContext) {
                this.useContext.add(value);
            }
            return this;
        }

        public Builder useContext(Collection<UsageContext> useContext) {
            this.useContext = new ArrayList<UsageContext>(useContext);
            return this;
        }

        public Builder jurisdiction(CodeableConcept ... jurisdiction) {
            for (CodeableConcept value : jurisdiction) {
                this.jurisdiction.add(value);
            }
            return this;
        }

        public Builder jurisdiction(Collection<CodeableConcept> jurisdiction) {
            this.jurisdiction = new ArrayList<CodeableConcept>(jurisdiction);
            return this;
        }

        public Builder immutable(Boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public Builder purpose(Markdown purpose) {
            this.purpose = purpose;
            return this;
        }

        public Builder copyright(Markdown copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder compose(Compose compose) {
            this.compose = compose;
            return this;
        }

        public Builder expansion(Expansion expansion) {
            this.expansion = expansion;
            return this;
        }

        @Override
        public ValueSet build() {
            ValueSet valueSet = new ValueSet(this);
            if (this.validating) {
                this.validate(valueSet);
            }
            return valueSet;
        }

        protected void validate(ValueSet valueSet) {
            super.validate(valueSet);
            ValidationSupport.checkList(valueSet.identifier, "identifier", Identifier.class);
            ValidationSupport.requireNonNull(valueSet.status, "status");
            ValidationSupport.checkList(valueSet.contact, "contact", ContactDetail.class);
            ValidationSupport.checkList(valueSet.useContext, "useContext", UsageContext.class);
            ValidationSupport.checkList(valueSet.jurisdiction, "jurisdiction", CodeableConcept.class);
        }

        protected Builder from(ValueSet valueSet) {
            super.from(valueSet);
            this.url = valueSet.url;
            this.identifier.addAll(valueSet.identifier);
            this.version = valueSet.version;
            this.name = valueSet.name;
            this.title = valueSet.title;
            this.status = valueSet.status;
            this.experimental = valueSet.experimental;
            this.date = valueSet.date;
            this.publisher = valueSet.publisher;
            this.contact.addAll(valueSet.contact);
            this.description = valueSet.description;
            this.useContext.addAll(valueSet.useContext);
            this.jurisdiction.addAll(valueSet.jurisdiction);
            this.immutable = valueSet.immutable;
            this.purpose = valueSet.purpose;
            this.copyright = valueSet.copyright;
            this.compose = valueSet.compose;
            this.expansion = valueSet.expansion;
            return this;
        }
    }
}

