/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CodeableConcept
extends Element {
    @Summary
    private final List<Coding> coding;
    @Summary
    private final String text;

    private CodeableConcept(Builder builder) {
        super(builder);
        this.coding = Collections.unmodifiableList(builder.coding);
        this.text = builder.text;
    }

    public List<Coding> getCoding() {
        return this.coding;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || !this.coding.isEmpty() || this.text != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.coding, "coding", visitor, Coding.class);
                this.accept(this.text, "text", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeableConcept other = (CodeableConcept)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.coding, other.coding) && Objects.equals(this.text, other.text);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.coding, this.text);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private List<Coding> coding = new ArrayList<Coding>();
        private String text;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder coding(Coding ... coding) {
            for (Coding value : coding) {
                this.coding.add(value);
            }
            return this;
        }

        public Builder coding(Collection<Coding> coding) {
            this.coding = new ArrayList<Coding>(coding);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public CodeableConcept build() {
            CodeableConcept codeableConcept = new CodeableConcept(this);
            if (this.validating) {
                this.validate(codeableConcept);
            }
            return codeableConcept;
        }

        protected void validate(CodeableConcept codeableConcept) {
            super.validate(codeableConcept);
            ValidationSupport.checkList(codeableConcept.coding, "coding", Coding.class);
            ValidationSupport.requireValueOrChildren(codeableConcept);
        }

        protected Builder from(CodeableConcept codeableConcept) {
            super.from(codeableConcept);
            this.coding.addAll(codeableConcept.coding);
            this.text = codeableConcept.text;
            return this;
        }
    }
}

