/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.FHIRAllTypes;
import com.ibm.fhir.model.type.code.SortDirection;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Constraints(value={@Constraint(id="drq-1", level="Rule", location="DataRequirement.codeFilter", description="Either a path or a searchParam must be provided, but not both", expression="path.exists() xor searchParam.exists()", source="http://hl7.org/fhir/StructureDefinition/DataRequirement"), @Constraint(id="drq-2", level="Rule", location="DataRequirement.dateFilter", description="Either a path or a searchParam must be provided, but not both", expression="path.exists() xor searchParam.exists()", source="http://hl7.org/fhir/StructureDefinition/DataRequirement"), @Constraint(id="dataRequirement-3", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/subject-type", expression="subject.as(CodeableConcept).exists() implies (subject.as(CodeableConcept).memberOf('http://hl7.org/fhir/ValueSet/subject-type', 'extensible'))", source="http://hl7.org/fhir/StructureDefinition/DataRequirement", generated=true)})
public class DataRequirement
extends Element {
    @Summary
    @Binding(bindingName="FHIRAllTypes", strength=BindingStrength.Value.REQUIRED, description="A list of all the concrete types defined in this version of the FHIR specification - Abstract Types, Data Types and Resource Types.", valueSet="http://hl7.org/fhir/ValueSet/all-types|4.0.1")
    @Required
    private final FHIRAllTypes type;
    @Summary
    private final List<Canonical> profile;
    @Summary
    @ReferenceTarget(value={"Group"})
    @Choice(value={CodeableConcept.class, Reference.class})
    @Binding(bindingName="SubjectType", strength=BindingStrength.Value.EXTENSIBLE, description="The possible types of subjects for a data requirement (E.g., Patient, Practitioner, Organization, Location, etc.).", valueSet="http://hl7.org/fhir/ValueSet/subject-type")
    private final Element subject;
    @Summary
    private final List<String> mustSupport;
    @Summary
    private final List<CodeFilter> codeFilter;
    @Summary
    private final List<DateFilter> dateFilter;
    @Summary
    private final PositiveInt limit;
    @Summary
    private final List<Sort> sort;

    private DataRequirement(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.profile = Collections.unmodifiableList(builder.profile);
        this.subject = builder.subject;
        this.mustSupport = Collections.unmodifiableList(builder.mustSupport);
        this.codeFilter = Collections.unmodifiableList(builder.codeFilter);
        this.dateFilter = Collections.unmodifiableList(builder.dateFilter);
        this.limit = builder.limit;
        this.sort = Collections.unmodifiableList(builder.sort);
    }

    public FHIRAllTypes getType() {
        return this.type;
    }

    public List<Canonical> getProfile() {
        return this.profile;
    }

    public Element getSubject() {
        return this.subject;
    }

    public List<String> getMustSupport() {
        return this.mustSupport;
    }

    public List<CodeFilter> getCodeFilter() {
        return this.codeFilter;
    }

    public List<DateFilter> getDateFilter() {
        return this.dateFilter;
    }

    public PositiveInt getLimit() {
        return this.limit;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.type != null || !this.profile.isEmpty() || this.subject != null || !this.mustSupport.isEmpty() || !this.codeFilter.isEmpty() || !this.dateFilter.isEmpty() || this.limit != null || !this.sort.isEmpty();
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.profile, "profile", visitor, Canonical.class);
                this.accept(this.subject, "subject", visitor);
                this.accept(this.mustSupport, "mustSupport", visitor, String.class);
                this.accept(this.codeFilter, "codeFilter", visitor, CodeFilter.class);
                this.accept(this.dateFilter, "dateFilter", visitor, DateFilter.class);
                this.accept(this.limit, "limit", visitor);
                this.accept(this.sort, "sort", visitor, Sort.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataRequirement other = (DataRequirement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.type, other.type) && Objects.equals(this.profile, other.profile) && Objects.equals(this.subject, other.subject) && Objects.equals(this.mustSupport, other.mustSupport) && Objects.equals(this.codeFilter, other.codeFilter) && Objects.equals(this.dateFilter, other.dateFilter) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sort, other.sort);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.type, this.profile, this.subject, this.mustSupport, this.codeFilter, this.dateFilter, this.limit, this.sort);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Sort
    extends BackboneElement {
        @Summary
        @Required
        private final String path;
        @Summary
        @Binding(bindingName="SortDirection", strength=BindingStrength.Value.REQUIRED, description="The possible sort directions, ascending or descending.", valueSet="http://hl7.org/fhir/ValueSet/sort-direction|4.0.1")
        @Required
        private final SortDirection direction;

        private Sort(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.direction = builder.direction;
        }

        public String getPath() {
            return this.path;
        }

        public SortDirection getDirection() {
            return this.direction;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.direction != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.direction, "direction", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Sort other = (Sort)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.direction, other.direction);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.direction);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private SortDirection direction;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder direction(SortDirection direction) {
                this.direction = direction;
                return this;
            }

            @Override
            public Sort build() {
                Sort sort = new Sort(this);
                if (this.validating) {
                    this.validate(sort);
                }
                return sort;
            }

            protected void validate(Sort sort) {
                super.validate(sort);
                ValidationSupport.requireNonNull(sort.path, "path");
                ValidationSupport.requireNonNull(sort.direction, "direction");
                ValidationSupport.requireValueOrChildren(sort);
            }

            protected Builder from(Sort sort) {
                super.from(sort);
                this.path = sort.path;
                this.direction = sort.direction;
                return this;
            }
        }
    }

    public static class DateFilter
    extends BackboneElement {
        @Summary
        private final String path;
        @Summary
        private final String searchParam;
        @Summary
        @Choice(value={DateTime.class, Period.class, Duration.class})
        private final Element value;

        private DateFilter(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.searchParam = builder.searchParam;
            this.value = builder.value;
        }

        public String getPath() {
            return this.path;
        }

        public String getSearchParam() {
            return this.searchParam;
        }

        public Element getValue() {
            return this.value;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.searchParam != null || this.value != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.searchParam, "searchParam", visitor);
                    this.accept(this.value, "value", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DateFilter other = (DateFilter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.searchParam, other.searchParam) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.searchParam, this.value);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private String searchParam;
            private Element value;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder searchParam(String searchParam) {
                this.searchParam = searchParam;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            @Override
            public DateFilter build() {
                DateFilter dateFilter = new DateFilter(this);
                if (this.validating) {
                    this.validate(dateFilter);
                }
                return dateFilter;
            }

            protected void validate(DateFilter dateFilter) {
                super.validate(dateFilter);
                ValidationSupport.choiceElement(dateFilter.value, "value", DateTime.class, Period.class, Duration.class);
                ValidationSupport.requireValueOrChildren(dateFilter);
            }

            protected Builder from(DateFilter dateFilter) {
                super.from(dateFilter);
                this.path = dateFilter.path;
                this.searchParam = dateFilter.searchParam;
                this.value = dateFilter.value;
                return this;
            }
        }
    }

    public static class CodeFilter
    extends BackboneElement {
        @Summary
        private final String path;
        @Summary
        private final String searchParam;
        @Summary
        private final Canonical valueSet;
        @Summary
        private final List<Coding> code;

        private CodeFilter(Builder builder) {
            super(builder);
            this.path = builder.path;
            this.searchParam = builder.searchParam;
            this.valueSet = builder.valueSet;
            this.code = Collections.unmodifiableList(builder.code);
        }

        public String getPath() {
            return this.path;
        }

        public String getSearchParam() {
            return this.searchParam;
        }

        public Canonical getValueSet() {
            return this.valueSet;
        }

        public List<Coding> getCode() {
            return this.code;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.path != null || this.searchParam != null || this.valueSet != null || !this.code.isEmpty();
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.path, "path", visitor);
                    this.accept(this.searchParam, "searchParam", visitor);
                    this.accept(this.valueSet, "valueSet", visitor);
                    this.accept(this.code, "code", visitor, Coding.class);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodeFilter other = (CodeFilter)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.path, other.path) && Objects.equals(this.searchParam, other.searchParam) && Objects.equals(this.valueSet, other.valueSet) && Objects.equals(this.code, other.code);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.path, this.searchParam, this.valueSet, this.code);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private String path;
            private String searchParam;
            private Canonical valueSet;
            private List<Coding> code = new ArrayList<Coding>();

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder searchParam(String searchParam) {
                this.searchParam = searchParam;
                return this;
            }

            public Builder valueSet(Canonical valueSet) {
                this.valueSet = valueSet;
                return this;
            }

            public Builder code(Coding ... code) {
                for (Coding value : code) {
                    this.code.add(value);
                }
                return this;
            }

            public Builder code(Collection<Coding> code) {
                this.code = new ArrayList<Coding>(code);
                return this;
            }

            @Override
            public CodeFilter build() {
                CodeFilter codeFilter = new CodeFilter(this);
                if (this.validating) {
                    this.validate(codeFilter);
                }
                return codeFilter;
            }

            protected void validate(CodeFilter codeFilter) {
                super.validate(codeFilter);
                ValidationSupport.checkList(codeFilter.code, "code", Coding.class);
                ValidationSupport.requireValueOrChildren(codeFilter);
            }

            protected Builder from(CodeFilter codeFilter) {
                super.from(codeFilter);
                this.path = codeFilter.path;
                this.searchParam = codeFilter.searchParam;
                this.valueSet = codeFilter.valueSet;
                this.code.addAll(codeFilter.code);
                return this;
            }
        }
    }

    public static class Builder
    extends Element.Builder {
        private FHIRAllTypes type;
        private List<Canonical> profile = new ArrayList<Canonical>();
        private Element subject;
        private List<String> mustSupport = new ArrayList<String>();
        private List<CodeFilter> codeFilter = new ArrayList<CodeFilter>();
        private List<DateFilter> dateFilter = new ArrayList<DateFilter>();
        private PositiveInt limit;
        private List<Sort> sort = new ArrayList<Sort>();

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder type(FHIRAllTypes type) {
            this.type = type;
            return this;
        }

        public Builder profile(Canonical ... profile) {
            for (Canonical value : profile) {
                this.profile.add(value);
            }
            return this;
        }

        public Builder profile(Collection<Canonical> profile) {
            this.profile = new ArrayList<Canonical>(profile);
            return this;
        }

        public Builder subject(Element subject) {
            this.subject = subject;
            return this;
        }

        public Builder mustSupport(String ... mustSupport) {
            for (String value : mustSupport) {
                this.mustSupport.add(value);
            }
            return this;
        }

        public Builder mustSupport(Collection<String> mustSupport) {
            this.mustSupport = new ArrayList<String>(mustSupport);
            return this;
        }

        public Builder codeFilter(CodeFilter ... codeFilter) {
            for (CodeFilter value : codeFilter) {
                this.codeFilter.add(value);
            }
            return this;
        }

        public Builder codeFilter(Collection<CodeFilter> codeFilter) {
            this.codeFilter = new ArrayList<CodeFilter>(codeFilter);
            return this;
        }

        public Builder dateFilter(DateFilter ... dateFilter) {
            for (DateFilter value : dateFilter) {
                this.dateFilter.add(value);
            }
            return this;
        }

        public Builder dateFilter(Collection<DateFilter> dateFilter) {
            this.dateFilter = new ArrayList<DateFilter>(dateFilter);
            return this;
        }

        public Builder limit(PositiveInt limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(Sort ... sort) {
            for (Sort value : sort) {
                this.sort.add(value);
            }
            return this;
        }

        public Builder sort(Collection<Sort> sort) {
            this.sort = new ArrayList<Sort>(sort);
            return this;
        }

        @Override
        public DataRequirement build() {
            DataRequirement dataRequirement = new DataRequirement(this);
            if (this.validating) {
                this.validate(dataRequirement);
            }
            return dataRequirement;
        }

        protected void validate(DataRequirement dataRequirement) {
            super.validate(dataRequirement);
            ValidationSupport.requireNonNull(dataRequirement.type, "type");
            ValidationSupport.checkList(dataRequirement.profile, "profile", Canonical.class);
            ValidationSupport.choiceElement(dataRequirement.subject, "subject", CodeableConcept.class, Reference.class);
            ValidationSupport.checkList(dataRequirement.mustSupport, "mustSupport", String.class);
            ValidationSupport.checkList(dataRequirement.codeFilter, "codeFilter", CodeFilter.class);
            ValidationSupport.checkList(dataRequirement.dateFilter, "dateFilter", DateFilter.class);
            ValidationSupport.checkList(dataRequirement.sort, "sort", Sort.class);
            ValidationSupport.checkReferenceType(dataRequirement.subject, "subject", "Group");
            ValidationSupport.requireValueOrChildren(dataRequirement);
        }

        protected Builder from(DataRequirement dataRequirement) {
            super.from(dataRequirement);
            this.type = dataRequirement.type;
            this.profile.addAll(dataRequirement.profile);
            this.subject = dataRequirement.subject;
            this.mustSupport.addAll(dataRequirement.mustSupport);
            this.codeFilter.addAll(dataRequirement.codeFilter);
            this.dateFilter.addAll(dataRequirement.dateFilter);
            this.limit = dataRequirement.limit;
            this.sort.addAll(dataRequirement.sort);
            return this;
        }
    }
}

