/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.NameUse;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HumanName
extends Element {
    @Summary
    @Binding(bindingName="NameUse", strength=BindingStrength.Value.REQUIRED, description="The use of a human name.", valueSet="http://hl7.org/fhir/ValueSet/name-use|4.0.1")
    private final NameUse use;
    @Summary
    private final String text;
    @Summary
    private final String family;
    @Summary
    private final List<String> given;
    @Summary
    private final List<String> prefix;
    @Summary
    private final List<String> suffix;
    @Summary
    private final Period period;

    private HumanName(Builder builder) {
        super(builder);
        this.use = builder.use;
        this.text = builder.text;
        this.family = builder.family;
        this.given = Collections.unmodifiableList(builder.given);
        this.prefix = Collections.unmodifiableList(builder.prefix);
        this.suffix = Collections.unmodifiableList(builder.suffix);
        this.period = builder.period;
    }

    public NameUse getUse() {
        return this.use;
    }

    public String getText() {
        return this.text;
    }

    public String getFamily() {
        return this.family;
    }

    public List<String> getGiven() {
        return this.given;
    }

    public List<String> getPrefix() {
        return this.prefix;
    }

    public List<String> getSuffix() {
        return this.suffix;
    }

    public Period getPeriod() {
        return this.period;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.use != null || this.text != null || this.family != null || !this.given.isEmpty() || !this.prefix.isEmpty() || !this.suffix.isEmpty() || this.period != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.use, "use", visitor);
                this.accept(this.text, "text", visitor);
                this.accept(this.family, "family", visitor);
                this.accept(this.given, "given", visitor, String.class);
                this.accept(this.prefix, "prefix", visitor, String.class);
                this.accept(this.suffix, "suffix", visitor, String.class);
                this.accept(this.period, "period", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HumanName other = (HumanName)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.use, other.use) && Objects.equals(this.text, other.text) && Objects.equals(this.family, other.family) && Objects.equals(this.given, other.given) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.suffix, other.suffix) && Objects.equals(this.period, other.period);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.use, this.text, this.family, this.given, this.prefix, this.suffix, this.period);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private NameUse use;
        private String text;
        private String family;
        private List<String> given = new ArrayList<String>();
        private List<String> prefix = new ArrayList<String>();
        private List<String> suffix = new ArrayList<String>();
        private Period period;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder use(NameUse use) {
            this.use = use;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder family(String family) {
            this.family = family;
            return this;
        }

        public Builder given(String ... given) {
            for (String value : given) {
                this.given.add(value);
            }
            return this;
        }

        public Builder given(Collection<String> given) {
            this.given = new ArrayList<String>(given);
            return this;
        }

        public Builder prefix(String ... prefix) {
            for (String value : prefix) {
                this.prefix.add(value);
            }
            return this;
        }

        public Builder prefix(Collection<String> prefix) {
            this.prefix = new ArrayList<String>(prefix);
            return this;
        }

        public Builder suffix(String ... suffix) {
            for (String value : suffix) {
                this.suffix.add(value);
            }
            return this;
        }

        public Builder suffix(Collection<String> suffix) {
            this.suffix = new ArrayList<String>(suffix);
            return this;
        }

        public Builder period(Period period) {
            this.period = period;
            return this;
        }

        @Override
        public HumanName build() {
            HumanName humanName = new HumanName(this);
            if (this.validating) {
                this.validate(humanName);
            }
            return humanName;
        }

        protected void validate(HumanName humanName) {
            super.validate(humanName);
            ValidationSupport.checkList(humanName.given, "given", String.class);
            ValidationSupport.checkList(humanName.prefix, "prefix", String.class);
            ValidationSupport.checkList(humanName.suffix, "suffix", String.class);
            ValidationSupport.requireValueOrChildren(humanName);
        }

        protected Builder from(HumanName humanName) {
            super.from(humanName);
            this.use = humanName.use;
            this.text = humanName.text;
            this.family = humanName.family;
            this.given.addAll(humanName.given);
            this.prefix.addAll(humanName.prefix);
            this.suffix.addAll(humanName.suffix);
            this.period = humanName.period;
            return this;
        }
    }
}

