/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Constraint(id="meta-0", level="Warning", location="(base)", description="SHALL, if possible, contain a code from value set http://hl7.org/fhir/ValueSet/security-labels", expression="security.exists() implies (security.all(memberOf('http://hl7.org/fhir/ValueSet/security-labels', 'extensible')))", source="http://hl7.org/fhir/StructureDefinition/Meta", generated=true)
public class Meta
extends Element {
    @Summary
    private final Id versionId;
    @Summary
    private final Instant lastUpdated;
    @Summary
    private final Uri source;
    @Summary
    private final List<Canonical> profile;
    @Summary
    @Binding(bindingName="SecurityLabels", strength=BindingStrength.Value.EXTENSIBLE, description="Security Labels from the Healthcare Privacy and Security Classification System.", valueSet="http://hl7.org/fhir/ValueSet/security-labels")
    private final List<Coding> security;
    @Summary
    @Binding(bindingName="Tags", strength=BindingStrength.Value.EXAMPLE, description="Codes that represent various types of tags, commonly workflow-related; e.g. \"Needs review by Dr. Jones\".", valueSet="http://hl7.org/fhir/ValueSet/common-tags")
    private final List<Coding> tag;

    private Meta(Builder builder) {
        super(builder);
        this.versionId = builder.versionId;
        this.lastUpdated = builder.lastUpdated;
        this.source = builder.source;
        this.profile = Collections.unmodifiableList(builder.profile);
        this.security = Collections.unmodifiableList(builder.security);
        this.tag = Collections.unmodifiableList(builder.tag);
    }

    public Id getVersionId() {
        return this.versionId;
    }

    public Instant getLastUpdated() {
        return this.lastUpdated;
    }

    public Uri getSource() {
        return this.source;
    }

    public List<Canonical> getProfile() {
        return this.profile;
    }

    public List<Coding> getSecurity() {
        return this.security;
    }

    public List<Coding> getTag() {
        return this.tag;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.versionId != null || this.lastUpdated != null || this.source != null || !this.profile.isEmpty() || !this.security.isEmpty() || !this.tag.isEmpty();
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.versionId, "versionId", visitor);
                this.accept(this.lastUpdated, "lastUpdated", visitor);
                this.accept(this.source, "source", visitor);
                this.accept(this.profile, "profile", visitor, Canonical.class);
                this.accept(this.security, "security", visitor, Coding.class);
                this.accept(this.tag, "tag", visitor, Coding.class);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Meta other = (Meta)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.versionId, other.versionId) && Objects.equals(this.lastUpdated, other.lastUpdated) && Objects.equals(this.source, other.source) && Objects.equals(this.profile, other.profile) && Objects.equals(this.security, other.security) && Objects.equals(this.tag, other.tag);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.versionId, this.lastUpdated, this.source, this.profile, this.security, this.tag);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private Id versionId;
        private Instant lastUpdated;
        private Uri source;
        private List<Canonical> profile = new ArrayList<Canonical>();
        private List<Coding> security = new ArrayList<Coding>();
        private List<Coding> tag = new ArrayList<Coding>();

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder versionId(Id versionId) {
            this.versionId = versionId;
            return this;
        }

        public Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder source(Uri source) {
            this.source = source;
            return this;
        }

        public Builder profile(Canonical ... profile) {
            for (Canonical value : profile) {
                this.profile.add(value);
            }
            return this;
        }

        public Builder profile(Collection<Canonical> profile) {
            this.profile = new ArrayList<Canonical>(profile);
            return this;
        }

        public Builder security(Coding ... security) {
            for (Coding value : security) {
                this.security.add(value);
            }
            return this;
        }

        public Builder security(Collection<Coding> security) {
            this.security = new ArrayList<Coding>(security);
            return this;
        }

        public Builder tag(Coding ... tag) {
            for (Coding value : tag) {
                this.tag.add(value);
            }
            return this;
        }

        public Builder tag(Collection<Coding> tag) {
            this.tag = new ArrayList<Coding>(tag);
            return this;
        }

        @Override
        public Meta build() {
            Meta meta = new Meta(this);
            if (this.validating) {
                this.validate(meta);
            }
            return meta;
        }

        protected void validate(Meta meta) {
            super.validate(meta);
            ValidationSupport.checkList(meta.profile, "profile", Canonical.class);
            ValidationSupport.checkList(meta.security, "security", Coding.class);
            ValidationSupport.checkList(meta.tag, "tag", Coding.class);
            ValidationSupport.requireValueOrChildren(meta);
        }

        protected Builder from(Meta meta) {
            super.from(meta);
            this.versionId = meta.versionId;
            this.lastUpdated = meta.lastUpdated;
            this.source = meta.source;
            this.profile.addAll(meta.profile);
            this.security.addAll(meta.security);
            this.tag.addAll(meta.tag);
            return this;
        }
    }
}

