/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="mqty-1", level="Rule", location="Quantity", description="There SHALL be a code if there is a value and it SHALL be an expression of currency.  If system is present, it SHALL be ISO 4217 (system = \"urn:iso:std:iso:4217\" - currency).", expression="(code.exists() or value.empty()) and (system.empty() or system = 'urn:iso:std:iso:4217')", source="http://hl7.org/fhir/StructureDefinition/MoneyQuantity")
public class MoneyQuantity
extends Quantity {
    private MoneyQuantity(Builder builder) {
        super(builder);
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.comparator, "comparator", visitor);
                this.accept(this.unit, "unit", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.code, "code", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneyQuantity other = (MoneyQuantity)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.unit, other.unit) && Objects.equals(this.system, other.system) && Objects.equals(this.code, other.code);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value, this.comparator, this.unit, this.system, this.code);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Quantity.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(Decimal value) {
            return (Builder)super.value(value);
        }

        @Override
        public Builder comparator(QuantityComparator comparator) {
            return (Builder)super.comparator(comparator);
        }

        @Override
        public Builder unit(String unit) {
            return (Builder)super.unit(unit);
        }

        @Override
        public Builder system(Uri system) {
            return (Builder)super.system(system);
        }

        @Override
        public Builder code(Code code) {
            return (Builder)super.code(code);
        }

        @Override
        public MoneyQuantity build() {
            MoneyQuantity moneyQuantity = new MoneyQuantity(this);
            if (this.validating) {
                this.validate(moneyQuantity);
            }
            return moneyQuantity;
        }

        protected void validate(MoneyQuantity moneyQuantity) {
            super.validate(moneyQuantity);
        }

        protected Builder from(MoneyQuantity moneyQuantity) {
            super.from(moneyQuantity);
            return this;
        }
    }
}

