/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Constraints;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Xhtml;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.NarrativeStatus;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraints(value={@Constraint(id="txt-1", level="Rule", location="Narrative.`div`", description="The narrative SHALL contain only the basic html formatting elements and attributes described in chapters 7-11 (except section 4 of chapter 9) and 15 of the HTML 4.0 standard, <a> elements (either name or href), images and internally contained style attributes", expression="htmlChecks()", source="http://hl7.org/fhir/StructureDefinition/Narrative"), @Constraint(id="txt-2", level="Rule", location="Narrative.`div`", description="The narrative SHALL have some non-whitespace content", expression="htmlChecks()", source="http://hl7.org/fhir/StructureDefinition/Narrative")})
public class Narrative
extends Element {
    public static final Narrative EMPTY = Narrative.builder().status(NarrativeStatus.EMPTY).div(Xhtml.from("Narrative text intentionally left empty")).build();
    @Binding(bindingName="NarrativeStatus", strength=BindingStrength.Value.REQUIRED, description="The status of a resource narrative.", valueSet="http://hl7.org/fhir/ValueSet/narrative-status|4.0.1")
    @Required
    private final NarrativeStatus status;
    @Required
    private final Xhtml div;

    private Narrative(Builder builder) {
        super(builder);
        this.status = builder.status;
        this.div = builder.div;
    }

    public NarrativeStatus getStatus() {
        return this.status;
    }

    public Xhtml getDiv() {
        return this.div;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.status != null || this.div != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.status, "status", visitor);
                this.accept(this.div, "div", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Narrative other = (Narrative)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.status, other.status) && Objects.equals(this.div, other.div);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.status, this.div);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private NarrativeStatus status;
        private Xhtml div;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder status(NarrativeStatus status) {
            this.status = status;
            return this;
        }

        public Builder div(Xhtml div) {
            this.div = div;
            return this;
        }

        @Override
        public Narrative build() {
            Narrative narrative = new Narrative(this);
            if (this.validating) {
                this.validate(narrative);
            }
            return narrative;
        }

        protected void validate(Narrative narrative) {
            super.validate(narrative);
            ValidationSupport.requireNonNull(narrative.status, "status");
            ValidationSupport.requireNonNull(narrative.div, "div");
            ValidationSupport.requireValueOrChildren(narrative);
        }

        protected Builder from(Narrative narrative) {
            super.from(narrative);
            this.status = narrative.status;
            this.div = narrative.div;
            return this;
        }
    }
}

