/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProdCharacteristic
extends BackboneElement {
    @Summary
    private final Quantity height;
    @Summary
    private final Quantity width;
    @Summary
    private final Quantity depth;
    @Summary
    private final Quantity weight;
    @Summary
    private final Quantity nominalVolume;
    @Summary
    private final Quantity externalDiameter;
    @Summary
    private final String shape;
    @Summary
    private final List<String> color;
    @Summary
    private final List<String> imprint;
    @Summary
    private final List<Attachment> image;
    @Summary
    private final CodeableConcept scoring;

    private ProdCharacteristic(Builder builder) {
        super(builder);
        this.height = builder.height;
        this.width = builder.width;
        this.depth = builder.depth;
        this.weight = builder.weight;
        this.nominalVolume = builder.nominalVolume;
        this.externalDiameter = builder.externalDiameter;
        this.shape = builder.shape;
        this.color = Collections.unmodifiableList(builder.color);
        this.imprint = Collections.unmodifiableList(builder.imprint);
        this.image = Collections.unmodifiableList(builder.image);
        this.scoring = builder.scoring;
    }

    public Quantity getHeight() {
        return this.height;
    }

    public Quantity getWidth() {
        return this.width;
    }

    public Quantity getDepth() {
        return this.depth;
    }

    public Quantity getWeight() {
        return this.weight;
    }

    public Quantity getNominalVolume() {
        return this.nominalVolume;
    }

    public Quantity getExternalDiameter() {
        return this.externalDiameter;
    }

    public String getShape() {
        return this.shape;
    }

    public List<String> getColor() {
        return this.color;
    }

    public List<String> getImprint() {
        return this.imprint;
    }

    public List<Attachment> getImage() {
        return this.image;
    }

    public CodeableConcept getScoring() {
        return this.scoring;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.height != null || this.width != null || this.depth != null || this.weight != null || this.nominalVolume != null || this.externalDiameter != null || this.shape != null || !this.color.isEmpty() || !this.imprint.isEmpty() || !this.image.isEmpty() || this.scoring != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.height, "height", visitor);
                this.accept(this.width, "width", visitor);
                this.accept(this.depth, "depth", visitor);
                this.accept(this.weight, "weight", visitor);
                this.accept(this.nominalVolume, "nominalVolume", visitor);
                this.accept(this.externalDiameter, "externalDiameter", visitor);
                this.accept(this.shape, "shape", visitor);
                this.accept(this.color, "color", visitor, String.class);
                this.accept(this.imprint, "imprint", visitor, String.class);
                this.accept(this.image, "image", visitor, Attachment.class);
                this.accept(this.scoring, "scoring", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProdCharacteristic other = (ProdCharacteristic)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.height, other.height) && Objects.equals(this.width, other.width) && Objects.equals(this.depth, other.depth) && Objects.equals(this.weight, other.weight) && Objects.equals(this.nominalVolume, other.nominalVolume) && Objects.equals(this.externalDiameter, other.externalDiameter) && Objects.equals(this.shape, other.shape) && Objects.equals(this.color, other.color) && Objects.equals(this.imprint, other.imprint) && Objects.equals(this.image, other.image) && Objects.equals(this.scoring, other.scoring);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.height, this.width, this.depth, this.weight, this.nominalVolume, this.externalDiameter, this.shape, this.color, this.imprint, this.image, this.scoring);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BackboneElement.Builder {
        private Quantity height;
        private Quantity width;
        private Quantity depth;
        private Quantity weight;
        private Quantity nominalVolume;
        private Quantity externalDiameter;
        private String shape;
        private List<String> color = new ArrayList<String>();
        private List<String> imprint = new ArrayList<String>();
        private List<Attachment> image = new ArrayList<Attachment>();
        private CodeableConcept scoring;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder height(Quantity height) {
            this.height = height;
            return this;
        }

        public Builder width(Quantity width) {
            this.width = width;
            return this;
        }

        public Builder depth(Quantity depth) {
            this.depth = depth;
            return this;
        }

        public Builder weight(Quantity weight) {
            this.weight = weight;
            return this;
        }

        public Builder nominalVolume(Quantity nominalVolume) {
            this.nominalVolume = nominalVolume;
            return this;
        }

        public Builder externalDiameter(Quantity externalDiameter) {
            this.externalDiameter = externalDiameter;
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public Builder color(String ... color) {
            for (String value : color) {
                this.color.add(value);
            }
            return this;
        }

        public Builder color(Collection<String> color) {
            this.color = new ArrayList<String>(color);
            return this;
        }

        public Builder imprint(String ... imprint) {
            for (String value : imprint) {
                this.imprint.add(value);
            }
            return this;
        }

        public Builder imprint(Collection<String> imprint) {
            this.imprint = new ArrayList<String>(imprint);
            return this;
        }

        public Builder image(Attachment ... image) {
            for (Attachment value : image) {
                this.image.add(value);
            }
            return this;
        }

        public Builder image(Collection<Attachment> image) {
            this.image = new ArrayList<Attachment>(image);
            return this;
        }

        public Builder scoring(CodeableConcept scoring) {
            this.scoring = scoring;
            return this;
        }

        @Override
        public ProdCharacteristic build() {
            ProdCharacteristic prodCharacteristic = new ProdCharacteristic(this);
            if (this.validating) {
                this.validate(prodCharacteristic);
            }
            return prodCharacteristic;
        }

        protected void validate(ProdCharacteristic prodCharacteristic) {
            super.validate(prodCharacteristic);
            ValidationSupport.checkList(prodCharacteristic.color, "color", String.class);
            ValidationSupport.checkList(prodCharacteristic.imprint, "imprint", String.class);
            ValidationSupport.checkList(prodCharacteristic.image, "image", Attachment.class);
            ValidationSupport.requireValueOrChildren(prodCharacteristic);
        }

        protected Builder from(ProdCharacteristic prodCharacteristic) {
            super.from(prodCharacteristic);
            this.height = prodCharacteristic.height;
            this.width = prodCharacteristic.width;
            this.depth = prodCharacteristic.depth;
            this.weight = prodCharacteristic.weight;
            this.nominalVolume = prodCharacteristic.nominalVolume;
            this.externalDiameter = prodCharacteristic.externalDiameter;
            this.shape = prodCharacteristic.shape;
            this.color.addAll(prodCharacteristic.color);
            this.imprint.addAll(prodCharacteristic.imprint);
            this.image.addAll(prodCharacteristic.image);
            this.scoring = prodCharacteristic.scoring;
            return this;
        }
    }
}

