/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="rng-2", level="Rule", location="(base)", description="If present, low SHALL have a lower value than high", expression="low.empty() or high.empty() or (low <= high)", source="http://hl7.org/fhir/StructureDefinition/Range")
public class Range
extends Element {
    @Summary
    private final SimpleQuantity low;
    @Summary
    private final SimpleQuantity high;

    private Range(Builder builder) {
        super(builder);
        this.low = builder.low;
        this.high = builder.high;
    }

    public SimpleQuantity getLow() {
        return this.low;
    }

    public SimpleQuantity getHigh() {
        return this.high;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.low != null || this.high != null;
    }

    @Override
    public void accept(String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.low, "low", visitor);
                this.accept(this.high, "high", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.low, this.high);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private SimpleQuantity low;
        private SimpleQuantity high;

        private Builder() {
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder low(SimpleQuantity low) {
            this.low = low;
            return this;
        }

        public Builder high(SimpleQuantity high) {
            this.high = high;
            return this;
        }

        @Override
        public Range build() {
            Range range = new Range(this);
            if (this.validating) {
                this.validate(range);
            }
            return range;
        }

        protected void validate(Range range) {
            super.validate(range);
            ValidationSupport.requireValueOrChildren(range);
        }

        protected Builder from(Range range) {
            super.from(range);
            this.low = range.low;
            this.high = range.high;
            return this;
        }
    }
}

