/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.code.BindingStrength;
import com.ibm.fhir.model.type.code.RelatedArtifactType;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class RelatedArtifact
extends Element {
    @Summary
    @Binding(bindingName="RelatedArtifactType", strength=BindingStrength.Value.REQUIRED, description="The type of relationship to the related artifact.", valueSet="http://hl7.org/fhir/ValueSet/related-artifact-type|4.0.1")
    @Required
    private final RelatedArtifactType type;
    @Summary
    private final String label;
    @Summary
    private final String display;
    @Summary
    private final Markdown citation;
    @Summary
    private final Url url;
    @Summary
    private final Attachment document;
    @Summary
    private final Canonical resource;

    private RelatedArtifact(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.label = builder.label;
        this.display = builder.display;
        this.citation = builder.citation;
        this.url = builder.url;
        this.document = builder.document;
        this.resource = builder.resource;
    }

    public RelatedArtifactType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDisplay() {
        return this.display;
    }

    public Markdown getCitation() {
        return this.citation;
    }

    public Url getUrl() {
        return this.url;
    }

    public Attachment getDocument() {
        return this.document;
    }

    public Canonical getResource() {
        return this.resource;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.type != null || this.label != null || this.display != null || this.citation != null || this.url != null || this.document != null || this.resource != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.type, "type", visitor);
                this.accept(this.label, "label", visitor);
                this.accept(this.display, "display", visitor);
                this.accept(this.citation, "citation", visitor);
                this.accept(this.url, "url", visitor);
                this.accept(this.document, "document", visitor);
                this.accept(this.resource, "resource", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelatedArtifact other = (RelatedArtifact)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.type, other.type) && Objects.equals(this.label, other.label) && Objects.equals(this.display, other.display) && Objects.equals(this.citation, other.citation) && Objects.equals(this.url, other.url) && Objects.equals(this.document, other.document) && Objects.equals(this.resource, other.resource);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.type, this.label, this.display, this.citation, this.url, this.document, this.resource);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Element.Builder {
        private RelatedArtifactType type;
        private String label;
        private String display;
        private Markdown citation;
        private Url url;
        private Attachment document;
        private Canonical resource;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension(extension);
        }

        public Builder type(RelatedArtifactType type) {
            this.type = type;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder display(String display) {
            this.display = display;
            return this;
        }

        public Builder citation(Markdown citation) {
            this.citation = citation;
            return this;
        }

        public Builder url(Url url) {
            this.url = url;
            return this;
        }

        public Builder document(Attachment document) {
            this.document = document;
            return this;
        }

        public Builder resource(Canonical resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public RelatedArtifact build() {
            RelatedArtifact relatedArtifact = new RelatedArtifact(this);
            if (this.validating) {
                this.validate(relatedArtifact);
            }
            return relatedArtifact;
        }

        protected void validate(RelatedArtifact relatedArtifact) {
            super.validate(relatedArtifact);
            ValidationSupport.requireNonNull(relatedArtifact.type, "type");
            ValidationSupport.requireValueOrChildren(relatedArtifact);
        }

        protected Builder from(RelatedArtifact relatedArtifact) {
            super.from(relatedArtifact);
            this.type = relatedArtifact.type;
            this.label = relatedArtifact.label;
            this.display = relatedArtifact.display;
            this.citation = relatedArtifact.citation;
            this.url = relatedArtifact.url;
            this.document = relatedArtifact.document;
            this.resource = relatedArtifact.resource;
            return this;
        }
    }
}

