/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.QuantityComparator;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

@Constraint(id="sqty-1", level="Rule", location="Quantity", description="The comparator is not used on a SimpleQuantity", expression="comparator.empty()", source="http://hl7.org/fhir/StructureDefinition/SimpleQuantity", modelChecked=true)
public class SimpleQuantity
extends Quantity {
    private SimpleQuantity(Builder builder) {
        super(builder);
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.value, "value", visitor);
                this.accept(this.comparator, "comparator", visitor);
                this.accept(this.unit, "unit", visitor);
                this.accept(this.system, "system", visitor);
                this.accept(this.code, "code", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleQuantity other = (SimpleQuantity)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value) && Objects.equals(this.comparator, other.comparator) && Objects.equals(this.unit, other.unit) && Objects.equals(this.system, other.system) && Objects.equals(this.code, other.code);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value, this.comparator, this.unit, this.system, this.code);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Quantity.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(Decimal value) {
            return (Builder)super.value(value);
        }

        @Override
        public Builder comparator(QuantityComparator comparator) {
            return (Builder)super.comparator(comparator);
        }

        @Override
        public Builder unit(String unit) {
            return (Builder)super.unit(unit);
        }

        @Override
        public Builder system(Uri system) {
            return (Builder)super.system(system);
        }

        @Override
        public Builder code(Code code) {
            return (Builder)super.code(code);
        }

        @Override
        public SimpleQuantity build() {
            SimpleQuantity simpleQuantity = new SimpleQuantity(this);
            if (this.validating) {
                this.validate(simpleQuantity);
            }
            return simpleQuantity;
        }

        protected void validate(SimpleQuantity simpleQuantity) {
            super.validate(simpleQuantity);
            ValidationSupport.prohibited(simpleQuantity.comparator, "comparator");
        }

        protected Builder from(SimpleQuantity simpleQuantity) {
            super.from(simpleQuantity);
            return this;
        }
    }
}

