/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type;

import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.util.ValidationSupport;
import com.ibm.fhir.model.visitor.Visitor;
import java.util.Collection;
import java.util.Objects;

public class SubstanceAmount
extends BackboneElement {
    @Summary
    @Choice(value={Quantity.class, Range.class, String.class})
    private final Element amount;
    @Summary
    private final CodeableConcept amountType;
    @Summary
    private final String amountText;
    @Summary
    private final ReferenceRange referenceRange;

    private SubstanceAmount(Builder builder) {
        super(builder);
        this.amount = builder.amount;
        this.amountType = builder.amountType;
        this.amountText = builder.amountText;
        this.referenceRange = builder.referenceRange;
    }

    public Element getAmount() {
        return this.amount;
    }

    public CodeableConcept getAmountType() {
        return this.amountType;
    }

    public String getAmountText() {
        return this.amountText;
    }

    public ReferenceRange getReferenceRange() {
        return this.referenceRange;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.amount != null || this.amountType != null || this.amountText != null || this.referenceRange != null;
    }

    @Override
    public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
        if (visitor.preVisit(this)) {
            visitor.visitStart(elementName, elementIndex, this);
            if (visitor.visit(elementName, elementIndex, this)) {
                this.accept(this.id, "id", visitor);
                this.accept(this.extension, "extension", visitor, Extension.class);
                this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                this.accept(this.amount, "amount", visitor);
                this.accept(this.amountType, "amountType", visitor);
                this.accept(this.amountText, "amountText", visitor);
                this.accept(this.referenceRange, "referenceRange", visitor);
            }
            visitor.visitEnd(elementName, elementIndex, this);
            visitor.postVisit(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstanceAmount other = (SubstanceAmount)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.amount, other.amount) && Objects.equals(this.amountType, other.amountType) && Objects.equals(this.amountText, other.amountText) && Objects.equals(this.referenceRange, other.referenceRange);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.amount, this.amountType, this.amountText, this.referenceRange);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ReferenceRange
    extends BackboneElement {
        @Summary
        private final Quantity lowLimit;
        @Summary
        private final Quantity highLimit;

        private ReferenceRange(Builder builder) {
            super(builder);
            this.lowLimit = builder.lowLimit;
            this.highLimit = builder.highLimit;
        }

        public Quantity getLowLimit() {
            return this.lowLimit;
        }

        public Quantity getHighLimit() {
            return this.highLimit;
        }

        @Override
        public boolean hasChildren() {
            return super.hasChildren() || this.lowLimit != null || this.highLimit != null;
        }

        @Override
        public void accept(java.lang.String elementName, int elementIndex, Visitor visitor) {
            if (visitor.preVisit(this)) {
                visitor.visitStart(elementName, elementIndex, this);
                if (visitor.visit(elementName, elementIndex, this)) {
                    this.accept(this.id, "id", visitor);
                    this.accept(this.extension, "extension", visitor, Extension.class);
                    this.accept(this.modifierExtension, "modifierExtension", visitor, Extension.class);
                    this.accept(this.lowLimit, "lowLimit", visitor);
                    this.accept(this.highLimit, "highLimit", visitor);
                }
                visitor.visitEnd(elementName, elementIndex, this);
                visitor.postVisit(this);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceRange other = (ReferenceRange)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.modifierExtension, other.modifierExtension) && Objects.equals(this.lowLimit, other.lowLimit) && Objects.equals(this.highLimit, other.highLimit);
        }

        public int hashCode() {
            int result = this.hashCode;
            if (result == 0) {
                this.hashCode = result = Objects.hash(this.id, this.extension, this.modifierExtension, this.lowLimit, this.highLimit);
            }
            return result;
        }

        @Override
        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends BackboneElement.Builder {
            private Quantity lowLimit;
            private Quantity highLimit;

            private Builder() {
            }

            @Override
            public Builder id(java.lang.String id) {
                return (Builder)super.id(id);
            }

            @Override
            public Builder extension(Extension ... extension) {
                return (Builder)super.extension(extension);
            }

            @Override
            public Builder extension(Collection<Extension> extension) {
                return (Builder)super.extension((Collection)extension);
            }

            @Override
            public Builder modifierExtension(Extension ... modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            @Override
            public Builder modifierExtension(Collection<Extension> modifierExtension) {
                return (Builder)super.modifierExtension(modifierExtension);
            }

            public Builder lowLimit(Quantity lowLimit) {
                this.lowLimit = lowLimit;
                return this;
            }

            public Builder highLimit(Quantity highLimit) {
                this.highLimit = highLimit;
                return this;
            }

            @Override
            public ReferenceRange build() {
                ReferenceRange referenceRange = new ReferenceRange(this);
                if (this.validating) {
                    this.validate(referenceRange);
                }
                return referenceRange;
            }

            protected void validate(ReferenceRange referenceRange) {
                super.validate(referenceRange);
                ValidationSupport.requireValueOrChildren(referenceRange);
            }

            protected Builder from(ReferenceRange referenceRange) {
                super.from(referenceRange);
                this.lowLimit = referenceRange.lowLimit;
                this.highLimit = referenceRange.highLimit;
                return this;
            }
        }
    }

    public static class Builder
    extends BackboneElement.Builder {
        private Element amount;
        private CodeableConcept amountType;
        private String amountText;
        private ReferenceRange referenceRange;

        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder modifierExtension(Extension ... modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        @Override
        public Builder modifierExtension(Collection<Extension> modifierExtension) {
            return (Builder)super.modifierExtension(modifierExtension);
        }

        public Builder amount(Element amount) {
            this.amount = amount;
            return this;
        }

        public Builder amountType(CodeableConcept amountType) {
            this.amountType = amountType;
            return this;
        }

        public Builder amountText(String amountText) {
            this.amountText = amountText;
            return this;
        }

        public Builder referenceRange(ReferenceRange referenceRange) {
            this.referenceRange = referenceRange;
            return this;
        }

        @Override
        public SubstanceAmount build() {
            SubstanceAmount substanceAmount = new SubstanceAmount(this);
            if (this.validating) {
                this.validate(substanceAmount);
            }
            return substanceAmount;
        }

        protected void validate(SubstanceAmount substanceAmount) {
            super.validate(substanceAmount);
            ValidationSupport.choiceElement(substanceAmount.amount, "amount", Quantity.class, Range.class, String.class);
            ValidationSupport.requireValueOrChildren(substanceAmount);
        }

        protected Builder from(SubstanceAmount substanceAmount) {
            super.from(substanceAmount);
            this.amount = substanceAmount.amount;
            this.amountType = substanceAmount.amountType;
            this.amountText = substanceAmount.amountText;
            this.referenceRange = substanceAmount.referenceRange;
            return this;
        }
    }
}

