/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/request-resource-types")
public class ActivityDefinitionKind
extends Code {
    public static final ActivityDefinitionKind APPOINTMENT = ActivityDefinitionKind.builder().value(Value.APPOINTMENT).build();
    public static final ActivityDefinitionKind APPOINTMENT_RESPONSE = ActivityDefinitionKind.builder().value(Value.APPOINTMENT_RESPONSE).build();
    public static final ActivityDefinitionKind CARE_PLAN = ActivityDefinitionKind.builder().value(Value.CARE_PLAN).build();
    public static final ActivityDefinitionKind CLAIM = ActivityDefinitionKind.builder().value(Value.CLAIM).build();
    public static final ActivityDefinitionKind COMMUNICATION_REQUEST = ActivityDefinitionKind.builder().value(Value.COMMUNICATION_REQUEST).build();
    public static final ActivityDefinitionKind CONTRACT = ActivityDefinitionKind.builder().value(Value.CONTRACT).build();
    public static final ActivityDefinitionKind DEVICE_REQUEST = ActivityDefinitionKind.builder().value(Value.DEVICE_REQUEST).build();
    public static final ActivityDefinitionKind ENROLLMENT_REQUEST = ActivityDefinitionKind.builder().value(Value.ENROLLMENT_REQUEST).build();
    public static final ActivityDefinitionKind IMMUNIZATION_RECOMMENDATION = ActivityDefinitionKind.builder().value(Value.IMMUNIZATION_RECOMMENDATION).build();
    public static final ActivityDefinitionKind MEDICATION_REQUEST = ActivityDefinitionKind.builder().value(Value.MEDICATION_REQUEST).build();
    public static final ActivityDefinitionKind NUTRITION_ORDER = ActivityDefinitionKind.builder().value(Value.NUTRITION_ORDER).build();
    public static final ActivityDefinitionKind SERVICE_REQUEST = ActivityDefinitionKind.builder().value(Value.SERVICE_REQUEST).build();
    public static final ActivityDefinitionKind SUPPLY_REQUEST = ActivityDefinitionKind.builder().value(Value.SUPPLY_REQUEST).build();
    public static final ActivityDefinitionKind TASK = ActivityDefinitionKind.builder().value(Value.TASK).build();
    public static final ActivityDefinitionKind VISION_PRESCRIPTION = ActivityDefinitionKind.builder().value(Value.VISION_PRESCRIPTION).build();
    private volatile int hashCode;

    private ActivityDefinitionKind(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static ActivityDefinitionKind of(ValueSet value) {
        switch (value) {
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CLAIM: {
                return CLAIM;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActivityDefinitionKind of(Value value) {
        switch (value) {
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CLAIM: {
                return CLAIM;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActivityDefinitionKind of(java.lang.String value) {
        return ActivityDefinitionKind.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ActivityDefinitionKind.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ActivityDefinitionKind.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityDefinitionKind other = (ActivityDefinitionKind)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        CARE_PLAN("CarePlan"),
        CLAIM("Claim"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        CONTRACT("Contract"),
        DEVICE_REQUEST("DeviceRequest"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        MEDICATION_REQUEST("MedicationRequest"),
        NUTRITION_ORDER("NutritionOrder"),
        SERVICE_REQUEST("ServiceRequest"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Appointment": {
                    return APPOINTMENT;
                }
                case "AppointmentResponse": {
                    return APPOINTMENT_RESPONSE;
                }
                case "CarePlan": {
                    return CARE_PLAN;
                }
                case "Claim": {
                    return CLAIM;
                }
                case "CommunicationRequest": {
                    return COMMUNICATION_REQUEST;
                }
                case "Contract": {
                    return CONTRACT;
                }
                case "DeviceRequest": {
                    return DEVICE_REQUEST;
                }
                case "EnrollmentRequest": {
                    return ENROLLMENT_REQUEST;
                }
                case "ImmunizationRecommendation": {
                    return IMMUNIZATION_RECOMMENDATION;
                }
                case "MedicationRequest": {
                    return MEDICATION_REQUEST;
                }
                case "NutritionOrder": {
                    return NUTRITION_ORDER;
                }
                case "ServiceRequest": {
                    return SERVICE_REQUEST;
                }
                case "SupplyRequest": {
                    return SUPPLY_REQUEST;
                }
                case "Task": {
                    return TASK;
                }
                case "VisionPrescription": {
                    return VISION_PRESCRIPTION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        CARE_PLAN("CarePlan"),
        CLAIM("Claim"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        CONTRACT("Contract"),
        DEVICE_REQUEST("DeviceRequest"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        MEDICATION_REQUEST("MedicationRequest"),
        NUTRITION_ORDER("NutritionOrder"),
        SERVICE_REQUEST("ServiceRequest"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ActivityDefinitionKind build() {
            ActivityDefinitionKind activityDefinitionKind = new ActivityDefinitionKind(this);
            if (this.validating) {
                this.validate(activityDefinitionKind);
            }
            return activityDefinitionKind;
        }

        protected void validate(ActivityDefinitionKind activityDefinitionKind) {
            super.validate(activityDefinitionKind);
        }

        protected Builder from(ActivityDefinitionKind activityDefinitionKind) {
            super.from(activityDefinitionKind);
            return this;
        }
    }
}

