/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/action-participant-type")
public class ActivityParticipantType
extends Code {
    public static final ActivityParticipantType PATIENT = ActivityParticipantType.builder().value(Value.PATIENT).build();
    public static final ActivityParticipantType PRACTITIONER = ActivityParticipantType.builder().value(Value.PRACTITIONER).build();
    public static final ActivityParticipantType RELATED_PERSON = ActivityParticipantType.builder().value(Value.RELATED_PERSON).build();
    public static final ActivityParticipantType DEVICE = ActivityParticipantType.builder().value(Value.DEVICE).build();
    private volatile int hashCode;

    private ActivityParticipantType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static ActivityParticipantType of(ValueSet value) {
        switch (value) {
            case PATIENT: {
                return PATIENT;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case DEVICE: {
                return DEVICE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActivityParticipantType of(Value value) {
        switch (value) {
            case PATIENT: {
                return PATIENT;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case DEVICE: {
                return DEVICE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ActivityParticipantType of(java.lang.String value) {
        return ActivityParticipantType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ActivityParticipantType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ActivityParticipantType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityParticipantType other = (ActivityParticipantType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PATIENT("patient"),
        PRACTITIONER("practitioner"),
        RELATED_PERSON("related-person"),
        DEVICE("device");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "patient": {
                    return PATIENT;
                }
                case "practitioner": {
                    return PRACTITIONER;
                }
                case "related-person": {
                    return RELATED_PERSON;
                }
                case "device": {
                    return DEVICE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        PATIENT("patient"),
        PRACTITIONER("practitioner"),
        RELATED_PERSON("related-person"),
        DEVICE("device");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ActivityParticipantType build() {
            ActivityParticipantType activityParticipantType = new ActivityParticipantType(this);
            if (this.validating) {
                this.validate(activityParticipantType);
            }
            return activityParticipantType;
        }

        protected void validate(ActivityParticipantType activityParticipantType) {
            super.validate(activityParticipantType);
        }

        protected Builder from(ActivityParticipantType activityParticipantType) {
            super.from(activityParticipantType);
            return this;
        }
    }
}

