/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/assert-response-code-types")
public class AssertionResponseTypes
extends Code {
    public static final AssertionResponseTypes OKAY = AssertionResponseTypes.builder().value(Value.OKAY).build();
    public static final AssertionResponseTypes CREATED = AssertionResponseTypes.builder().value(Value.CREATED).build();
    public static final AssertionResponseTypes NO_CONTENT = AssertionResponseTypes.builder().value(Value.NO_CONTENT).build();
    public static final AssertionResponseTypes NOT_MODIFIED = AssertionResponseTypes.builder().value(Value.NOT_MODIFIED).build();
    public static final AssertionResponseTypes BAD = AssertionResponseTypes.builder().value(Value.BAD).build();
    public static final AssertionResponseTypes FORBIDDEN = AssertionResponseTypes.builder().value(Value.FORBIDDEN).build();
    public static final AssertionResponseTypes NOT_FOUND = AssertionResponseTypes.builder().value(Value.NOT_FOUND).build();
    public static final AssertionResponseTypes METHOD_NOT_ALLOWED = AssertionResponseTypes.builder().value(Value.METHOD_NOT_ALLOWED).build();
    public static final AssertionResponseTypes CONFLICT = AssertionResponseTypes.builder().value(Value.CONFLICT).build();
    public static final AssertionResponseTypes GONE = AssertionResponseTypes.builder().value(Value.GONE).build();
    public static final AssertionResponseTypes PRECONDITION_FAILED = AssertionResponseTypes.builder().value(Value.PRECONDITION_FAILED).build();
    public static final AssertionResponseTypes UNPROCESSABLE = AssertionResponseTypes.builder().value(Value.UNPROCESSABLE).build();
    private volatile int hashCode;

    private AssertionResponseTypes(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static AssertionResponseTypes of(ValueSet value) {
        switch (value) {
            case OKAY: {
                return OKAY;
            }
            case CREATED: {
                return CREATED;
            }
            case NO_CONTENT: {
                return NO_CONTENT;
            }
            case NOT_MODIFIED: {
                return NOT_MODIFIED;
            }
            case BAD: {
                return BAD;
            }
            case FORBIDDEN: {
                return FORBIDDEN;
            }
            case NOT_FOUND: {
                return NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return METHOD_NOT_ALLOWED;
            }
            case CONFLICT: {
                return CONFLICT;
            }
            case GONE: {
                return GONE;
            }
            case PRECONDITION_FAILED: {
                return PRECONDITION_FAILED;
            }
            case UNPROCESSABLE: {
                return UNPROCESSABLE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AssertionResponseTypes of(Value value) {
        switch (value) {
            case OKAY: {
                return OKAY;
            }
            case CREATED: {
                return CREATED;
            }
            case NO_CONTENT: {
                return NO_CONTENT;
            }
            case NOT_MODIFIED: {
                return NOT_MODIFIED;
            }
            case BAD: {
                return BAD;
            }
            case FORBIDDEN: {
                return FORBIDDEN;
            }
            case NOT_FOUND: {
                return NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return METHOD_NOT_ALLOWED;
            }
            case CONFLICT: {
                return CONFLICT;
            }
            case GONE: {
                return GONE;
            }
            case PRECONDITION_FAILED: {
                return PRECONDITION_FAILED;
            }
            case UNPROCESSABLE: {
                return UNPROCESSABLE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static AssertionResponseTypes of(java.lang.String value) {
        return AssertionResponseTypes.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return AssertionResponseTypes.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return AssertionResponseTypes.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssertionResponseTypes other = (AssertionResponseTypes)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        OKAY("okay"),
        CREATED("created"),
        NO_CONTENT("noContent"),
        NOT_MODIFIED("notModified"),
        BAD("bad"),
        FORBIDDEN("forbidden"),
        NOT_FOUND("notFound"),
        METHOD_NOT_ALLOWED("methodNotAllowed"),
        CONFLICT("conflict"),
        GONE("gone"),
        PRECONDITION_FAILED("preconditionFailed"),
        UNPROCESSABLE("unprocessable");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "okay": {
                    return OKAY;
                }
                case "created": {
                    return CREATED;
                }
                case "noContent": {
                    return NO_CONTENT;
                }
                case "notModified": {
                    return NOT_MODIFIED;
                }
                case "bad": {
                    return BAD;
                }
                case "forbidden": {
                    return FORBIDDEN;
                }
                case "notFound": {
                    return NOT_FOUND;
                }
                case "methodNotAllowed": {
                    return METHOD_NOT_ALLOWED;
                }
                case "conflict": {
                    return CONFLICT;
                }
                case "gone": {
                    return GONE;
                }
                case "preconditionFailed": {
                    return PRECONDITION_FAILED;
                }
                case "unprocessable": {
                    return UNPROCESSABLE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        OKAY("okay"),
        CREATED("created"),
        NO_CONTENT("noContent"),
        NOT_MODIFIED("notModified"),
        BAD("bad"),
        FORBIDDEN("forbidden"),
        NOT_FOUND("notFound"),
        METHOD_NOT_ALLOWED("methodNotAllowed"),
        CONFLICT("conflict"),
        GONE("gone"),
        PRECONDITION_FAILED("preconditionFailed"),
        UNPROCESSABLE("unprocessable");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public AssertionResponseTypes build() {
            AssertionResponseTypes assertionResponseTypes = new AssertionResponseTypes(this);
            if (this.validating) {
                this.validate(assertionResponseTypes);
            }
            return assertionResponseTypes;
        }

        protected void validate(AssertionResponseTypes assertionResponseTypes) {
            super.validate(assertionResponseTypes);
        }

        protected Builder from(AssertionResponseTypes assertionResponseTypes) {
            super.from(assertionResponseTypes);
            return this;
        }
    }
}

