/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/encounter-status")
public class EncounterStatus
extends Code {
    public static final EncounterStatus PLANNED = EncounterStatus.builder().value(Value.PLANNED).build();
    public static final EncounterStatus ARRIVED = EncounterStatus.builder().value(Value.ARRIVED).build();
    public static final EncounterStatus TRIAGED = EncounterStatus.builder().value(Value.TRIAGED).build();
    public static final EncounterStatus IN_PROGRESS = EncounterStatus.builder().value(Value.IN_PROGRESS).build();
    public static final EncounterStatus ONLEAVE = EncounterStatus.builder().value(Value.ONLEAVE).build();
    public static final EncounterStatus FINISHED = EncounterStatus.builder().value(Value.FINISHED).build();
    public static final EncounterStatus CANCELLED = EncounterStatus.builder().value(Value.CANCELLED).build();
    public static final EncounterStatus ENTERED_IN_ERROR = EncounterStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final EncounterStatus UNKNOWN = EncounterStatus.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private EncounterStatus(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static EncounterStatus of(ValueSet value) {
        switch (value) {
            case PLANNED: {
                return PLANNED;
            }
            case ARRIVED: {
                return ARRIVED;
            }
            case TRIAGED: {
                return TRIAGED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ONLEAVE: {
                return ONLEAVE;
            }
            case FINISHED: {
                return FINISHED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static EncounterStatus of(Value value) {
        switch (value) {
            case PLANNED: {
                return PLANNED;
            }
            case ARRIVED: {
                return ARRIVED;
            }
            case TRIAGED: {
                return TRIAGED;
            }
            case IN_PROGRESS: {
                return IN_PROGRESS;
            }
            case ONLEAVE: {
                return ONLEAVE;
            }
            case FINISHED: {
                return FINISHED;
            }
            case CANCELLED: {
                return CANCELLED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static EncounterStatus of(java.lang.String value) {
        return EncounterStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return EncounterStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return EncounterStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EncounterStatus other = (EncounterStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PLANNED("planned"),
        ARRIVED("arrived"),
        TRIAGED("triaged"),
        IN_PROGRESS("in-progress"),
        ONLEAVE("onleave"),
        FINISHED("finished"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "planned": {
                    return PLANNED;
                }
                case "arrived": {
                    return ARRIVED;
                }
                case "triaged": {
                    return TRIAGED;
                }
                case "in-progress": {
                    return IN_PROGRESS;
                }
                case "onleave": {
                    return ONLEAVE;
                }
                case "finished": {
                    return FINISHED;
                }
                case "cancelled": {
                    return CANCELLED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        PLANNED("planned"),
        ARRIVED("arrived"),
        TRIAGED("triaged"),
        IN_PROGRESS("in-progress"),
        ONLEAVE("onleave"),
        FINISHED("finished"),
        CANCELLED("cancelled"),
        ENTERED_IN_ERROR("entered-in-error"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public EncounterStatus build() {
            EncounterStatus encounterStatus = new EncounterStatus(this);
            if (this.validating) {
                this.validate(encounterStatus);
            }
            return encounterStatus;
        }

        protected void validate(EncounterStatus encounterStatus) {
            super.validate(encounterStatus);
        }

        protected Builder from(EncounterStatus encounterStatus) {
            super.from(encounterStatus);
            return this;
        }
    }
}

