/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/resource-types")
public class FHIRResourceType
extends Code {
    public static final FHIRResourceType ACCOUNT = FHIRResourceType.builder().value(Value.ACCOUNT).build();
    public static final FHIRResourceType ACTIVITY_DEFINITION = FHIRResourceType.builder().value(Value.ACTIVITY_DEFINITION).build();
    public static final FHIRResourceType ADVERSE_EVENT = FHIRResourceType.builder().value(Value.ADVERSE_EVENT).build();
    public static final FHIRResourceType ALLERGY_INTOLERANCE = FHIRResourceType.builder().value(Value.ALLERGY_INTOLERANCE).build();
    public static final FHIRResourceType APPOINTMENT = FHIRResourceType.builder().value(Value.APPOINTMENT).build();
    public static final FHIRResourceType APPOINTMENT_RESPONSE = FHIRResourceType.builder().value(Value.APPOINTMENT_RESPONSE).build();
    public static final FHIRResourceType AUDIT_EVENT = FHIRResourceType.builder().value(Value.AUDIT_EVENT).build();
    public static final FHIRResourceType BASIC = FHIRResourceType.builder().value(Value.BASIC).build();
    public static final FHIRResourceType BINARY = FHIRResourceType.builder().value(Value.BINARY).build();
    public static final FHIRResourceType BIOLOGICALLY_DERIVED_PRODUCT = FHIRResourceType.builder().value(Value.BIOLOGICALLY_DERIVED_PRODUCT).build();
    public static final FHIRResourceType BODY_STRUCTURE = FHIRResourceType.builder().value(Value.BODY_STRUCTURE).build();
    public static final FHIRResourceType BUNDLE = FHIRResourceType.builder().value(Value.BUNDLE).build();
    public static final FHIRResourceType CAPABILITY_STATEMENT = FHIRResourceType.builder().value(Value.CAPABILITY_STATEMENT).build();
    public static final FHIRResourceType CARE_PLAN = FHIRResourceType.builder().value(Value.CARE_PLAN).build();
    public static final FHIRResourceType CARE_TEAM = FHIRResourceType.builder().value(Value.CARE_TEAM).build();
    public static final FHIRResourceType CATALOG_ENTRY = FHIRResourceType.builder().value(Value.CATALOG_ENTRY).build();
    public static final FHIRResourceType CHARGE_ITEM = FHIRResourceType.builder().value(Value.CHARGE_ITEM).build();
    public static final FHIRResourceType CHARGE_ITEM_DEFINITION = FHIRResourceType.builder().value(Value.CHARGE_ITEM_DEFINITION).build();
    public static final FHIRResourceType CLAIM = FHIRResourceType.builder().value(Value.CLAIM).build();
    public static final FHIRResourceType CLAIM_RESPONSE = FHIRResourceType.builder().value(Value.CLAIM_RESPONSE).build();
    public static final FHIRResourceType CLINICAL_IMPRESSION = FHIRResourceType.builder().value(Value.CLINICAL_IMPRESSION).build();
    public static final FHIRResourceType CODE_SYSTEM = FHIRResourceType.builder().value(Value.CODE_SYSTEM).build();
    public static final FHIRResourceType COMMUNICATION = FHIRResourceType.builder().value(Value.COMMUNICATION).build();
    public static final FHIRResourceType COMMUNICATION_REQUEST = FHIRResourceType.builder().value(Value.COMMUNICATION_REQUEST).build();
    public static final FHIRResourceType COMPARTMENT_DEFINITION = FHIRResourceType.builder().value(Value.COMPARTMENT_DEFINITION).build();
    public static final FHIRResourceType COMPOSITION = FHIRResourceType.builder().value(Value.COMPOSITION).build();
    public static final FHIRResourceType CONCEPT_MAP = FHIRResourceType.builder().value(Value.CONCEPT_MAP).build();
    public static final FHIRResourceType CONDITION = FHIRResourceType.builder().value(Value.CONDITION).build();
    public static final FHIRResourceType CONSENT = FHIRResourceType.builder().value(Value.CONSENT).build();
    public static final FHIRResourceType CONTRACT = FHIRResourceType.builder().value(Value.CONTRACT).build();
    public static final FHIRResourceType COVERAGE = FHIRResourceType.builder().value(Value.COVERAGE).build();
    public static final FHIRResourceType COVERAGE_ELIGIBILITY_REQUEST = FHIRResourceType.builder().value(Value.COVERAGE_ELIGIBILITY_REQUEST).build();
    public static final FHIRResourceType COVERAGE_ELIGIBILITY_RESPONSE = FHIRResourceType.builder().value(Value.COVERAGE_ELIGIBILITY_RESPONSE).build();
    public static final FHIRResourceType DETECTED_ISSUE = FHIRResourceType.builder().value(Value.DETECTED_ISSUE).build();
    public static final FHIRResourceType DEVICE = FHIRResourceType.builder().value(Value.DEVICE).build();
    public static final FHIRResourceType DEVICE_DEFINITION = FHIRResourceType.builder().value(Value.DEVICE_DEFINITION).build();
    public static final FHIRResourceType DEVICE_METRIC = FHIRResourceType.builder().value(Value.DEVICE_METRIC).build();
    public static final FHIRResourceType DEVICE_REQUEST = FHIRResourceType.builder().value(Value.DEVICE_REQUEST).build();
    public static final FHIRResourceType DEVICE_USE_STATEMENT = FHIRResourceType.builder().value(Value.DEVICE_USE_STATEMENT).build();
    public static final FHIRResourceType DIAGNOSTIC_REPORT = FHIRResourceType.builder().value(Value.DIAGNOSTIC_REPORT).build();
    public static final FHIRResourceType DOCUMENT_MANIFEST = FHIRResourceType.builder().value(Value.DOCUMENT_MANIFEST).build();
    public static final FHIRResourceType DOCUMENT_REFERENCE = FHIRResourceType.builder().value(Value.DOCUMENT_REFERENCE).build();
    public static final FHIRResourceType DOMAIN_RESOURCE = FHIRResourceType.builder().value(Value.DOMAIN_RESOURCE).build();
    public static final FHIRResourceType EFFECT_EVIDENCE_SYNTHESIS = FHIRResourceType.builder().value(Value.EFFECT_EVIDENCE_SYNTHESIS).build();
    public static final FHIRResourceType ENCOUNTER = FHIRResourceType.builder().value(Value.ENCOUNTER).build();
    public static final FHIRResourceType ENDPOINT = FHIRResourceType.builder().value(Value.ENDPOINT).build();
    public static final FHIRResourceType ENROLLMENT_REQUEST = FHIRResourceType.builder().value(Value.ENROLLMENT_REQUEST).build();
    public static final FHIRResourceType ENROLLMENT_RESPONSE = FHIRResourceType.builder().value(Value.ENROLLMENT_RESPONSE).build();
    public static final FHIRResourceType EPISODE_OF_CARE = FHIRResourceType.builder().value(Value.EPISODE_OF_CARE).build();
    public static final FHIRResourceType EVENT_DEFINITION = FHIRResourceType.builder().value(Value.EVENT_DEFINITION).build();
    public static final FHIRResourceType EVIDENCE = FHIRResourceType.builder().value(Value.EVIDENCE).build();
    public static final FHIRResourceType EVIDENCE_VARIABLE = FHIRResourceType.builder().value(Value.EVIDENCE_VARIABLE).build();
    public static final FHIRResourceType EXAMPLE_SCENARIO = FHIRResourceType.builder().value(Value.EXAMPLE_SCENARIO).build();
    public static final FHIRResourceType EXPLANATION_OF_BENEFIT = FHIRResourceType.builder().value(Value.EXPLANATION_OF_BENEFIT).build();
    public static final FHIRResourceType FAMILY_MEMBER_HISTORY = FHIRResourceType.builder().value(Value.FAMILY_MEMBER_HISTORY).build();
    public static final FHIRResourceType FLAG = FHIRResourceType.builder().value(Value.FLAG).build();
    public static final FHIRResourceType GOAL = FHIRResourceType.builder().value(Value.GOAL).build();
    public static final FHIRResourceType GRAPH_DEFINITION = FHIRResourceType.builder().value(Value.GRAPH_DEFINITION).build();
    public static final FHIRResourceType GROUP = FHIRResourceType.builder().value(Value.GROUP).build();
    public static final FHIRResourceType GUIDANCE_RESPONSE = FHIRResourceType.builder().value(Value.GUIDANCE_RESPONSE).build();
    public static final FHIRResourceType HEALTHCARE_SERVICE = FHIRResourceType.builder().value(Value.HEALTHCARE_SERVICE).build();
    public static final FHIRResourceType IMAGING_STUDY = FHIRResourceType.builder().value(Value.IMAGING_STUDY).build();
    public static final FHIRResourceType IMMUNIZATION = FHIRResourceType.builder().value(Value.IMMUNIZATION).build();
    public static final FHIRResourceType IMMUNIZATION_EVALUATION = FHIRResourceType.builder().value(Value.IMMUNIZATION_EVALUATION).build();
    public static final FHIRResourceType IMMUNIZATION_RECOMMENDATION = FHIRResourceType.builder().value(Value.IMMUNIZATION_RECOMMENDATION).build();
    public static final FHIRResourceType IMPLEMENTATION_GUIDE = FHIRResourceType.builder().value(Value.IMPLEMENTATION_GUIDE).build();
    public static final FHIRResourceType INSURANCE_PLAN = FHIRResourceType.builder().value(Value.INSURANCE_PLAN).build();
    public static final FHIRResourceType INVOICE = FHIRResourceType.builder().value(Value.INVOICE).build();
    public static final FHIRResourceType LIBRARY = FHIRResourceType.builder().value(Value.LIBRARY).build();
    public static final FHIRResourceType LINKAGE = FHIRResourceType.builder().value(Value.LINKAGE).build();
    public static final FHIRResourceType LIST = FHIRResourceType.builder().value(Value.LIST).build();
    public static final FHIRResourceType LOCATION = FHIRResourceType.builder().value(Value.LOCATION).build();
    public static final FHIRResourceType MEASURE = FHIRResourceType.builder().value(Value.MEASURE).build();
    public static final FHIRResourceType MEASURE_REPORT = FHIRResourceType.builder().value(Value.MEASURE_REPORT).build();
    public static final FHIRResourceType MEDIA = FHIRResourceType.builder().value(Value.MEDIA).build();
    public static final FHIRResourceType MEDICATION = FHIRResourceType.builder().value(Value.MEDICATION).build();
    public static final FHIRResourceType MEDICATION_ADMINISTRATION = FHIRResourceType.builder().value(Value.MEDICATION_ADMINISTRATION).build();
    public static final FHIRResourceType MEDICATION_DISPENSE = FHIRResourceType.builder().value(Value.MEDICATION_DISPENSE).build();
    public static final FHIRResourceType MEDICATION_KNOWLEDGE = FHIRResourceType.builder().value(Value.MEDICATION_KNOWLEDGE).build();
    public static final FHIRResourceType MEDICATION_REQUEST = FHIRResourceType.builder().value(Value.MEDICATION_REQUEST).build();
    public static final FHIRResourceType MEDICATION_STATEMENT = FHIRResourceType.builder().value(Value.MEDICATION_STATEMENT).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_AUTHORIZATION = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_AUTHORIZATION).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_CONTRAINDICATION = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_CONTRAINDICATION).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_INDICATION = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_INDICATION).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_INGREDIENT = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_INGREDIENT).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_INTERACTION = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_INTERACTION).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_MANUFACTURED = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_MANUFACTURED).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_PACKAGED = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_PACKAGED).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_PHARMACEUTICAL = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_PHARMACEUTICAL).build();
    public static final FHIRResourceType MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT = FHIRResourceType.builder().value(Value.MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT).build();
    public static final FHIRResourceType MESSAGE_DEFINITION = FHIRResourceType.builder().value(Value.MESSAGE_DEFINITION).build();
    public static final FHIRResourceType MESSAGE_HEADER = FHIRResourceType.builder().value(Value.MESSAGE_HEADER).build();
    public static final FHIRResourceType MOLECULAR_SEQUENCE = FHIRResourceType.builder().value(Value.MOLECULAR_SEQUENCE).build();
    public static final FHIRResourceType NAMING_SYSTEM = FHIRResourceType.builder().value(Value.NAMING_SYSTEM).build();
    public static final FHIRResourceType NUTRITION_ORDER = FHIRResourceType.builder().value(Value.NUTRITION_ORDER).build();
    public static final FHIRResourceType OBSERVATION = FHIRResourceType.builder().value(Value.OBSERVATION).build();
    public static final FHIRResourceType OBSERVATION_DEFINITION = FHIRResourceType.builder().value(Value.OBSERVATION_DEFINITION).build();
    public static final FHIRResourceType OPERATION_DEFINITION = FHIRResourceType.builder().value(Value.OPERATION_DEFINITION).build();
    public static final FHIRResourceType OPERATION_OUTCOME = FHIRResourceType.builder().value(Value.OPERATION_OUTCOME).build();
    public static final FHIRResourceType ORGANIZATION = FHIRResourceType.builder().value(Value.ORGANIZATION).build();
    public static final FHIRResourceType ORGANIZATION_AFFILIATION = FHIRResourceType.builder().value(Value.ORGANIZATION_AFFILIATION).build();
    public static final FHIRResourceType PARAMETERS = FHIRResourceType.builder().value(Value.PARAMETERS).build();
    public static final FHIRResourceType PATIENT = FHIRResourceType.builder().value(Value.PATIENT).build();
    public static final FHIRResourceType PAYMENT_NOTICE = FHIRResourceType.builder().value(Value.PAYMENT_NOTICE).build();
    public static final FHIRResourceType PAYMENT_RECONCILIATION = FHIRResourceType.builder().value(Value.PAYMENT_RECONCILIATION).build();
    public static final FHIRResourceType PERSON = FHIRResourceType.builder().value(Value.PERSON).build();
    public static final FHIRResourceType PLAN_DEFINITION = FHIRResourceType.builder().value(Value.PLAN_DEFINITION).build();
    public static final FHIRResourceType PRACTITIONER = FHIRResourceType.builder().value(Value.PRACTITIONER).build();
    public static final FHIRResourceType PRACTITIONER_ROLE = FHIRResourceType.builder().value(Value.PRACTITIONER_ROLE).build();
    public static final FHIRResourceType PROCEDURE = FHIRResourceType.builder().value(Value.PROCEDURE).build();
    public static final FHIRResourceType PROVENANCE = FHIRResourceType.builder().value(Value.PROVENANCE).build();
    public static final FHIRResourceType QUESTIONNAIRE = FHIRResourceType.builder().value(Value.QUESTIONNAIRE).build();
    public static final FHIRResourceType QUESTIONNAIRE_RESPONSE = FHIRResourceType.builder().value(Value.QUESTIONNAIRE_RESPONSE).build();
    public static final FHIRResourceType RELATED_PERSON = FHIRResourceType.builder().value(Value.RELATED_PERSON).build();
    public static final FHIRResourceType REQUEST_GROUP = FHIRResourceType.builder().value(Value.REQUEST_GROUP).build();
    public static final FHIRResourceType RESEARCH_DEFINITION = FHIRResourceType.builder().value(Value.RESEARCH_DEFINITION).build();
    public static final FHIRResourceType RESEARCH_ELEMENT_DEFINITION = FHIRResourceType.builder().value(Value.RESEARCH_ELEMENT_DEFINITION).build();
    public static final FHIRResourceType RESEARCH_STUDY = FHIRResourceType.builder().value(Value.RESEARCH_STUDY).build();
    public static final FHIRResourceType RESEARCH_SUBJECT = FHIRResourceType.builder().value(Value.RESEARCH_SUBJECT).build();
    public static final FHIRResourceType RESOURCE = FHIRResourceType.builder().value(Value.RESOURCE).build();
    public static final FHIRResourceType RISK_ASSESSMENT = FHIRResourceType.builder().value(Value.RISK_ASSESSMENT).build();
    public static final FHIRResourceType RISK_EVIDENCE_SYNTHESIS = FHIRResourceType.builder().value(Value.RISK_EVIDENCE_SYNTHESIS).build();
    public static final FHIRResourceType SCHEDULE = FHIRResourceType.builder().value(Value.SCHEDULE).build();
    public static final FHIRResourceType SEARCH_PARAMETER = FHIRResourceType.builder().value(Value.SEARCH_PARAMETER).build();
    public static final FHIRResourceType SERVICE_REQUEST = FHIRResourceType.builder().value(Value.SERVICE_REQUEST).build();
    public static final FHIRResourceType SLOT = FHIRResourceType.builder().value(Value.SLOT).build();
    public static final FHIRResourceType SPECIMEN = FHIRResourceType.builder().value(Value.SPECIMEN).build();
    public static final FHIRResourceType SPECIMEN_DEFINITION = FHIRResourceType.builder().value(Value.SPECIMEN_DEFINITION).build();
    public static final FHIRResourceType STRUCTURE_DEFINITION = FHIRResourceType.builder().value(Value.STRUCTURE_DEFINITION).build();
    public static final FHIRResourceType STRUCTURE_MAP = FHIRResourceType.builder().value(Value.STRUCTURE_MAP).build();
    public static final FHIRResourceType SUBSCRIPTION = FHIRResourceType.builder().value(Value.SUBSCRIPTION).build();
    public static final FHIRResourceType SUBSTANCE = FHIRResourceType.builder().value(Value.SUBSTANCE).build();
    public static final FHIRResourceType SUBSTANCE_NUCLEIC_ACID = FHIRResourceType.builder().value(Value.SUBSTANCE_NUCLEIC_ACID).build();
    public static final FHIRResourceType SUBSTANCE_POLYMER = FHIRResourceType.builder().value(Value.SUBSTANCE_POLYMER).build();
    public static final FHIRResourceType SUBSTANCE_PROTEIN = FHIRResourceType.builder().value(Value.SUBSTANCE_PROTEIN).build();
    public static final FHIRResourceType SUBSTANCE_REFERENCE_INFORMATION = FHIRResourceType.builder().value(Value.SUBSTANCE_REFERENCE_INFORMATION).build();
    public static final FHIRResourceType SUBSTANCE_SOURCE_MATERIAL = FHIRResourceType.builder().value(Value.SUBSTANCE_SOURCE_MATERIAL).build();
    public static final FHIRResourceType SUBSTANCE_SPECIFICATION = FHIRResourceType.builder().value(Value.SUBSTANCE_SPECIFICATION).build();
    public static final FHIRResourceType SUPPLY_DELIVERY = FHIRResourceType.builder().value(Value.SUPPLY_DELIVERY).build();
    public static final FHIRResourceType SUPPLY_REQUEST = FHIRResourceType.builder().value(Value.SUPPLY_REQUEST).build();
    public static final FHIRResourceType TASK = FHIRResourceType.builder().value(Value.TASK).build();
    public static final FHIRResourceType TERMINOLOGY_CAPABILITIES = FHIRResourceType.builder().value(Value.TERMINOLOGY_CAPABILITIES).build();
    public static final FHIRResourceType TEST_REPORT = FHIRResourceType.builder().value(Value.TEST_REPORT).build();
    public static final FHIRResourceType TEST_SCRIPT = FHIRResourceType.builder().value(Value.TEST_SCRIPT).build();
    public static final FHIRResourceType VALUE_SET = FHIRResourceType.builder().value(Value.VALUE_SET).build();
    public static final FHIRResourceType VERIFICATION_RESULT = FHIRResourceType.builder().value(Value.VERIFICATION_RESULT).build();
    public static final FHIRResourceType VISION_PRESCRIPTION = FHIRResourceType.builder().value(Value.VISION_PRESCRIPTION).build();
    private volatile int hashCode;

    private FHIRResourceType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static FHIRResourceType of(ValueSet value) {
        switch (value) {
            case ACCOUNT: {
                return ACCOUNT;
            }
            case ACTIVITY_DEFINITION: {
                return ACTIVITY_DEFINITION;
            }
            case ADVERSE_EVENT: {
                return ADVERSE_EVENT;
            }
            case ALLERGY_INTOLERANCE: {
                return ALLERGY_INTOLERANCE;
            }
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case AUDIT_EVENT: {
                return AUDIT_EVENT;
            }
            case BASIC: {
                return BASIC;
            }
            case BINARY: {
                return BINARY;
            }
            case BIOLOGICALLY_DERIVED_PRODUCT: {
                return BIOLOGICALLY_DERIVED_PRODUCT;
            }
            case BODY_STRUCTURE: {
                return BODY_STRUCTURE;
            }
            case BUNDLE: {
                return BUNDLE;
            }
            case CAPABILITY_STATEMENT: {
                return CAPABILITY_STATEMENT;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CARE_TEAM: {
                return CARE_TEAM;
            }
            case CATALOG_ENTRY: {
                return CATALOG_ENTRY;
            }
            case CHARGE_ITEM: {
                return CHARGE_ITEM;
            }
            case CHARGE_ITEM_DEFINITION: {
                return CHARGE_ITEM_DEFINITION;
            }
            case CLAIM: {
                return CLAIM;
            }
            case CLAIM_RESPONSE: {
                return CLAIM_RESPONSE;
            }
            case CLINICAL_IMPRESSION: {
                return CLINICAL_IMPRESSION;
            }
            case CODE_SYSTEM: {
                return CODE_SYSTEM;
            }
            case COMMUNICATION: {
                return COMMUNICATION;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case COMPARTMENT_DEFINITION: {
                return COMPARTMENT_DEFINITION;
            }
            case COMPOSITION: {
                return COMPOSITION;
            }
            case CONCEPT_MAP: {
                return CONCEPT_MAP;
            }
            case CONDITION: {
                return CONDITION;
            }
            case CONSENT: {
                return CONSENT;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case COVERAGE: {
                return COVERAGE;
            }
            case COVERAGE_ELIGIBILITY_REQUEST: {
                return COVERAGE_ELIGIBILITY_REQUEST;
            }
            case COVERAGE_ELIGIBILITY_RESPONSE: {
                return COVERAGE_ELIGIBILITY_RESPONSE;
            }
            case DETECTED_ISSUE: {
                return DETECTED_ISSUE;
            }
            case DEVICE: {
                return DEVICE;
            }
            case DEVICE_DEFINITION: {
                return DEVICE_DEFINITION;
            }
            case DEVICE_METRIC: {
                return DEVICE_METRIC;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case DEVICE_USE_STATEMENT: {
                return DEVICE_USE_STATEMENT;
            }
            case DIAGNOSTIC_REPORT: {
                return DIAGNOSTIC_REPORT;
            }
            case DOCUMENT_MANIFEST: {
                return DOCUMENT_MANIFEST;
            }
            case DOCUMENT_REFERENCE: {
                return DOCUMENT_REFERENCE;
            }
            case DOMAIN_RESOURCE: {
                return DOMAIN_RESOURCE;
            }
            case EFFECT_EVIDENCE_SYNTHESIS: {
                return EFFECT_EVIDENCE_SYNTHESIS;
            }
            case ENCOUNTER: {
                return ENCOUNTER;
            }
            case ENDPOINT: {
                return ENDPOINT;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case ENROLLMENT_RESPONSE: {
                return ENROLLMENT_RESPONSE;
            }
            case EPISODE_OF_CARE: {
                return EPISODE_OF_CARE;
            }
            case EVENT_DEFINITION: {
                return EVENT_DEFINITION;
            }
            case EVIDENCE: {
                return EVIDENCE;
            }
            case EVIDENCE_VARIABLE: {
                return EVIDENCE_VARIABLE;
            }
            case EXAMPLE_SCENARIO: {
                return EXAMPLE_SCENARIO;
            }
            case EXPLANATION_OF_BENEFIT: {
                return EXPLANATION_OF_BENEFIT;
            }
            case FAMILY_MEMBER_HISTORY: {
                return FAMILY_MEMBER_HISTORY;
            }
            case FLAG: {
                return FLAG;
            }
            case GOAL: {
                return GOAL;
            }
            case GRAPH_DEFINITION: {
                return GRAPH_DEFINITION;
            }
            case GROUP: {
                return GROUP;
            }
            case GUIDANCE_RESPONSE: {
                return GUIDANCE_RESPONSE;
            }
            case HEALTHCARE_SERVICE: {
                return HEALTHCARE_SERVICE;
            }
            case IMAGING_STUDY: {
                return IMAGING_STUDY;
            }
            case IMMUNIZATION: {
                return IMMUNIZATION;
            }
            case IMMUNIZATION_EVALUATION: {
                return IMMUNIZATION_EVALUATION;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case IMPLEMENTATION_GUIDE: {
                return IMPLEMENTATION_GUIDE;
            }
            case INSURANCE_PLAN: {
                return INSURANCE_PLAN;
            }
            case INVOICE: {
                return INVOICE;
            }
            case LIBRARY: {
                return LIBRARY;
            }
            case LINKAGE: {
                return LINKAGE;
            }
            case LIST: {
                return LIST;
            }
            case LOCATION: {
                return LOCATION;
            }
            case MEASURE: {
                return MEASURE;
            }
            case MEASURE_REPORT: {
                return MEASURE_REPORT;
            }
            case MEDIA: {
                return MEDIA;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case MEDICATION_ADMINISTRATION: {
                return MEDICATION_ADMINISTRATION;
            }
            case MEDICATION_DISPENSE: {
                return MEDICATION_DISPENSE;
            }
            case MEDICATION_KNOWLEDGE: {
                return MEDICATION_KNOWLEDGE;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case MEDICATION_STATEMENT: {
                return MEDICATION_STATEMENT;
            }
            case MEDICINAL_PRODUCT: {
                return MEDICINAL_PRODUCT;
            }
            case MEDICINAL_PRODUCT_AUTHORIZATION: {
                return MEDICINAL_PRODUCT_AUTHORIZATION;
            }
            case MEDICINAL_PRODUCT_CONTRAINDICATION: {
                return MEDICINAL_PRODUCT_CONTRAINDICATION;
            }
            case MEDICINAL_PRODUCT_INDICATION: {
                return MEDICINAL_PRODUCT_INDICATION;
            }
            case MEDICINAL_PRODUCT_INGREDIENT: {
                return MEDICINAL_PRODUCT_INGREDIENT;
            }
            case MEDICINAL_PRODUCT_INTERACTION: {
                return MEDICINAL_PRODUCT_INTERACTION;
            }
            case MEDICINAL_PRODUCT_MANUFACTURED: {
                return MEDICINAL_PRODUCT_MANUFACTURED;
            }
            case MEDICINAL_PRODUCT_PACKAGED: {
                return MEDICINAL_PRODUCT_PACKAGED;
            }
            case MEDICINAL_PRODUCT_PHARMACEUTICAL: {
                return MEDICINAL_PRODUCT_PHARMACEUTICAL;
            }
            case MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT: {
                return MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT;
            }
            case MESSAGE_DEFINITION: {
                return MESSAGE_DEFINITION;
            }
            case MESSAGE_HEADER: {
                return MESSAGE_HEADER;
            }
            case MOLECULAR_SEQUENCE: {
                return MOLECULAR_SEQUENCE;
            }
            case NAMING_SYSTEM: {
                return NAMING_SYSTEM;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case OBSERVATION: {
                return OBSERVATION;
            }
            case OBSERVATION_DEFINITION: {
                return OBSERVATION_DEFINITION;
            }
            case OPERATION_DEFINITION: {
                return OPERATION_DEFINITION;
            }
            case OPERATION_OUTCOME: {
                return OPERATION_OUTCOME;
            }
            case ORGANIZATION: {
                return ORGANIZATION;
            }
            case ORGANIZATION_AFFILIATION: {
                return ORGANIZATION_AFFILIATION;
            }
            case PARAMETERS: {
                return PARAMETERS;
            }
            case PATIENT: {
                return PATIENT;
            }
            case PAYMENT_NOTICE: {
                return PAYMENT_NOTICE;
            }
            case PAYMENT_RECONCILIATION: {
                return PAYMENT_RECONCILIATION;
            }
            case PERSON: {
                return PERSON;
            }
            case PLAN_DEFINITION: {
                return PLAN_DEFINITION;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case PRACTITIONER_ROLE: {
                return PRACTITIONER_ROLE;
            }
            case PROCEDURE: {
                return PROCEDURE;
            }
            case PROVENANCE: {
                return PROVENANCE;
            }
            case QUESTIONNAIRE: {
                return QUESTIONNAIRE;
            }
            case QUESTIONNAIRE_RESPONSE: {
                return QUESTIONNAIRE_RESPONSE;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case REQUEST_GROUP: {
                return REQUEST_GROUP;
            }
            case RESEARCH_DEFINITION: {
                return RESEARCH_DEFINITION;
            }
            case RESEARCH_ELEMENT_DEFINITION: {
                return RESEARCH_ELEMENT_DEFINITION;
            }
            case RESEARCH_STUDY: {
                return RESEARCH_STUDY;
            }
            case RESEARCH_SUBJECT: {
                return RESEARCH_SUBJECT;
            }
            case RESOURCE: {
                return RESOURCE;
            }
            case RISK_ASSESSMENT: {
                return RISK_ASSESSMENT;
            }
            case RISK_EVIDENCE_SYNTHESIS: {
                return RISK_EVIDENCE_SYNTHESIS;
            }
            case SCHEDULE: {
                return SCHEDULE;
            }
            case SEARCH_PARAMETER: {
                return SEARCH_PARAMETER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SLOT: {
                return SLOT;
            }
            case SPECIMEN: {
                return SPECIMEN;
            }
            case SPECIMEN_DEFINITION: {
                return SPECIMEN_DEFINITION;
            }
            case STRUCTURE_DEFINITION: {
                return STRUCTURE_DEFINITION;
            }
            case STRUCTURE_MAP: {
                return STRUCTURE_MAP;
            }
            case SUBSCRIPTION: {
                return SUBSCRIPTION;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
            case SUBSTANCE_NUCLEIC_ACID: {
                return SUBSTANCE_NUCLEIC_ACID;
            }
            case SUBSTANCE_POLYMER: {
                return SUBSTANCE_POLYMER;
            }
            case SUBSTANCE_PROTEIN: {
                return SUBSTANCE_PROTEIN;
            }
            case SUBSTANCE_REFERENCE_INFORMATION: {
                return SUBSTANCE_REFERENCE_INFORMATION;
            }
            case SUBSTANCE_SOURCE_MATERIAL: {
                return SUBSTANCE_SOURCE_MATERIAL;
            }
            case SUBSTANCE_SPECIFICATION: {
                return SUBSTANCE_SPECIFICATION;
            }
            case SUPPLY_DELIVERY: {
                return SUPPLY_DELIVERY;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case TERMINOLOGY_CAPABILITIES: {
                return TERMINOLOGY_CAPABILITIES;
            }
            case TEST_REPORT: {
                return TEST_REPORT;
            }
            case TEST_SCRIPT: {
                return TEST_SCRIPT;
            }
            case VALUE_SET: {
                return VALUE_SET;
            }
            case VERIFICATION_RESULT: {
                return VERIFICATION_RESULT;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRResourceType of(Value value) {
        switch (value) {
            case ACCOUNT: {
                return ACCOUNT;
            }
            case ACTIVITY_DEFINITION: {
                return ACTIVITY_DEFINITION;
            }
            case ADVERSE_EVENT: {
                return ADVERSE_EVENT;
            }
            case ALLERGY_INTOLERANCE: {
                return ALLERGY_INTOLERANCE;
            }
            case APPOINTMENT: {
                return APPOINTMENT;
            }
            case APPOINTMENT_RESPONSE: {
                return APPOINTMENT_RESPONSE;
            }
            case AUDIT_EVENT: {
                return AUDIT_EVENT;
            }
            case BASIC: {
                return BASIC;
            }
            case BINARY: {
                return BINARY;
            }
            case BIOLOGICALLY_DERIVED_PRODUCT: {
                return BIOLOGICALLY_DERIVED_PRODUCT;
            }
            case BODY_STRUCTURE: {
                return BODY_STRUCTURE;
            }
            case BUNDLE: {
                return BUNDLE;
            }
            case CAPABILITY_STATEMENT: {
                return CAPABILITY_STATEMENT;
            }
            case CARE_PLAN: {
                return CARE_PLAN;
            }
            case CARE_TEAM: {
                return CARE_TEAM;
            }
            case CATALOG_ENTRY: {
                return CATALOG_ENTRY;
            }
            case CHARGE_ITEM: {
                return CHARGE_ITEM;
            }
            case CHARGE_ITEM_DEFINITION: {
                return CHARGE_ITEM_DEFINITION;
            }
            case CLAIM: {
                return CLAIM;
            }
            case CLAIM_RESPONSE: {
                return CLAIM_RESPONSE;
            }
            case CLINICAL_IMPRESSION: {
                return CLINICAL_IMPRESSION;
            }
            case CODE_SYSTEM: {
                return CODE_SYSTEM;
            }
            case COMMUNICATION: {
                return COMMUNICATION;
            }
            case COMMUNICATION_REQUEST: {
                return COMMUNICATION_REQUEST;
            }
            case COMPARTMENT_DEFINITION: {
                return COMPARTMENT_DEFINITION;
            }
            case COMPOSITION: {
                return COMPOSITION;
            }
            case CONCEPT_MAP: {
                return CONCEPT_MAP;
            }
            case CONDITION: {
                return CONDITION;
            }
            case CONSENT: {
                return CONSENT;
            }
            case CONTRACT: {
                return CONTRACT;
            }
            case COVERAGE: {
                return COVERAGE;
            }
            case COVERAGE_ELIGIBILITY_REQUEST: {
                return COVERAGE_ELIGIBILITY_REQUEST;
            }
            case COVERAGE_ELIGIBILITY_RESPONSE: {
                return COVERAGE_ELIGIBILITY_RESPONSE;
            }
            case DETECTED_ISSUE: {
                return DETECTED_ISSUE;
            }
            case DEVICE: {
                return DEVICE;
            }
            case DEVICE_DEFINITION: {
                return DEVICE_DEFINITION;
            }
            case DEVICE_METRIC: {
                return DEVICE_METRIC;
            }
            case DEVICE_REQUEST: {
                return DEVICE_REQUEST;
            }
            case DEVICE_USE_STATEMENT: {
                return DEVICE_USE_STATEMENT;
            }
            case DIAGNOSTIC_REPORT: {
                return DIAGNOSTIC_REPORT;
            }
            case DOCUMENT_MANIFEST: {
                return DOCUMENT_MANIFEST;
            }
            case DOCUMENT_REFERENCE: {
                return DOCUMENT_REFERENCE;
            }
            case DOMAIN_RESOURCE: {
                return DOMAIN_RESOURCE;
            }
            case EFFECT_EVIDENCE_SYNTHESIS: {
                return EFFECT_EVIDENCE_SYNTHESIS;
            }
            case ENCOUNTER: {
                return ENCOUNTER;
            }
            case ENDPOINT: {
                return ENDPOINT;
            }
            case ENROLLMENT_REQUEST: {
                return ENROLLMENT_REQUEST;
            }
            case ENROLLMENT_RESPONSE: {
                return ENROLLMENT_RESPONSE;
            }
            case EPISODE_OF_CARE: {
                return EPISODE_OF_CARE;
            }
            case EVENT_DEFINITION: {
                return EVENT_DEFINITION;
            }
            case EVIDENCE: {
                return EVIDENCE;
            }
            case EVIDENCE_VARIABLE: {
                return EVIDENCE_VARIABLE;
            }
            case EXAMPLE_SCENARIO: {
                return EXAMPLE_SCENARIO;
            }
            case EXPLANATION_OF_BENEFIT: {
                return EXPLANATION_OF_BENEFIT;
            }
            case FAMILY_MEMBER_HISTORY: {
                return FAMILY_MEMBER_HISTORY;
            }
            case FLAG: {
                return FLAG;
            }
            case GOAL: {
                return GOAL;
            }
            case GRAPH_DEFINITION: {
                return GRAPH_DEFINITION;
            }
            case GROUP: {
                return GROUP;
            }
            case GUIDANCE_RESPONSE: {
                return GUIDANCE_RESPONSE;
            }
            case HEALTHCARE_SERVICE: {
                return HEALTHCARE_SERVICE;
            }
            case IMAGING_STUDY: {
                return IMAGING_STUDY;
            }
            case IMMUNIZATION: {
                return IMMUNIZATION;
            }
            case IMMUNIZATION_EVALUATION: {
                return IMMUNIZATION_EVALUATION;
            }
            case IMMUNIZATION_RECOMMENDATION: {
                return IMMUNIZATION_RECOMMENDATION;
            }
            case IMPLEMENTATION_GUIDE: {
                return IMPLEMENTATION_GUIDE;
            }
            case INSURANCE_PLAN: {
                return INSURANCE_PLAN;
            }
            case INVOICE: {
                return INVOICE;
            }
            case LIBRARY: {
                return LIBRARY;
            }
            case LINKAGE: {
                return LINKAGE;
            }
            case LIST: {
                return LIST;
            }
            case LOCATION: {
                return LOCATION;
            }
            case MEASURE: {
                return MEASURE;
            }
            case MEASURE_REPORT: {
                return MEASURE_REPORT;
            }
            case MEDIA: {
                return MEDIA;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case MEDICATION_ADMINISTRATION: {
                return MEDICATION_ADMINISTRATION;
            }
            case MEDICATION_DISPENSE: {
                return MEDICATION_DISPENSE;
            }
            case MEDICATION_KNOWLEDGE: {
                return MEDICATION_KNOWLEDGE;
            }
            case MEDICATION_REQUEST: {
                return MEDICATION_REQUEST;
            }
            case MEDICATION_STATEMENT: {
                return MEDICATION_STATEMENT;
            }
            case MEDICINAL_PRODUCT: {
                return MEDICINAL_PRODUCT;
            }
            case MEDICINAL_PRODUCT_AUTHORIZATION: {
                return MEDICINAL_PRODUCT_AUTHORIZATION;
            }
            case MEDICINAL_PRODUCT_CONTRAINDICATION: {
                return MEDICINAL_PRODUCT_CONTRAINDICATION;
            }
            case MEDICINAL_PRODUCT_INDICATION: {
                return MEDICINAL_PRODUCT_INDICATION;
            }
            case MEDICINAL_PRODUCT_INGREDIENT: {
                return MEDICINAL_PRODUCT_INGREDIENT;
            }
            case MEDICINAL_PRODUCT_INTERACTION: {
                return MEDICINAL_PRODUCT_INTERACTION;
            }
            case MEDICINAL_PRODUCT_MANUFACTURED: {
                return MEDICINAL_PRODUCT_MANUFACTURED;
            }
            case MEDICINAL_PRODUCT_PACKAGED: {
                return MEDICINAL_PRODUCT_PACKAGED;
            }
            case MEDICINAL_PRODUCT_PHARMACEUTICAL: {
                return MEDICINAL_PRODUCT_PHARMACEUTICAL;
            }
            case MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT: {
                return MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT;
            }
            case MESSAGE_DEFINITION: {
                return MESSAGE_DEFINITION;
            }
            case MESSAGE_HEADER: {
                return MESSAGE_HEADER;
            }
            case MOLECULAR_SEQUENCE: {
                return MOLECULAR_SEQUENCE;
            }
            case NAMING_SYSTEM: {
                return NAMING_SYSTEM;
            }
            case NUTRITION_ORDER: {
                return NUTRITION_ORDER;
            }
            case OBSERVATION: {
                return OBSERVATION;
            }
            case OBSERVATION_DEFINITION: {
                return OBSERVATION_DEFINITION;
            }
            case OPERATION_DEFINITION: {
                return OPERATION_DEFINITION;
            }
            case OPERATION_OUTCOME: {
                return OPERATION_OUTCOME;
            }
            case ORGANIZATION: {
                return ORGANIZATION;
            }
            case ORGANIZATION_AFFILIATION: {
                return ORGANIZATION_AFFILIATION;
            }
            case PARAMETERS: {
                return PARAMETERS;
            }
            case PATIENT: {
                return PATIENT;
            }
            case PAYMENT_NOTICE: {
                return PAYMENT_NOTICE;
            }
            case PAYMENT_RECONCILIATION: {
                return PAYMENT_RECONCILIATION;
            }
            case PERSON: {
                return PERSON;
            }
            case PLAN_DEFINITION: {
                return PLAN_DEFINITION;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case PRACTITIONER_ROLE: {
                return PRACTITIONER_ROLE;
            }
            case PROCEDURE: {
                return PROCEDURE;
            }
            case PROVENANCE: {
                return PROVENANCE;
            }
            case QUESTIONNAIRE: {
                return QUESTIONNAIRE;
            }
            case QUESTIONNAIRE_RESPONSE: {
                return QUESTIONNAIRE_RESPONSE;
            }
            case RELATED_PERSON: {
                return RELATED_PERSON;
            }
            case REQUEST_GROUP: {
                return REQUEST_GROUP;
            }
            case RESEARCH_DEFINITION: {
                return RESEARCH_DEFINITION;
            }
            case RESEARCH_ELEMENT_DEFINITION: {
                return RESEARCH_ELEMENT_DEFINITION;
            }
            case RESEARCH_STUDY: {
                return RESEARCH_STUDY;
            }
            case RESEARCH_SUBJECT: {
                return RESEARCH_SUBJECT;
            }
            case RESOURCE: {
                return RESOURCE;
            }
            case RISK_ASSESSMENT: {
                return RISK_ASSESSMENT;
            }
            case RISK_EVIDENCE_SYNTHESIS: {
                return RISK_EVIDENCE_SYNTHESIS;
            }
            case SCHEDULE: {
                return SCHEDULE;
            }
            case SEARCH_PARAMETER: {
                return SEARCH_PARAMETER;
            }
            case SERVICE_REQUEST: {
                return SERVICE_REQUEST;
            }
            case SLOT: {
                return SLOT;
            }
            case SPECIMEN: {
                return SPECIMEN;
            }
            case SPECIMEN_DEFINITION: {
                return SPECIMEN_DEFINITION;
            }
            case STRUCTURE_DEFINITION: {
                return STRUCTURE_DEFINITION;
            }
            case STRUCTURE_MAP: {
                return STRUCTURE_MAP;
            }
            case SUBSCRIPTION: {
                return SUBSCRIPTION;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
            case SUBSTANCE_NUCLEIC_ACID: {
                return SUBSTANCE_NUCLEIC_ACID;
            }
            case SUBSTANCE_POLYMER: {
                return SUBSTANCE_POLYMER;
            }
            case SUBSTANCE_PROTEIN: {
                return SUBSTANCE_PROTEIN;
            }
            case SUBSTANCE_REFERENCE_INFORMATION: {
                return SUBSTANCE_REFERENCE_INFORMATION;
            }
            case SUBSTANCE_SOURCE_MATERIAL: {
                return SUBSTANCE_SOURCE_MATERIAL;
            }
            case SUBSTANCE_SPECIFICATION: {
                return SUBSTANCE_SPECIFICATION;
            }
            case SUPPLY_DELIVERY: {
                return SUPPLY_DELIVERY;
            }
            case SUPPLY_REQUEST: {
                return SUPPLY_REQUEST;
            }
            case TASK: {
                return TASK;
            }
            case TERMINOLOGY_CAPABILITIES: {
                return TERMINOLOGY_CAPABILITIES;
            }
            case TEST_REPORT: {
                return TEST_REPORT;
            }
            case TEST_SCRIPT: {
                return TEST_SCRIPT;
            }
            case VALUE_SET: {
                return VALUE_SET;
            }
            case VERIFICATION_RESULT: {
                return VERIFICATION_RESULT;
            }
            case VISION_PRESCRIPTION: {
                return VISION_PRESCRIPTION;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRResourceType of(java.lang.String value) {
        return FHIRResourceType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return FHIRResourceType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return FHIRResourceType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FHIRResourceType other = (FHIRResourceType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        ACCOUNT("Account"),
        ACTIVITY_DEFINITION("ActivityDefinition"),
        ADVERSE_EVENT("AdverseEvent"),
        ALLERGY_INTOLERANCE("AllergyIntolerance"),
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        AUDIT_EVENT("AuditEvent"),
        BASIC("Basic"),
        BINARY("Binary"),
        BIOLOGICALLY_DERIVED_PRODUCT("BiologicallyDerivedProduct"),
        BODY_STRUCTURE("BodyStructure"),
        BUNDLE("Bundle"),
        CAPABILITY_STATEMENT("CapabilityStatement"),
        CARE_PLAN("CarePlan"),
        CARE_TEAM("CareTeam"),
        CATALOG_ENTRY("CatalogEntry"),
        CHARGE_ITEM("ChargeItem"),
        CHARGE_ITEM_DEFINITION("ChargeItemDefinition"),
        CLAIM("Claim"),
        CLAIM_RESPONSE("ClaimResponse"),
        CLINICAL_IMPRESSION("ClinicalImpression"),
        CODE_SYSTEM("CodeSystem"),
        COMMUNICATION("Communication"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        COMPARTMENT_DEFINITION("CompartmentDefinition"),
        COMPOSITION("Composition"),
        CONCEPT_MAP("ConceptMap"),
        CONDITION("Condition"),
        CONSENT("Consent"),
        CONTRACT("Contract"),
        COVERAGE("Coverage"),
        COVERAGE_ELIGIBILITY_REQUEST("CoverageEligibilityRequest"),
        COVERAGE_ELIGIBILITY_RESPONSE("CoverageEligibilityResponse"),
        DETECTED_ISSUE("DetectedIssue"),
        DEVICE("Device"),
        DEVICE_DEFINITION("DeviceDefinition"),
        DEVICE_METRIC("DeviceMetric"),
        DEVICE_REQUEST("DeviceRequest"),
        DEVICE_USE_STATEMENT("DeviceUseStatement"),
        DIAGNOSTIC_REPORT("DiagnosticReport"),
        DOCUMENT_MANIFEST("DocumentManifest"),
        DOCUMENT_REFERENCE("DocumentReference"),
        DOMAIN_RESOURCE("DomainResource"),
        EFFECT_EVIDENCE_SYNTHESIS("EffectEvidenceSynthesis"),
        ENCOUNTER("Encounter"),
        ENDPOINT("Endpoint"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        ENROLLMENT_RESPONSE("EnrollmentResponse"),
        EPISODE_OF_CARE("EpisodeOfCare"),
        EVENT_DEFINITION("EventDefinition"),
        EVIDENCE("Evidence"),
        EVIDENCE_VARIABLE("EvidenceVariable"),
        EXAMPLE_SCENARIO("ExampleScenario"),
        EXPLANATION_OF_BENEFIT("ExplanationOfBenefit"),
        FAMILY_MEMBER_HISTORY("FamilyMemberHistory"),
        FLAG("Flag"),
        GOAL("Goal"),
        GRAPH_DEFINITION("GraphDefinition"),
        GROUP("Group"),
        GUIDANCE_RESPONSE("GuidanceResponse"),
        HEALTHCARE_SERVICE("HealthcareService"),
        IMAGING_STUDY("ImagingStudy"),
        IMMUNIZATION("Immunization"),
        IMMUNIZATION_EVALUATION("ImmunizationEvaluation"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        IMPLEMENTATION_GUIDE("ImplementationGuide"),
        INSURANCE_PLAN("InsurancePlan"),
        INVOICE("Invoice"),
        LIBRARY("Library"),
        LINKAGE("Linkage"),
        LIST("List"),
        LOCATION("Location"),
        MEASURE("Measure"),
        MEASURE_REPORT("MeasureReport"),
        MEDIA("Media"),
        MEDICATION("Medication"),
        MEDICATION_ADMINISTRATION("MedicationAdministration"),
        MEDICATION_DISPENSE("MedicationDispense"),
        MEDICATION_KNOWLEDGE("MedicationKnowledge"),
        MEDICATION_REQUEST("MedicationRequest"),
        MEDICATION_STATEMENT("MedicationStatement"),
        MEDICINAL_PRODUCT("MedicinalProduct"),
        MEDICINAL_PRODUCT_AUTHORIZATION("MedicinalProductAuthorization"),
        MEDICINAL_PRODUCT_CONTRAINDICATION("MedicinalProductContraindication"),
        MEDICINAL_PRODUCT_INDICATION("MedicinalProductIndication"),
        MEDICINAL_PRODUCT_INGREDIENT("MedicinalProductIngredient"),
        MEDICINAL_PRODUCT_INTERACTION("MedicinalProductInteraction"),
        MEDICINAL_PRODUCT_MANUFACTURED("MedicinalProductManufactured"),
        MEDICINAL_PRODUCT_PACKAGED("MedicinalProductPackaged"),
        MEDICINAL_PRODUCT_PHARMACEUTICAL("MedicinalProductPharmaceutical"),
        MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT("MedicinalProductUndesirableEffect"),
        MESSAGE_DEFINITION("MessageDefinition"),
        MESSAGE_HEADER("MessageHeader"),
        MOLECULAR_SEQUENCE("MolecularSequence"),
        NAMING_SYSTEM("NamingSystem"),
        NUTRITION_ORDER("NutritionOrder"),
        OBSERVATION("Observation"),
        OBSERVATION_DEFINITION("ObservationDefinition"),
        OPERATION_DEFINITION("OperationDefinition"),
        OPERATION_OUTCOME("OperationOutcome"),
        ORGANIZATION("Organization"),
        ORGANIZATION_AFFILIATION("OrganizationAffiliation"),
        PARAMETERS("Parameters"),
        PATIENT("Patient"),
        PAYMENT_NOTICE("PaymentNotice"),
        PAYMENT_RECONCILIATION("PaymentReconciliation"),
        PERSON("Person"),
        PLAN_DEFINITION("PlanDefinition"),
        PRACTITIONER("Practitioner"),
        PRACTITIONER_ROLE("PractitionerRole"),
        PROCEDURE("Procedure"),
        PROVENANCE("Provenance"),
        QUESTIONNAIRE("Questionnaire"),
        QUESTIONNAIRE_RESPONSE("QuestionnaireResponse"),
        RELATED_PERSON("RelatedPerson"),
        REQUEST_GROUP("RequestGroup"),
        RESEARCH_DEFINITION("ResearchDefinition"),
        RESEARCH_ELEMENT_DEFINITION("ResearchElementDefinition"),
        RESEARCH_STUDY("ResearchStudy"),
        RESEARCH_SUBJECT("ResearchSubject"),
        RESOURCE("Resource"),
        RISK_ASSESSMENT("RiskAssessment"),
        RISK_EVIDENCE_SYNTHESIS("RiskEvidenceSynthesis"),
        SCHEDULE("Schedule"),
        SEARCH_PARAMETER("SearchParameter"),
        SERVICE_REQUEST("ServiceRequest"),
        SLOT("Slot"),
        SPECIMEN("Specimen"),
        SPECIMEN_DEFINITION("SpecimenDefinition"),
        STRUCTURE_DEFINITION("StructureDefinition"),
        STRUCTURE_MAP("StructureMap"),
        SUBSCRIPTION("Subscription"),
        SUBSTANCE("Substance"),
        SUBSTANCE_NUCLEIC_ACID("SubstanceNucleicAcid"),
        SUBSTANCE_POLYMER("SubstancePolymer"),
        SUBSTANCE_PROTEIN("SubstanceProtein"),
        SUBSTANCE_REFERENCE_INFORMATION("SubstanceReferenceInformation"),
        SUBSTANCE_SOURCE_MATERIAL("SubstanceSourceMaterial"),
        SUBSTANCE_SPECIFICATION("SubstanceSpecification"),
        SUPPLY_DELIVERY("SupplyDelivery"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        TERMINOLOGY_CAPABILITIES("TerminologyCapabilities"),
        TEST_REPORT("TestReport"),
        TEST_SCRIPT("TestScript"),
        VALUE_SET("ValueSet"),
        VERIFICATION_RESULT("VerificationResult"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "Account": {
                    return ACCOUNT;
                }
                case "ActivityDefinition": {
                    return ACTIVITY_DEFINITION;
                }
                case "AdverseEvent": {
                    return ADVERSE_EVENT;
                }
                case "AllergyIntolerance": {
                    return ALLERGY_INTOLERANCE;
                }
                case "Appointment": {
                    return APPOINTMENT;
                }
                case "AppointmentResponse": {
                    return APPOINTMENT_RESPONSE;
                }
                case "AuditEvent": {
                    return AUDIT_EVENT;
                }
                case "Basic": {
                    return BASIC;
                }
                case "Binary": {
                    return BINARY;
                }
                case "BiologicallyDerivedProduct": {
                    return BIOLOGICALLY_DERIVED_PRODUCT;
                }
                case "BodyStructure": {
                    return BODY_STRUCTURE;
                }
                case "Bundle": {
                    return BUNDLE;
                }
                case "CapabilityStatement": {
                    return CAPABILITY_STATEMENT;
                }
                case "CarePlan": {
                    return CARE_PLAN;
                }
                case "CareTeam": {
                    return CARE_TEAM;
                }
                case "CatalogEntry": {
                    return CATALOG_ENTRY;
                }
                case "ChargeItem": {
                    return CHARGE_ITEM;
                }
                case "ChargeItemDefinition": {
                    return CHARGE_ITEM_DEFINITION;
                }
                case "Claim": {
                    return CLAIM;
                }
                case "ClaimResponse": {
                    return CLAIM_RESPONSE;
                }
                case "ClinicalImpression": {
                    return CLINICAL_IMPRESSION;
                }
                case "CodeSystem": {
                    return CODE_SYSTEM;
                }
                case "Communication": {
                    return COMMUNICATION;
                }
                case "CommunicationRequest": {
                    return COMMUNICATION_REQUEST;
                }
                case "CompartmentDefinition": {
                    return COMPARTMENT_DEFINITION;
                }
                case "Composition": {
                    return COMPOSITION;
                }
                case "ConceptMap": {
                    return CONCEPT_MAP;
                }
                case "Condition": {
                    return CONDITION;
                }
                case "Consent": {
                    return CONSENT;
                }
                case "Contract": {
                    return CONTRACT;
                }
                case "Coverage": {
                    return COVERAGE;
                }
                case "CoverageEligibilityRequest": {
                    return COVERAGE_ELIGIBILITY_REQUEST;
                }
                case "CoverageEligibilityResponse": {
                    return COVERAGE_ELIGIBILITY_RESPONSE;
                }
                case "DetectedIssue": {
                    return DETECTED_ISSUE;
                }
                case "Device": {
                    return DEVICE;
                }
                case "DeviceDefinition": {
                    return DEVICE_DEFINITION;
                }
                case "DeviceMetric": {
                    return DEVICE_METRIC;
                }
                case "DeviceRequest": {
                    return DEVICE_REQUEST;
                }
                case "DeviceUseStatement": {
                    return DEVICE_USE_STATEMENT;
                }
                case "DiagnosticReport": {
                    return DIAGNOSTIC_REPORT;
                }
                case "DocumentManifest": {
                    return DOCUMENT_MANIFEST;
                }
                case "DocumentReference": {
                    return DOCUMENT_REFERENCE;
                }
                case "DomainResource": {
                    return DOMAIN_RESOURCE;
                }
                case "EffectEvidenceSynthesis": {
                    return EFFECT_EVIDENCE_SYNTHESIS;
                }
                case "Encounter": {
                    return ENCOUNTER;
                }
                case "Endpoint": {
                    return ENDPOINT;
                }
                case "EnrollmentRequest": {
                    return ENROLLMENT_REQUEST;
                }
                case "EnrollmentResponse": {
                    return ENROLLMENT_RESPONSE;
                }
                case "EpisodeOfCare": {
                    return EPISODE_OF_CARE;
                }
                case "EventDefinition": {
                    return EVENT_DEFINITION;
                }
                case "Evidence": {
                    return EVIDENCE;
                }
                case "EvidenceVariable": {
                    return EVIDENCE_VARIABLE;
                }
                case "ExampleScenario": {
                    return EXAMPLE_SCENARIO;
                }
                case "ExplanationOfBenefit": {
                    return EXPLANATION_OF_BENEFIT;
                }
                case "FamilyMemberHistory": {
                    return FAMILY_MEMBER_HISTORY;
                }
                case "Flag": {
                    return FLAG;
                }
                case "Goal": {
                    return GOAL;
                }
                case "GraphDefinition": {
                    return GRAPH_DEFINITION;
                }
                case "Group": {
                    return GROUP;
                }
                case "GuidanceResponse": {
                    return GUIDANCE_RESPONSE;
                }
                case "HealthcareService": {
                    return HEALTHCARE_SERVICE;
                }
                case "ImagingStudy": {
                    return IMAGING_STUDY;
                }
                case "Immunization": {
                    return IMMUNIZATION;
                }
                case "ImmunizationEvaluation": {
                    return IMMUNIZATION_EVALUATION;
                }
                case "ImmunizationRecommendation": {
                    return IMMUNIZATION_RECOMMENDATION;
                }
                case "ImplementationGuide": {
                    return IMPLEMENTATION_GUIDE;
                }
                case "InsurancePlan": {
                    return INSURANCE_PLAN;
                }
                case "Invoice": {
                    return INVOICE;
                }
                case "Library": {
                    return LIBRARY;
                }
                case "Linkage": {
                    return LINKAGE;
                }
                case "List": {
                    return LIST;
                }
                case "Location": {
                    return LOCATION;
                }
                case "Measure": {
                    return MEASURE;
                }
                case "MeasureReport": {
                    return MEASURE_REPORT;
                }
                case "Media": {
                    return MEDIA;
                }
                case "Medication": {
                    return MEDICATION;
                }
                case "MedicationAdministration": {
                    return MEDICATION_ADMINISTRATION;
                }
                case "MedicationDispense": {
                    return MEDICATION_DISPENSE;
                }
                case "MedicationKnowledge": {
                    return MEDICATION_KNOWLEDGE;
                }
                case "MedicationRequest": {
                    return MEDICATION_REQUEST;
                }
                case "MedicationStatement": {
                    return MEDICATION_STATEMENT;
                }
                case "MedicinalProduct": {
                    return MEDICINAL_PRODUCT;
                }
                case "MedicinalProductAuthorization": {
                    return MEDICINAL_PRODUCT_AUTHORIZATION;
                }
                case "MedicinalProductContraindication": {
                    return MEDICINAL_PRODUCT_CONTRAINDICATION;
                }
                case "MedicinalProductIndication": {
                    return MEDICINAL_PRODUCT_INDICATION;
                }
                case "MedicinalProductIngredient": {
                    return MEDICINAL_PRODUCT_INGREDIENT;
                }
                case "MedicinalProductInteraction": {
                    return MEDICINAL_PRODUCT_INTERACTION;
                }
                case "MedicinalProductManufactured": {
                    return MEDICINAL_PRODUCT_MANUFACTURED;
                }
                case "MedicinalProductPackaged": {
                    return MEDICINAL_PRODUCT_PACKAGED;
                }
                case "MedicinalProductPharmaceutical": {
                    return MEDICINAL_PRODUCT_PHARMACEUTICAL;
                }
                case "MedicinalProductUndesirableEffect": {
                    return MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT;
                }
                case "MessageDefinition": {
                    return MESSAGE_DEFINITION;
                }
                case "MessageHeader": {
                    return MESSAGE_HEADER;
                }
                case "MolecularSequence": {
                    return MOLECULAR_SEQUENCE;
                }
                case "NamingSystem": {
                    return NAMING_SYSTEM;
                }
                case "NutritionOrder": {
                    return NUTRITION_ORDER;
                }
                case "Observation": {
                    return OBSERVATION;
                }
                case "ObservationDefinition": {
                    return OBSERVATION_DEFINITION;
                }
                case "OperationDefinition": {
                    return OPERATION_DEFINITION;
                }
                case "OperationOutcome": {
                    return OPERATION_OUTCOME;
                }
                case "Organization": {
                    return ORGANIZATION;
                }
                case "OrganizationAffiliation": {
                    return ORGANIZATION_AFFILIATION;
                }
                case "Parameters": {
                    return PARAMETERS;
                }
                case "Patient": {
                    return PATIENT;
                }
                case "PaymentNotice": {
                    return PAYMENT_NOTICE;
                }
                case "PaymentReconciliation": {
                    return PAYMENT_RECONCILIATION;
                }
                case "Person": {
                    return PERSON;
                }
                case "PlanDefinition": {
                    return PLAN_DEFINITION;
                }
                case "Practitioner": {
                    return PRACTITIONER;
                }
                case "PractitionerRole": {
                    return PRACTITIONER_ROLE;
                }
                case "Procedure": {
                    return PROCEDURE;
                }
                case "Provenance": {
                    return PROVENANCE;
                }
                case "Questionnaire": {
                    return QUESTIONNAIRE;
                }
                case "QuestionnaireResponse": {
                    return QUESTIONNAIRE_RESPONSE;
                }
                case "RelatedPerson": {
                    return RELATED_PERSON;
                }
                case "RequestGroup": {
                    return REQUEST_GROUP;
                }
                case "ResearchDefinition": {
                    return RESEARCH_DEFINITION;
                }
                case "ResearchElementDefinition": {
                    return RESEARCH_ELEMENT_DEFINITION;
                }
                case "ResearchStudy": {
                    return RESEARCH_STUDY;
                }
                case "ResearchSubject": {
                    return RESEARCH_SUBJECT;
                }
                case "Resource": {
                    return RESOURCE;
                }
                case "RiskAssessment": {
                    return RISK_ASSESSMENT;
                }
                case "RiskEvidenceSynthesis": {
                    return RISK_EVIDENCE_SYNTHESIS;
                }
                case "Schedule": {
                    return SCHEDULE;
                }
                case "SearchParameter": {
                    return SEARCH_PARAMETER;
                }
                case "ServiceRequest": {
                    return SERVICE_REQUEST;
                }
                case "Slot": {
                    return SLOT;
                }
                case "Specimen": {
                    return SPECIMEN;
                }
                case "SpecimenDefinition": {
                    return SPECIMEN_DEFINITION;
                }
                case "StructureDefinition": {
                    return STRUCTURE_DEFINITION;
                }
                case "StructureMap": {
                    return STRUCTURE_MAP;
                }
                case "Subscription": {
                    return SUBSCRIPTION;
                }
                case "Substance": {
                    return SUBSTANCE;
                }
                case "SubstanceNucleicAcid": {
                    return SUBSTANCE_NUCLEIC_ACID;
                }
                case "SubstancePolymer": {
                    return SUBSTANCE_POLYMER;
                }
                case "SubstanceProtein": {
                    return SUBSTANCE_PROTEIN;
                }
                case "SubstanceReferenceInformation": {
                    return SUBSTANCE_REFERENCE_INFORMATION;
                }
                case "SubstanceSourceMaterial": {
                    return SUBSTANCE_SOURCE_MATERIAL;
                }
                case "SubstanceSpecification": {
                    return SUBSTANCE_SPECIFICATION;
                }
                case "SupplyDelivery": {
                    return SUPPLY_DELIVERY;
                }
                case "SupplyRequest": {
                    return SUPPLY_REQUEST;
                }
                case "Task": {
                    return TASK;
                }
                case "TerminologyCapabilities": {
                    return TERMINOLOGY_CAPABILITIES;
                }
                case "TestReport": {
                    return TEST_REPORT;
                }
                case "TestScript": {
                    return TEST_SCRIPT;
                }
                case "ValueSet": {
                    return VALUE_SET;
                }
                case "VerificationResult": {
                    return VERIFICATION_RESULT;
                }
                case "VisionPrescription": {
                    return VISION_PRESCRIPTION;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        ACCOUNT("Account"),
        ACTIVITY_DEFINITION("ActivityDefinition"),
        ADVERSE_EVENT("AdverseEvent"),
        ALLERGY_INTOLERANCE("AllergyIntolerance"),
        APPOINTMENT("Appointment"),
        APPOINTMENT_RESPONSE("AppointmentResponse"),
        AUDIT_EVENT("AuditEvent"),
        BASIC("Basic"),
        BINARY("Binary"),
        BIOLOGICALLY_DERIVED_PRODUCT("BiologicallyDerivedProduct"),
        BODY_STRUCTURE("BodyStructure"),
        BUNDLE("Bundle"),
        CAPABILITY_STATEMENT("CapabilityStatement"),
        CARE_PLAN("CarePlan"),
        CARE_TEAM("CareTeam"),
        CATALOG_ENTRY("CatalogEntry"),
        CHARGE_ITEM("ChargeItem"),
        CHARGE_ITEM_DEFINITION("ChargeItemDefinition"),
        CLAIM("Claim"),
        CLAIM_RESPONSE("ClaimResponse"),
        CLINICAL_IMPRESSION("ClinicalImpression"),
        CODE_SYSTEM("CodeSystem"),
        COMMUNICATION("Communication"),
        COMMUNICATION_REQUEST("CommunicationRequest"),
        COMPARTMENT_DEFINITION("CompartmentDefinition"),
        COMPOSITION("Composition"),
        CONCEPT_MAP("ConceptMap"),
        CONDITION("Condition"),
        CONSENT("Consent"),
        CONTRACT("Contract"),
        COVERAGE("Coverage"),
        COVERAGE_ELIGIBILITY_REQUEST("CoverageEligibilityRequest"),
        COVERAGE_ELIGIBILITY_RESPONSE("CoverageEligibilityResponse"),
        DETECTED_ISSUE("DetectedIssue"),
        DEVICE("Device"),
        DEVICE_DEFINITION("DeviceDefinition"),
        DEVICE_METRIC("DeviceMetric"),
        DEVICE_REQUEST("DeviceRequest"),
        DEVICE_USE_STATEMENT("DeviceUseStatement"),
        DIAGNOSTIC_REPORT("DiagnosticReport"),
        DOCUMENT_MANIFEST("DocumentManifest"),
        DOCUMENT_REFERENCE("DocumentReference"),
        DOMAIN_RESOURCE("DomainResource"),
        EFFECT_EVIDENCE_SYNTHESIS("EffectEvidenceSynthesis"),
        ENCOUNTER("Encounter"),
        ENDPOINT("Endpoint"),
        ENROLLMENT_REQUEST("EnrollmentRequest"),
        ENROLLMENT_RESPONSE("EnrollmentResponse"),
        EPISODE_OF_CARE("EpisodeOfCare"),
        EVENT_DEFINITION("EventDefinition"),
        EVIDENCE("Evidence"),
        EVIDENCE_VARIABLE("EvidenceVariable"),
        EXAMPLE_SCENARIO("ExampleScenario"),
        EXPLANATION_OF_BENEFIT("ExplanationOfBenefit"),
        FAMILY_MEMBER_HISTORY("FamilyMemberHistory"),
        FLAG("Flag"),
        GOAL("Goal"),
        GRAPH_DEFINITION("GraphDefinition"),
        GROUP("Group"),
        GUIDANCE_RESPONSE("GuidanceResponse"),
        HEALTHCARE_SERVICE("HealthcareService"),
        IMAGING_STUDY("ImagingStudy"),
        IMMUNIZATION("Immunization"),
        IMMUNIZATION_EVALUATION("ImmunizationEvaluation"),
        IMMUNIZATION_RECOMMENDATION("ImmunizationRecommendation"),
        IMPLEMENTATION_GUIDE("ImplementationGuide"),
        INSURANCE_PLAN("InsurancePlan"),
        INVOICE("Invoice"),
        LIBRARY("Library"),
        LINKAGE("Linkage"),
        LIST("List"),
        LOCATION("Location"),
        MEASURE("Measure"),
        MEASURE_REPORT("MeasureReport"),
        MEDIA("Media"),
        MEDICATION("Medication"),
        MEDICATION_ADMINISTRATION("MedicationAdministration"),
        MEDICATION_DISPENSE("MedicationDispense"),
        MEDICATION_KNOWLEDGE("MedicationKnowledge"),
        MEDICATION_REQUEST("MedicationRequest"),
        MEDICATION_STATEMENT("MedicationStatement"),
        MEDICINAL_PRODUCT("MedicinalProduct"),
        MEDICINAL_PRODUCT_AUTHORIZATION("MedicinalProductAuthorization"),
        MEDICINAL_PRODUCT_CONTRAINDICATION("MedicinalProductContraindication"),
        MEDICINAL_PRODUCT_INDICATION("MedicinalProductIndication"),
        MEDICINAL_PRODUCT_INGREDIENT("MedicinalProductIngredient"),
        MEDICINAL_PRODUCT_INTERACTION("MedicinalProductInteraction"),
        MEDICINAL_PRODUCT_MANUFACTURED("MedicinalProductManufactured"),
        MEDICINAL_PRODUCT_PACKAGED("MedicinalProductPackaged"),
        MEDICINAL_PRODUCT_PHARMACEUTICAL("MedicinalProductPharmaceutical"),
        MEDICINAL_PRODUCT_UNDESIRABLE_EFFECT("MedicinalProductUndesirableEffect"),
        MESSAGE_DEFINITION("MessageDefinition"),
        MESSAGE_HEADER("MessageHeader"),
        MOLECULAR_SEQUENCE("MolecularSequence"),
        NAMING_SYSTEM("NamingSystem"),
        NUTRITION_ORDER("NutritionOrder"),
        OBSERVATION("Observation"),
        OBSERVATION_DEFINITION("ObservationDefinition"),
        OPERATION_DEFINITION("OperationDefinition"),
        OPERATION_OUTCOME("OperationOutcome"),
        ORGANIZATION("Organization"),
        ORGANIZATION_AFFILIATION("OrganizationAffiliation"),
        PARAMETERS("Parameters"),
        PATIENT("Patient"),
        PAYMENT_NOTICE("PaymentNotice"),
        PAYMENT_RECONCILIATION("PaymentReconciliation"),
        PERSON("Person"),
        PLAN_DEFINITION("PlanDefinition"),
        PRACTITIONER("Practitioner"),
        PRACTITIONER_ROLE("PractitionerRole"),
        PROCEDURE("Procedure"),
        PROVENANCE("Provenance"),
        QUESTIONNAIRE("Questionnaire"),
        QUESTIONNAIRE_RESPONSE("QuestionnaireResponse"),
        RELATED_PERSON("RelatedPerson"),
        REQUEST_GROUP("RequestGroup"),
        RESEARCH_DEFINITION("ResearchDefinition"),
        RESEARCH_ELEMENT_DEFINITION("ResearchElementDefinition"),
        RESEARCH_STUDY("ResearchStudy"),
        RESEARCH_SUBJECT("ResearchSubject"),
        RESOURCE("Resource"),
        RISK_ASSESSMENT("RiskAssessment"),
        RISK_EVIDENCE_SYNTHESIS("RiskEvidenceSynthesis"),
        SCHEDULE("Schedule"),
        SEARCH_PARAMETER("SearchParameter"),
        SERVICE_REQUEST("ServiceRequest"),
        SLOT("Slot"),
        SPECIMEN("Specimen"),
        SPECIMEN_DEFINITION("SpecimenDefinition"),
        STRUCTURE_DEFINITION("StructureDefinition"),
        STRUCTURE_MAP("StructureMap"),
        SUBSCRIPTION("Subscription"),
        SUBSTANCE("Substance"),
        SUBSTANCE_NUCLEIC_ACID("SubstanceNucleicAcid"),
        SUBSTANCE_POLYMER("SubstancePolymer"),
        SUBSTANCE_PROTEIN("SubstanceProtein"),
        SUBSTANCE_REFERENCE_INFORMATION("SubstanceReferenceInformation"),
        SUBSTANCE_SOURCE_MATERIAL("SubstanceSourceMaterial"),
        SUBSTANCE_SPECIFICATION("SubstanceSpecification"),
        SUPPLY_DELIVERY("SupplyDelivery"),
        SUPPLY_REQUEST("SupplyRequest"),
        TASK("Task"),
        TERMINOLOGY_CAPABILITIES("TerminologyCapabilities"),
        TEST_REPORT("TestReport"),
        TEST_SCRIPT("TestScript"),
        VALUE_SET("ValueSet"),
        VERIFICATION_RESULT("VerificationResult"),
        VISION_PRESCRIPTION("VisionPrescription");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public FHIRResourceType build() {
            FHIRResourceType fHIRResourceType = new FHIRResourceType(this);
            if (this.validating) {
                this.validate(fHIRResourceType);
            }
            return fHIRResourceType;
        }

        protected void validate(FHIRResourceType fHIRResourceType) {
            super.validate(fHIRResourceType);
        }

        protected Builder from(FHIRResourceType fHIRResourceType) {
            super.from(fHIRResourceType);
            return this;
        }
    }
}

