/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/FHIR-version")
public class FHIRVersion
extends Code {
    public static final FHIRVersion VERSION_0_01 = FHIRVersion.builder().value(Value.VERSION_0_01).build();
    public static final FHIRVersion VERSION_0_05 = FHIRVersion.builder().value(Value.VERSION_0_05).build();
    public static final FHIRVersion VERSION_0_06 = FHIRVersion.builder().value(Value.VERSION_0_06).build();
    public static final FHIRVersion VERSION_0_11 = FHIRVersion.builder().value(Value.VERSION_0_11).build();
    public static final FHIRVersion VERSION_0_0_80 = FHIRVersion.builder().value(Value.VERSION_0_0_80).build();
    public static final FHIRVersion VERSION_0_0_81 = FHIRVersion.builder().value(Value.VERSION_0_0_81).build();
    public static final FHIRVersion VERSION_0_0_82 = FHIRVersion.builder().value(Value.VERSION_0_0_82).build();
    public static final FHIRVersion VERSION_0_4_0 = FHIRVersion.builder().value(Value.VERSION_0_4_0).build();
    public static final FHIRVersion VERSION_0_5_0 = FHIRVersion.builder().value(Value.VERSION_0_5_0).build();
    public static final FHIRVersion VERSION_1_0_0 = FHIRVersion.builder().value(Value.VERSION_1_0_0).build();
    public static final FHIRVersion VERSION_1_0_1 = FHIRVersion.builder().value(Value.VERSION_1_0_1).build();
    public static final FHIRVersion VERSION_1_0_2 = FHIRVersion.builder().value(Value.VERSION_1_0_2).build();
    public static final FHIRVersion VERSION_1_1_0 = FHIRVersion.builder().value(Value.VERSION_1_1_0).build();
    public static final FHIRVersion VERSION_1_4_0 = FHIRVersion.builder().value(Value.VERSION_1_4_0).build();
    public static final FHIRVersion VERSION_1_6_0 = FHIRVersion.builder().value(Value.VERSION_1_6_0).build();
    public static final FHIRVersion VERSION_1_8_0 = FHIRVersion.builder().value(Value.VERSION_1_8_0).build();
    public static final FHIRVersion VERSION_3_0_0 = FHIRVersion.builder().value(Value.VERSION_3_0_0).build();
    public static final FHIRVersion VERSION_3_0_1 = FHIRVersion.builder().value(Value.VERSION_3_0_1).build();
    public static final FHIRVersion VERSION_3_3_0 = FHIRVersion.builder().value(Value.VERSION_3_3_0).build();
    public static final FHIRVersion VERSION_3_5_0 = FHIRVersion.builder().value(Value.VERSION_3_5_0).build();
    public static final FHIRVersion VERSION_4_0_0 = FHIRVersion.builder().value(Value.VERSION_4_0_0).build();
    public static final FHIRVersion VERSION_4_0_1 = FHIRVersion.builder().value(Value.VERSION_4_0_1).build();
    private volatile int hashCode;

    private FHIRVersion(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static FHIRVersion of(ValueSet value) {
        switch (value) {
            case VERSION_0_01: {
                return VERSION_0_01;
            }
            case VERSION_0_05: {
                return VERSION_0_05;
            }
            case VERSION_0_06: {
                return VERSION_0_06;
            }
            case VERSION_0_11: {
                return VERSION_0_11;
            }
            case VERSION_0_0_80: {
                return VERSION_0_0_80;
            }
            case VERSION_0_0_81: {
                return VERSION_0_0_81;
            }
            case VERSION_0_0_82: {
                return VERSION_0_0_82;
            }
            case VERSION_0_4_0: {
                return VERSION_0_4_0;
            }
            case VERSION_0_5_0: {
                return VERSION_0_5_0;
            }
            case VERSION_1_0_0: {
                return VERSION_1_0_0;
            }
            case VERSION_1_0_1: {
                return VERSION_1_0_1;
            }
            case VERSION_1_0_2: {
                return VERSION_1_0_2;
            }
            case VERSION_1_1_0: {
                return VERSION_1_1_0;
            }
            case VERSION_1_4_0: {
                return VERSION_1_4_0;
            }
            case VERSION_1_6_0: {
                return VERSION_1_6_0;
            }
            case VERSION_1_8_0: {
                return VERSION_1_8_0;
            }
            case VERSION_3_0_0: {
                return VERSION_3_0_0;
            }
            case VERSION_3_0_1: {
                return VERSION_3_0_1;
            }
            case VERSION_3_3_0: {
                return VERSION_3_3_0;
            }
            case VERSION_3_5_0: {
                return VERSION_3_5_0;
            }
            case VERSION_4_0_0: {
                return VERSION_4_0_0;
            }
            case VERSION_4_0_1: {
                return VERSION_4_0_1;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRVersion of(Value value) {
        switch (value) {
            case VERSION_0_01: {
                return VERSION_0_01;
            }
            case VERSION_0_05: {
                return VERSION_0_05;
            }
            case VERSION_0_06: {
                return VERSION_0_06;
            }
            case VERSION_0_11: {
                return VERSION_0_11;
            }
            case VERSION_0_0_80: {
                return VERSION_0_0_80;
            }
            case VERSION_0_0_81: {
                return VERSION_0_0_81;
            }
            case VERSION_0_0_82: {
                return VERSION_0_0_82;
            }
            case VERSION_0_4_0: {
                return VERSION_0_4_0;
            }
            case VERSION_0_5_0: {
                return VERSION_0_5_0;
            }
            case VERSION_1_0_0: {
                return VERSION_1_0_0;
            }
            case VERSION_1_0_1: {
                return VERSION_1_0_1;
            }
            case VERSION_1_0_2: {
                return VERSION_1_0_2;
            }
            case VERSION_1_1_0: {
                return VERSION_1_1_0;
            }
            case VERSION_1_4_0: {
                return VERSION_1_4_0;
            }
            case VERSION_1_6_0: {
                return VERSION_1_6_0;
            }
            case VERSION_1_8_0: {
                return VERSION_1_8_0;
            }
            case VERSION_3_0_0: {
                return VERSION_3_0_0;
            }
            case VERSION_3_0_1: {
                return VERSION_3_0_1;
            }
            case VERSION_3_3_0: {
                return VERSION_3_3_0;
            }
            case VERSION_3_5_0: {
                return VERSION_3_5_0;
            }
            case VERSION_4_0_0: {
                return VERSION_4_0_0;
            }
            case VERSION_4_0_1: {
                return VERSION_4_0_1;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static FHIRVersion of(java.lang.String value) {
        return FHIRVersion.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return FHIRVersion.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return FHIRVersion.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FHIRVersion other = (FHIRVersion)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        VERSION_0_01("0.01"),
        VERSION_0_05("0.05"),
        VERSION_0_06("0.06"),
        VERSION_0_11("0.11"),
        VERSION_0_0_80("0.0.80"),
        VERSION_0_0_81("0.0.81"),
        VERSION_0_0_82("0.0.82"),
        VERSION_0_4_0("0.4.0"),
        VERSION_0_5_0("0.5.0"),
        VERSION_1_0_0("1.0.0"),
        VERSION_1_0_1("1.0.1"),
        VERSION_1_0_2("1.0.2"),
        VERSION_1_1_0("1.1.0"),
        VERSION_1_4_0("1.4.0"),
        VERSION_1_6_0("1.6.0"),
        VERSION_1_8_0("1.8.0"),
        VERSION_3_0_0("3.0.0"),
        VERSION_3_0_1("3.0.1"),
        VERSION_3_3_0("3.3.0"),
        VERSION_3_5_0("3.5.0"),
        VERSION_4_0_0("4.0.0"),
        VERSION_4_0_1("4.0.1");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "0.01": {
                    return VERSION_0_01;
                }
                case "0.05": {
                    return VERSION_0_05;
                }
                case "0.06": {
                    return VERSION_0_06;
                }
                case "0.11": {
                    return VERSION_0_11;
                }
                case "0.0.80": {
                    return VERSION_0_0_80;
                }
                case "0.0.81": {
                    return VERSION_0_0_81;
                }
                case "0.0.82": {
                    return VERSION_0_0_82;
                }
                case "0.4.0": {
                    return VERSION_0_4_0;
                }
                case "0.5.0": {
                    return VERSION_0_5_0;
                }
                case "1.0.0": {
                    return VERSION_1_0_0;
                }
                case "1.0.1": {
                    return VERSION_1_0_1;
                }
                case "1.0.2": {
                    return VERSION_1_0_2;
                }
                case "1.1.0": {
                    return VERSION_1_1_0;
                }
                case "1.4.0": {
                    return VERSION_1_4_0;
                }
                case "1.6.0": {
                    return VERSION_1_6_0;
                }
                case "1.8.0": {
                    return VERSION_1_8_0;
                }
                case "3.0.0": {
                    return VERSION_3_0_0;
                }
                case "3.0.1": {
                    return VERSION_3_0_1;
                }
                case "3.3.0": {
                    return VERSION_3_3_0;
                }
                case "3.5.0": {
                    return VERSION_3_5_0;
                }
                case "4.0.0": {
                    return VERSION_4_0_0;
                }
                case "4.0.1": {
                    return VERSION_4_0_1;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        VERSION_0_01("0.01"),
        VERSION_0_05("0.05"),
        VERSION_0_06("0.06"),
        VERSION_0_11("0.11"),
        VERSION_0_0_80("0.0.80"),
        VERSION_0_0_81("0.0.81"),
        VERSION_0_0_82("0.0.82"),
        VERSION_0_4_0("0.4.0"),
        VERSION_0_5_0("0.5.0"),
        VERSION_1_0_0("1.0.0"),
        VERSION_1_0_1("1.0.1"),
        VERSION_1_0_2("1.0.2"),
        VERSION_1_1_0("1.1.0"),
        VERSION_1_4_0("1.4.0"),
        VERSION_1_6_0("1.6.0"),
        VERSION_1_8_0("1.8.0"),
        VERSION_3_0_0("3.0.0"),
        VERSION_3_0_1("3.0.1"),
        VERSION_3_3_0("3.3.0"),
        VERSION_3_5_0("3.5.0"),
        VERSION_4_0_0("4.0.0"),
        VERSION_4_0_1("4.0.1");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public FHIRVersion build() {
            FHIRVersion fHIRVersion = new FHIRVersion(this);
            if (this.validating) {
                this.validate(fHIRVersion);
            }
            return fHIRVersion;
        }

        protected void validate(FHIRVersion fHIRVersion) {
            super.validate(fHIRVersion);
        }

        protected Builder from(FHIRVersion fHIRVersion) {
            super.from(fHIRVersion);
            return this;
        }
    }
}

