/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/group-type")
public class GroupType
extends Code {
    public static final GroupType PERSON = GroupType.builder().value(Value.PERSON).build();
    public static final GroupType ANIMAL = GroupType.builder().value(Value.ANIMAL).build();
    public static final GroupType PRACTITIONER = GroupType.builder().value(Value.PRACTITIONER).build();
    public static final GroupType DEVICE = GroupType.builder().value(Value.DEVICE).build();
    public static final GroupType MEDICATION = GroupType.builder().value(Value.MEDICATION).build();
    public static final GroupType SUBSTANCE = GroupType.builder().value(Value.SUBSTANCE).build();
    private volatile int hashCode;

    private GroupType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static GroupType of(ValueSet value) {
        switch (value) {
            case PERSON: {
                return PERSON;
            }
            case ANIMAL: {
                return ANIMAL;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case DEVICE: {
                return DEVICE;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GroupType of(Value value) {
        switch (value) {
            case PERSON: {
                return PERSON;
            }
            case ANIMAL: {
                return ANIMAL;
            }
            case PRACTITIONER: {
                return PRACTITIONER;
            }
            case DEVICE: {
                return DEVICE;
            }
            case MEDICATION: {
                return MEDICATION;
            }
            case SUBSTANCE: {
                return SUBSTANCE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static GroupType of(java.lang.String value) {
        return GroupType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return GroupType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return GroupType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupType other = (GroupType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        PERSON("person"),
        ANIMAL("animal"),
        PRACTITIONER("practitioner"),
        DEVICE("device"),
        MEDICATION("medication"),
        SUBSTANCE("substance");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "person": {
                    return PERSON;
                }
                case "animal": {
                    return ANIMAL;
                }
                case "practitioner": {
                    return PRACTITIONER;
                }
                case "device": {
                    return DEVICE;
                }
                case "medication": {
                    return MEDICATION;
                }
                case "substance": {
                    return SUBSTANCE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        PERSON("person"),
        ANIMAL("animal"),
        PRACTITIONER("practitioner"),
        DEVICE("device"),
        MEDICATION("medication"),
        SUBSTANCE("substance");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public GroupType build() {
            GroupType groupType = new GroupType(this);
            if (this.validating) {
                this.validate(groupType);
            }
            return groupType;
        }

        protected void validate(GroupType groupType) {
            super.validate(groupType);
        }

        protected Builder from(GroupType groupType) {
            super.from(groupType);
            return this;
        }
    }
}

