/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/event-status")
public class ImmunizationStatus
extends Code {
    public static final ImmunizationStatus COMPLETED = ImmunizationStatus.builder().value(Value.COMPLETED).build();
    public static final ImmunizationStatus ENTERED_IN_ERROR = ImmunizationStatus.builder().value(Value.ENTERED_IN_ERROR).build();
    public static final ImmunizationStatus NOT_DONE = ImmunizationStatus.builder().value(Value.NOT_DONE).build();
    private volatile int hashCode;

    private ImmunizationStatus(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static ImmunizationStatus of(ValueSet value) {
        switch (value) {
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case NOT_DONE: {
                return NOT_DONE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ImmunizationStatus of(Value value) {
        switch (value) {
            case COMPLETED: {
                return COMPLETED;
            }
            case ENTERED_IN_ERROR: {
                return ENTERED_IN_ERROR;
            }
            case NOT_DONE: {
                return NOT_DONE;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static ImmunizationStatus of(java.lang.String value) {
        return ImmunizationStatus.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return ImmunizationStatus.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return ImmunizationStatus.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmunizationStatus other = (ImmunizationStatus)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        NOT_DONE("not-done");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "completed": {
                    return COMPLETED;
                }
                case "entered-in-error": {
                    return ENTERED_IN_ERROR;
                }
                case "not-done": {
                    return NOT_DONE;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        COMPLETED("completed"),
        ENTERED_IN_ERROR("entered-in-error"),
        NOT_DONE("not-done");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public ImmunizationStatus build() {
            ImmunizationStatus immunizationStatus = new ImmunizationStatus(this);
            if (this.validating) {
                this.validate(immunizationStatus);
            }
            return immunizationStatus;
        }

        protected void validate(ImmunizationStatus immunizationStatus) {
            super.validate(immunizationStatus);
        }

        protected Builder from(ImmunizationStatus immunizationStatus) {
            super.from(immunizationStatus);
            return this;
        }
    }
}

