/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/property-representation")
public class PropertyRepresentation
extends Code {
    public static final PropertyRepresentation XML_ATTR = PropertyRepresentation.builder().value(Value.XML_ATTR).build();
    public static final PropertyRepresentation XML_TEXT = PropertyRepresentation.builder().value(Value.XML_TEXT).build();
    public static final PropertyRepresentation TYPE_ATTR = PropertyRepresentation.builder().value(Value.TYPE_ATTR).build();
    public static final PropertyRepresentation CDA_TEXT = PropertyRepresentation.builder().value(Value.CDA_TEXT).build();
    public static final PropertyRepresentation XHTML = PropertyRepresentation.builder().value(Value.XHTML).build();
    private volatile int hashCode;

    private PropertyRepresentation(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static PropertyRepresentation of(ValueSet value) {
        switch (value) {
            case XML_ATTR: {
                return XML_ATTR;
            }
            case XML_TEXT: {
                return XML_TEXT;
            }
            case TYPE_ATTR: {
                return TYPE_ATTR;
            }
            case CDA_TEXT: {
                return CDA_TEXT;
            }
            case XHTML: {
                return XHTML;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static PropertyRepresentation of(Value value) {
        switch (value) {
            case XML_ATTR: {
                return XML_ATTR;
            }
            case XML_TEXT: {
                return XML_TEXT;
            }
            case TYPE_ATTR: {
                return TYPE_ATTR;
            }
            case CDA_TEXT: {
                return CDA_TEXT;
            }
            case XHTML: {
                return XHTML;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static PropertyRepresentation of(java.lang.String value) {
        return PropertyRepresentation.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return PropertyRepresentation.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return PropertyRepresentation.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyRepresentation other = (PropertyRepresentation)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        XML_ATTR("xmlAttr"),
        XML_TEXT("xmlText"),
        TYPE_ATTR("typeAttr"),
        CDA_TEXT("cdaText"),
        XHTML("xhtml");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "xmlAttr": {
                    return XML_ATTR;
                }
                case "xmlText": {
                    return XML_TEXT;
                }
                case "typeAttr": {
                    return TYPE_ATTR;
                }
                case "cdaText": {
                    return CDA_TEXT;
                }
                case "xhtml": {
                    return XHTML;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        XML_ATTR("xmlAttr"),
        XML_TEXT("xmlText"),
        TYPE_ATTR("typeAttr"),
        CDA_TEXT("cdaText"),
        XHTML("xhtml");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public PropertyRepresentation build() {
            PropertyRepresentation propertyRepresentation = new PropertyRepresentation(this);
            if (this.validating) {
                this.validate(propertyRepresentation);
            }
            return propertyRepresentation;
        }

        protected void validate(PropertyRepresentation propertyRepresentation) {
            super.validate(propertyRepresentation);
        }

        protected Builder from(PropertyRepresentation propertyRepresentation) {
            super.from(propertyRepresentation);
            return this;
        }
    }
}

