/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/related-artifact-type")
public class RelatedArtifactType
extends Code {
    public static final RelatedArtifactType DOCUMENTATION = RelatedArtifactType.builder().value(Value.DOCUMENTATION).build();
    public static final RelatedArtifactType JUSTIFICATION = RelatedArtifactType.builder().value(Value.JUSTIFICATION).build();
    public static final RelatedArtifactType CITATION = RelatedArtifactType.builder().value(Value.CITATION).build();
    public static final RelatedArtifactType PREDECESSOR = RelatedArtifactType.builder().value(Value.PREDECESSOR).build();
    public static final RelatedArtifactType SUCCESSOR = RelatedArtifactType.builder().value(Value.SUCCESSOR).build();
    public static final RelatedArtifactType DERIVED_FROM = RelatedArtifactType.builder().value(Value.DERIVED_FROM).build();
    public static final RelatedArtifactType DEPENDS_ON = RelatedArtifactType.builder().value(Value.DEPENDS_ON).build();
    public static final RelatedArtifactType COMPOSED_OF = RelatedArtifactType.builder().value(Value.COMPOSED_OF).build();
    private volatile int hashCode;

    private RelatedArtifactType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static RelatedArtifactType of(ValueSet value) {
        switch (value) {
            case DOCUMENTATION: {
                return DOCUMENTATION;
            }
            case JUSTIFICATION: {
                return JUSTIFICATION;
            }
            case CITATION: {
                return CITATION;
            }
            case PREDECESSOR: {
                return PREDECESSOR;
            }
            case SUCCESSOR: {
                return SUCCESSOR;
            }
            case DERIVED_FROM: {
                return DERIVED_FROM;
            }
            case DEPENDS_ON: {
                return DEPENDS_ON;
            }
            case COMPOSED_OF: {
                return COMPOSED_OF;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static RelatedArtifactType of(Value value) {
        switch (value) {
            case DOCUMENTATION: {
                return DOCUMENTATION;
            }
            case JUSTIFICATION: {
                return JUSTIFICATION;
            }
            case CITATION: {
                return CITATION;
            }
            case PREDECESSOR: {
                return PREDECESSOR;
            }
            case SUCCESSOR: {
                return SUCCESSOR;
            }
            case DERIVED_FROM: {
                return DERIVED_FROM;
            }
            case DEPENDS_ON: {
                return DEPENDS_ON;
            }
            case COMPOSED_OF: {
                return COMPOSED_OF;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static RelatedArtifactType of(java.lang.String value) {
        return RelatedArtifactType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return RelatedArtifactType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return RelatedArtifactType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RelatedArtifactType other = (RelatedArtifactType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        DOCUMENTATION("documentation"),
        JUSTIFICATION("justification"),
        CITATION("citation"),
        PREDECESSOR("predecessor"),
        SUCCESSOR("successor"),
        DERIVED_FROM("derived-from"),
        DEPENDS_ON("depends-on"),
        COMPOSED_OF("composed-of");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "documentation": {
                    return DOCUMENTATION;
                }
                case "justification": {
                    return JUSTIFICATION;
                }
                case "citation": {
                    return CITATION;
                }
                case "predecessor": {
                    return PREDECESSOR;
                }
                case "successor": {
                    return SUCCESSOR;
                }
                case "derived-from": {
                    return DERIVED_FROM;
                }
                case "depends-on": {
                    return DEPENDS_ON;
                }
                case "composed-of": {
                    return COMPOSED_OF;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        DOCUMENTATION("documentation"),
        JUSTIFICATION("justification"),
        CITATION("citation"),
        PREDECESSOR("predecessor"),
        SUCCESSOR("successor"),
        DERIVED_FROM("derived-from"),
        DEPENDS_ON("depends-on"),
        COMPOSED_OF("composed-of");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public RelatedArtifactType build() {
            RelatedArtifactType relatedArtifactType = new RelatedArtifactType(this);
            if (this.validating) {
                this.validate(relatedArtifactType);
            }
            return relatedArtifactType;
        }

        protected void validate(RelatedArtifactType relatedArtifactType) {
            super.validate(relatedArtifactType);
        }

        protected Builder from(RelatedArtifactType relatedArtifactType) {
            super.from(relatedArtifactType);
            return this;
        }
    }
}

