/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/search-entry-mode")
public class SearchEntryMode
extends Code {
    public static final SearchEntryMode MATCH = SearchEntryMode.builder().value(Value.MATCH).build();
    public static final SearchEntryMode INCLUDE = SearchEntryMode.builder().value(Value.INCLUDE).build();
    public static final SearchEntryMode OUTCOME = SearchEntryMode.builder().value(Value.OUTCOME).build();
    private volatile int hashCode;

    private SearchEntryMode(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static SearchEntryMode of(ValueSet value) {
        switch (value) {
            case MATCH: {
                return MATCH;
            }
            case INCLUDE: {
                return INCLUDE;
            }
            case OUTCOME: {
                return OUTCOME;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SearchEntryMode of(Value value) {
        switch (value) {
            case MATCH: {
                return MATCH;
            }
            case INCLUDE: {
                return INCLUDE;
            }
            case OUTCOME: {
                return OUTCOME;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static SearchEntryMode of(java.lang.String value) {
        return SearchEntryMode.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return SearchEntryMode.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return SearchEntryMode.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchEntryMode other = (SearchEntryMode)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        MATCH("match"),
        INCLUDE("include"),
        OUTCOME("outcome");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "match": {
                    return MATCH;
                }
                case "include": {
                    return INCLUDE;
                }
                case "outcome": {
                    return OUTCOME;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        MATCH("match"),
        INCLUDE("include"),
        OUTCOME("outcome");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public SearchEntryMode build() {
            SearchEntryMode searchEntryMode = new SearchEntryMode(this);
            if (this.validating) {
                this.validate(searchEntryMode);
            }
            return searchEntryMode;
        }

        protected void validate(SearchEntryMode searchEntryMode) {
            super.validate(searchEntryMode);
        }

        protected Builder from(SearchEntryMode searchEntryMode) {
            super.from(searchEntryMode);
            return this;
        }
    }
}

