/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/map-transform")
public class StructureMapTransform
extends Code {
    public static final StructureMapTransform CREATE = StructureMapTransform.builder().value(Value.CREATE).build();
    public static final StructureMapTransform COPY = StructureMapTransform.builder().value(Value.COPY).build();
    public static final StructureMapTransform TRUNCATE = StructureMapTransform.builder().value(Value.TRUNCATE).build();
    public static final StructureMapTransform ESCAPE = StructureMapTransform.builder().value(Value.ESCAPE).build();
    public static final StructureMapTransform CAST = StructureMapTransform.builder().value(Value.CAST).build();
    public static final StructureMapTransform APPEND = StructureMapTransform.builder().value(Value.APPEND).build();
    public static final StructureMapTransform TRANSLATE = StructureMapTransform.builder().value(Value.TRANSLATE).build();
    public static final StructureMapTransform REFERENCE = StructureMapTransform.builder().value(Value.REFERENCE).build();
    public static final StructureMapTransform DATE_OP = StructureMapTransform.builder().value(Value.DATE_OP).build();
    public static final StructureMapTransform UUID = StructureMapTransform.builder().value(Value.UUID).build();
    public static final StructureMapTransform POINTER = StructureMapTransform.builder().value(Value.POINTER).build();
    public static final StructureMapTransform EVALUATE = StructureMapTransform.builder().value(Value.EVALUATE).build();
    public static final StructureMapTransform CC = StructureMapTransform.builder().value(Value.CC).build();
    public static final StructureMapTransform C = StructureMapTransform.builder().value(Value.C).build();
    public static final StructureMapTransform QTY = StructureMapTransform.builder().value(Value.QTY).build();
    public static final StructureMapTransform ID = StructureMapTransform.builder().value(Value.ID).build();
    public static final StructureMapTransform CP = StructureMapTransform.builder().value(Value.CP).build();
    private volatile int hashCode;

    private StructureMapTransform(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static StructureMapTransform of(ValueSet value) {
        switch (value) {
            case CREATE: {
                return CREATE;
            }
            case COPY: {
                return COPY;
            }
            case TRUNCATE: {
                return TRUNCATE;
            }
            case ESCAPE: {
                return ESCAPE;
            }
            case CAST: {
                return CAST;
            }
            case APPEND: {
                return APPEND;
            }
            case TRANSLATE: {
                return TRANSLATE;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case DATE_OP: {
                return DATE_OP;
            }
            case UUID: {
                return UUID;
            }
            case POINTER: {
                return POINTER;
            }
            case EVALUATE: {
                return EVALUATE;
            }
            case CC: {
                return CC;
            }
            case C: {
                return C;
            }
            case QTY: {
                return QTY;
            }
            case ID: {
                return ID;
            }
            case CP: {
                return CP;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapTransform of(Value value) {
        switch (value) {
            case CREATE: {
                return CREATE;
            }
            case COPY: {
                return COPY;
            }
            case TRUNCATE: {
                return TRUNCATE;
            }
            case ESCAPE: {
                return ESCAPE;
            }
            case CAST: {
                return CAST;
            }
            case APPEND: {
                return APPEND;
            }
            case TRANSLATE: {
                return TRANSLATE;
            }
            case REFERENCE: {
                return REFERENCE;
            }
            case DATE_OP: {
                return DATE_OP;
            }
            case UUID: {
                return UUID;
            }
            case POINTER: {
                return POINTER;
            }
            case EVALUATE: {
                return EVALUATE;
            }
            case CC: {
                return CC;
            }
            case C: {
                return C;
            }
            case QTY: {
                return QTY;
            }
            case ID: {
                return ID;
            }
            case CP: {
                return CP;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static StructureMapTransform of(java.lang.String value) {
        return StructureMapTransform.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return StructureMapTransform.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return StructureMapTransform.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructureMapTransform other = (StructureMapTransform)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        CREATE("create"),
        COPY("copy"),
        TRUNCATE("truncate"),
        ESCAPE("escape"),
        CAST("cast"),
        APPEND("append"),
        TRANSLATE("translate"),
        REFERENCE("reference"),
        DATE_OP("dateOp"),
        UUID("uuid"),
        POINTER("pointer"),
        EVALUATE("evaluate"),
        CC("cc"),
        C("c"),
        QTY("qty"),
        ID("id"),
        CP("cp");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "create": {
                    return CREATE;
                }
                case "copy": {
                    return COPY;
                }
                case "truncate": {
                    return TRUNCATE;
                }
                case "escape": {
                    return ESCAPE;
                }
                case "cast": {
                    return CAST;
                }
                case "append": {
                    return APPEND;
                }
                case "translate": {
                    return TRANSLATE;
                }
                case "reference": {
                    return REFERENCE;
                }
                case "dateOp": {
                    return DATE_OP;
                }
                case "uuid": {
                    return UUID;
                }
                case "pointer": {
                    return POINTER;
                }
                case "evaluate": {
                    return EVALUATE;
                }
                case "cc": {
                    return CC;
                }
                case "c": {
                    return C;
                }
                case "qty": {
                    return QTY;
                }
                case "id": {
                    return ID;
                }
                case "cp": {
                    return CP;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        CREATE("create"),
        COPY("copy"),
        TRUNCATE("truncate"),
        ESCAPE("escape"),
        CAST("cast"),
        APPEND("append"),
        TRANSLATE("translate"),
        REFERENCE("reference"),
        DATE_OP("dateOp"),
        UUID("uuid"),
        POINTER("pointer"),
        EVALUATE("evaluate"),
        CC("cc"),
        C("c"),
        QTY("qty"),
        ID("id"),
        CP("cp");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public StructureMapTransform build() {
            StructureMapTransform structureMapTransform = new StructureMapTransform(this);
            if (this.validating) {
                this.validate(structureMapTransform);
            }
            return structureMapTransform;
        }

        protected void validate(StructureMapTransform structureMapTransform) {
            super.validate(structureMapTransform);
        }

        protected Builder from(StructureMapTransform structureMapTransform) {
            super.from(structureMapTransform);
            return this;
        }
    }
}

