/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/trigger-type")
public class TriggerType
extends Code {
    public static final TriggerType NAMED_EVENT = TriggerType.builder().value(Value.NAMED_EVENT).build();
    public static final TriggerType PERIODIC = TriggerType.builder().value(Value.PERIODIC).build();
    public static final TriggerType DATA_CHANGED = TriggerType.builder().value(Value.DATA_CHANGED).build();
    public static final TriggerType DATA_ADDED = TriggerType.builder().value(Value.DATA_ADDED).build();
    public static final TriggerType DATA_MODIFIED = TriggerType.builder().value(Value.DATA_MODIFIED).build();
    public static final TriggerType DATA_REMOVED = TriggerType.builder().value(Value.DATA_REMOVED).build();
    public static final TriggerType DATA_ACCESSED = TriggerType.builder().value(Value.DATA_ACCESSED).build();
    public static final TriggerType DATA_ACCESS_ENDED = TriggerType.builder().value(Value.DATA_ACCESS_ENDED).build();
    private volatile int hashCode;

    private TriggerType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static TriggerType of(ValueSet value) {
        switch (value) {
            case NAMED_EVENT: {
                return NAMED_EVENT;
            }
            case PERIODIC: {
                return PERIODIC;
            }
            case DATA_CHANGED: {
                return DATA_CHANGED;
            }
            case DATA_ADDED: {
                return DATA_ADDED;
            }
            case DATA_MODIFIED: {
                return DATA_MODIFIED;
            }
            case DATA_REMOVED: {
                return DATA_REMOVED;
            }
            case DATA_ACCESSED: {
                return DATA_ACCESSED;
            }
            case DATA_ACCESS_ENDED: {
                return DATA_ACCESS_ENDED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static TriggerType of(Value value) {
        switch (value) {
            case NAMED_EVENT: {
                return NAMED_EVENT;
            }
            case PERIODIC: {
                return PERIODIC;
            }
            case DATA_CHANGED: {
                return DATA_CHANGED;
            }
            case DATA_ADDED: {
                return DATA_ADDED;
            }
            case DATA_MODIFIED: {
                return DATA_MODIFIED;
            }
            case DATA_REMOVED: {
                return DATA_REMOVED;
            }
            case DATA_ACCESSED: {
                return DATA_ACCESSED;
            }
            case DATA_ACCESS_ENDED: {
                return DATA_ACCESS_ENDED;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static TriggerType of(java.lang.String value) {
        return TriggerType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return TriggerType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return TriggerType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TriggerType other = (TriggerType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        NAMED_EVENT("named-event"),
        PERIODIC("periodic"),
        DATA_CHANGED("data-changed"),
        DATA_ADDED("data-added"),
        DATA_MODIFIED("data-modified"),
        DATA_REMOVED("data-removed"),
        DATA_ACCESSED("data-accessed"),
        DATA_ACCESS_ENDED("data-access-ended");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "named-event": {
                    return NAMED_EVENT;
                }
                case "periodic": {
                    return PERIODIC;
                }
                case "data-changed": {
                    return DATA_CHANGED;
                }
                case "data-added": {
                    return DATA_ADDED;
                }
                case "data-modified": {
                    return DATA_MODIFIED;
                }
                case "data-removed": {
                    return DATA_REMOVED;
                }
                case "data-accessed": {
                    return DATA_ACCESSED;
                }
                case "data-access-ended": {
                    return DATA_ACCESS_ENDED;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        NAMED_EVENT("named-event"),
        PERIODIC("periodic"),
        DATA_CHANGED("data-changed"),
        DATA_ADDED("data-added"),
        DATA_MODIFIED("data-modified"),
        DATA_REMOVED("data-removed"),
        DATA_ACCESSED("data-accessed"),
        DATA_ACCESS_ENDED("data-access-ended");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public TriggerType build() {
            TriggerType triggerType = new TriggerType(this);
            if (this.validating) {
                this.validate(triggerType);
            }
            return triggerType;
        }

        protected void validate(TriggerType triggerType) {
            super.validate(triggerType);
        }

        protected Builder from(TriggerType triggerType) {
            super.from(triggerType);
            return this;
        }
    }
}

