/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.type.code;

import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.String;
import java.util.Collection;
import java.util.Objects;

@System(value="http://hl7.org/fhir/udi-entry-type")
public class UDIEntryType
extends Code {
    public static final UDIEntryType BARCODE = UDIEntryType.builder().value(Value.BARCODE).build();
    public static final UDIEntryType RFID = UDIEntryType.builder().value(Value.RFID).build();
    public static final UDIEntryType MANUAL = UDIEntryType.builder().value(Value.MANUAL).build();
    public static final UDIEntryType CARD = UDIEntryType.builder().value(Value.CARD).build();
    public static final UDIEntryType SELF_REPORTED = UDIEntryType.builder().value(Value.SELF_REPORTED).build();
    public static final UDIEntryType UNKNOWN = UDIEntryType.builder().value(Value.UNKNOWN).build();
    private volatile int hashCode;

    private UDIEntryType(Builder builder) {
        super(builder);
    }

    @Deprecated
    public ValueSet getValueAsEnumConstant() {
        return this.value != null ? ValueSet.from(this.value) : null;
    }

    public Value getValueAsEnum() {
        return this.value != null ? Value.from(this.value) : null;
    }

    @Deprecated
    public static UDIEntryType of(ValueSet value) {
        switch (value) {
            case BARCODE: {
                return BARCODE;
            }
            case RFID: {
                return RFID;
            }
            case MANUAL: {
                return MANUAL;
            }
            case CARD: {
                return CARD;
            }
            case SELF_REPORTED: {
                return SELF_REPORTED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static UDIEntryType of(Value value) {
        switch (value) {
            case BARCODE: {
                return BARCODE;
            }
            case RFID: {
                return RFID;
            }
            case MANUAL: {
                return MANUAL;
            }
            case CARD: {
                return CARD;
            }
            case SELF_REPORTED: {
                return SELF_REPORTED;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException(value.name());
    }

    public static UDIEntryType of(java.lang.String value) {
        return UDIEntryType.of(Value.from(value));
    }

    public static String string(java.lang.String value) {
        return UDIEntryType.of(Value.from(value));
    }

    public static Code code(java.lang.String value) {
        return UDIEntryType.of(Value.from(value));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UDIEntryType other = (UDIEntryType)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.extension, other.extension) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.id, this.extension, this.value);
        }
        return result;
    }

    @Override
    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Value {
        BARCODE("barcode"),
        RFID("rfid"),
        MANUAL("manual"),
        CARD("card"),
        SELF_REPORTED("self-reported"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private Value(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static Value from(java.lang.String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "barcode": {
                    return BARCODE;
                }
                case "rfid": {
                    return RFID;
                }
                case "manual": {
                    return MANUAL;
                }
                case "card": {
                    return CARD;
                }
                case "self-reported": {
                    return SELF_REPORTED;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException(value);
        }
    }

    @Deprecated
    public static enum ValueSet {
        BARCODE("barcode"),
        RFID("rfid"),
        MANUAL("manual"),
        CARD("card"),
        SELF_REPORTED("self-reported"),
        UNKNOWN("unknown");

        private final java.lang.String value;

        private ValueSet(java.lang.String value) {
            this.value = value;
        }

        public java.lang.String value() {
            return this.value;
        }

        public static ValueSet from(java.lang.String value) {
            for (ValueSet c : ValueSet.values()) {
                if (!c.value.equals(value)) continue;
                return c;
            }
            throw new IllegalArgumentException(value);
        }
    }

    public static class Builder
    extends Code.Builder {
        private Builder() {
        }

        @Override
        public Builder id(java.lang.String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder extension(Extension ... extension) {
            return (Builder)super.extension(extension);
        }

        @Override
        public Builder extension(Collection<Extension> extension) {
            return (Builder)super.extension((Collection)extension);
        }

        @Override
        public Builder value(java.lang.String value) {
            return value != null ? (Builder)super.value(Value.from(value).value()) : this;
        }

        @Deprecated
        public Builder value(ValueSet value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        public Builder value(Value value) {
            return value != null ? (Builder)super.value(value.value()) : this;
        }

        @Override
        public UDIEntryType build() {
            UDIEntryType uDIEntryType = new UDIEntryType(this);
            if (this.validating) {
                this.validate(uDIEntryType);
            }
            return uDIEntryType;
        }

        protected void validate(UDIEntryType uDIEntryType) {
            super.validate(uDIEntryType);
        }

        protected Builder from(UDIEntryType uDIEntryType) {
            super.from(uDIEntryType);
            return this;
        }
    }
}

