/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.exception.FHIRException;
import com.ibm.fhir.exception.FHIROperationException;
import com.ibm.fhir.model.config.FHIRModelConfig;
import com.ibm.fhir.model.generator.FHIRGenerator;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.code.BundleType;
import com.ibm.fhir.model.type.code.DataAbsentReason;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.model.type.code.IssueType;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.model.util.ReferenceMappingVisitor;
import com.ibm.fhir.model.util.ReferenceType;
import com.ibm.fhir.model.visitor.Visitable;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;

public class FHIRUtil {
    public static final Pattern REFERENCE_PATTERN = FHIRUtil.buildReferencePattern();
    public static final Extension DATA_ABSENT_REASON_UNKNOWN = Extension.builder().url("http://hl7.org/fhir/StructureDefinition/data-absent-reason").value(DataAbsentReason.UNKNOWN).build();
    public static final String STRING_DATA_ABSENT_REASON_UNKNOWN = String.builder().extension(DATA_ABSENT_REASON_UNKNOWN).build();
    @Deprecated
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final JsonBuilderFactory BUILDER_FACTORY = Json.createBuilderFactory(null);
    private static final Logger log = Logger.getLogger(FHIRUtil.class.getName());
    public static final OperationOutcome ALL_OK = OperationOutcome.builder().issue(OperationOutcome.Issue.builder().severity(IssueSeverity.INFORMATION).code(IssueType.INFORMATIONAL).details(CodeableConcept.builder().text(String.string("All OK")).build()).build()).build();

    private FHIRUtil() {
    }

    public static void init() {
    }

    public static java.lang.String toString(Visitable visitable) {
        try {
            FHIRGenerator generator = FHIRGenerator.generator(FHIRModelConfig.getToStringFormat(), FHIRModelConfig.getToStringPrettyPrinting());
            if (generator.isPropertySupported("com.ibm.fhir.model.generator.indentAmount")) {
                generator.setProperty("com.ibm.fhir.model.generator.indentAmount", FHIRModelConfig.getToStringIndentAmount());
            }
            StringWriter writer = new StringWriter();
            generator.generate(visitable, writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Pattern buildReferencePattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("((http|https)://([A-Za-z0-9\\\\\\/\\.\\:\\%\\$\\-])*)?(");
        sb.append(ModelSupport.getResourceTypes(false).stream().map(Class::getSimpleName).collect(Collectors.joining("|")));
        sb.append(")\\/([A-Za-z0-9\\-\\.]{1,64})(\\/_history\\/([A-Za-z0-9\\-\\.]{1,64}))?");
        return Pattern.compile(sb.toString());
    }

    public static JsonObjectBuilder toJsonObjectBuilder(JsonObject jsonObject) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        for (java.lang.String key : jsonObject.keySet()) {
            JsonValue value = (JsonValue)jsonObject.get((Object)key);
            builder.add(key, value);
        }
        return builder;
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(java.lang.String msg, IssueType code) {
        return FHIRUtil.buildOperationOutcomeIssue(IssueSeverity.FATAL, code, msg, "<empty>");
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(IssueSeverity severity, IssueType code, java.lang.String details) {
        return FHIRUtil.buildOperationOutcomeIssue(severity, code, details, null);
    }

    public static OperationOutcome.Issue buildOperationOutcomeIssue(IssueSeverity severity, IssueType code, java.lang.String details, java.lang.String expression) {
        if (details == null || details.isEmpty()) {
            details = "<no details>";
        }
        if (expression == null || expression.isEmpty()) {
            expression = "<no expression>";
        }
        return OperationOutcome.Issue.builder().severity(severity).code(code).details(CodeableConcept.builder().text(String.string(details)).build()).expression(Collections.singletonList(String.string(expression))).build();
    }

    public static OperationOutcome buildOperationOutcome(Collection<OperationOutcome.Issue> issues) {
        if (issues == null || issues.isEmpty()) {
            return ALL_OK;
        }
        return OperationOutcome.builder().issue(issues).build();
    }

    public static OperationOutcome buildOperationOutcome(FHIROperationException e, boolean includeCausedByClauses) {
        if (e.getIssues() != null && e.getIssues().size() > 0) {
            java.lang.String id = e.getUniqueId();
            return FHIRUtil.buildOperationOutcome(e.getIssues()).toBuilder().id(id).build();
        }
        return FHIRUtil.buildOperationOutcome((FHIRException)e, includeCausedByClauses);
    }

    public static OperationOutcome buildOperationOutcome(FHIRException e, boolean includeCausedByClauses) {
        java.lang.String id = e.getUniqueId();
        return FHIRUtil.buildOperationOutcome((Exception)e, includeCausedByClauses).toBuilder().id(id).build();
    }

    public static OperationOutcome buildOperationOutcome(Exception exception, boolean includeCausedByClauses) {
        return FHIRUtil.buildOperationOutcome(exception, null, null, includeCausedByClauses);
    }

    public static OperationOutcome buildOperationOutcome(Exception exception, IssueType issueType, IssueSeverity severity, boolean includeCausedByClauses) {
        StringBuilder msgs = new StringBuilder();
        Throwable e = exception;
        java.lang.String causedBy = "";
        while (e != null) {
            msgs.append(causedBy + e.getClass().getSimpleName() + ": " + (e.getMessage() != null ? e.getMessage().replaceAll("<", "&lt;").replaceAll(">", "&gt;") : "&lt;null message&gt;"));
            e = e.getCause();
            causedBy = System.lineSeparator() + "Caused by: ";
            if (includeCausedByClauses) continue;
            e = null;
        }
        return FHIRUtil.buildOperationOutcome(msgs.toString(), issueType, severity);
    }

    public static OperationOutcome buildOperationOutcome(java.lang.String message, IssueType issueType, IssueSeverity severity) {
        if (issueType == null) {
            issueType = IssueType.EXCEPTION;
        }
        if (severity == null) {
            severity = IssueSeverity.FATAL;
        }
        OperationOutcome.Issue ooi = OperationOutcome.Issue.builder().severity(severity).code(issueType).details(CodeableConcept.builder().text(String.string(message)).build()).build();
        OperationOutcome oo = OperationOutcome.builder().issue(Collections.singletonList(ooi)).build();
        return oo;
    }

    public static URI buildLocationURI(java.lang.String type, Resource resource) {
        java.lang.String resourceTypeName = resource.getClass().getSimpleName();
        if (!resourceTypeName.equals(type)) {
            resourceTypeName = type;
        }
        return URI.create(resourceTypeName + "/" + resource.getId() + "/_history/" + resource.getMeta().getVersionId().getValue());
    }

    public static Resource resolveReference(Reference ref, DomainResource resource, Bundle bundle, Bundle.Entry entry) throws Exception {
        switch (ReferenceType.of(ref)) {
            case CONTAINED: {
                return FHIRUtil.resolveContainedReference(resource, ref);
            }
            case ABSOLUTE_FHIR_URL: 
            case RELATIVE_FHIR_URL: 
            case ABSOLUTE_UUID: 
            case ABSOLUTE_OID: 
            case ABSOLUTE_OTHER_URL: 
            case OTHER: {
                Bundle.Entry targetEntry = FHIRUtil.resolveBundleReference(bundle, entry, ref);
                return targetEntry.getResource();
            }
            case NO_REFERENCE_VALUE: {
                throw new FHIRException("Reference must have a nonempty value to be resolved");
            }
        }
        throw new FHIRException("Cannot resolve invalid reference value " + ref.getReference().getValue());
    }

    public static Resource resolveContainedReference(DomainResource resource, Reference ref) throws Exception {
        if (ref == null || ref.getReference() == null || ref.getReference().getValue() == null) {
            throw new FHIRException("Reference must have a nonempty value to be resolved");
        }
        java.lang.String referenceUriString = ref.getReference().getValue();
        if (referenceUriString.startsWith("#")) {
            referenceUriString = referenceUriString.substring(1);
            List<Resource> containedResources = resource.getContained();
            for (Resource containedResource : containedResources) {
                java.lang.String id = containedResource.getId();
                if (id == null || !referenceUriString.equals(id)) continue;
                return containedResource;
            }
        }
        throw new FHIRException("Resource does not contain the referenced resource");
    }

    public static <T extends Resource> T resolveBundleReference(Class<T> resourceType, Bundle bundle, Bundle.Entry sourceEntry, Reference ref) throws Exception {
        Bundle.Entry targetEntry = FHIRUtil.resolveBundleReference(bundle, sourceEntry, ref);
        return (T)targetEntry.getResource();
    }

    public static Bundle.Entry resolveBundleReference(Bundle bundle, Bundle.Entry sourceEntry, Reference ref) throws FHIRException, URISyntaxException {
        java.lang.String version;
        if (ref == null || ref.getReference() == null || ref.getReference().getValue() == null) {
            throw new FHIRException("Reference must have a nonempty value to be resolved");
        }
        java.lang.String referenceUriString = ref.getReference().getValue();
        URI referenceUri = new URI(referenceUriString);
        if (!referenceUri.isAbsolute()) {
            if (referenceUriString.startsWith("#")) {
                throw new IllegalArgumentException("Cannot resolve fragment reference " + referenceUriString + " to a BundleEntry. See resolveReference instead.");
            }
            Uri sourceEntryFullUrl = sourceEntry.getFullUrl();
            if (sourceEntryFullUrl != null) {
                java.lang.String sourceEntryUriString = sourceEntryFullUrl.getValue();
                URI sourceEntryUri = new URI(sourceEntryUriString);
                if (!sourceEntryUri.isAbsolute()) {
                    throw new FHIRException("The Bundle entry that contains the reference must have an absolute fullUrl to resolve relative references");
                }
                Matcher restUrlMatcher = REFERENCE_PATTERN.matcher(sourceEntryUriString);
                if (restUrlMatcher.matches() && restUrlMatcher.groupCount() > 0) {
                    java.lang.String urlBase = restUrlMatcher.group(1);
                    referenceUriString = urlBase + referenceUriString;
                }
            }
        }
        if ((version = referenceUri.getFragment()) != null) {
            referenceUriString = referenceUriString.substring(0, referenceUriString.length() - version.length());
        }
        for (Bundle.Entry entry : bundle.getEntry()) {
            java.lang.String fullUrlValue;
            Uri fullUrl = entry.getFullUrl();
            if (fullUrl == null || (fullUrlValue = entry.getFullUrl().getValue()) == null || !fullUrlValue.equals(referenceUriString)) continue;
            try {
                Resource resource = entry.getResource();
                if (version != null && resource.getMeta() != null && resource.getMeta().getVersionId() != null) {
                    Id versionId = resource.getMeta().getVersionId();
                    if (!version.equals(versionId.getValue())) continue;
                    return entry;
                }
                return entry;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to retrieve resource " + referenceUriString + " from the bundle", e);
            }
        }
        throw new FHIRException("Bundle does not contain the referenced resource and retrieval of resources outside the bundle is not supported.");
    }

    public static java.lang.String getExtensionStringValue(Resource resource, java.lang.String extensionUrl) {
        java.lang.String value = null;
        if (Objects.nonNull(resource) && Objects.nonNull(extensionUrl) && resource instanceof DomainResource) {
            DomainResource dr = (DomainResource)resource;
            value = FHIRUtil.getExtensionStringValue(extensionUrl, dr.getExtension());
        }
        return value;
    }

    public static java.lang.String getExtensionStringValue(Element element, java.lang.String extensionUrl) {
        java.lang.String value = null;
        if (Objects.nonNull(element) && Objects.nonNull(extensionUrl)) {
            value = FHIRUtil.getExtensionStringValue(extensionUrl, element.getExtension());
        }
        return value;
    }

    private static java.lang.String getExtensionStringValue(java.lang.String extensionUrl, List<Extension> extensions) {
        java.lang.String value = null;
        for (Extension ext : extensions) {
            if (ext.getValue() == null || !ext.getUrl().equals(extensionUrl) || !ext.getValue().is(String.class)) continue;
            value = ext.getValue().as(String.class).getValue();
            break;
        }
        return value;
    }

    public static boolean hasTag(Resource resource, Coding tag) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(tag);
        if (resource.getMeta() == null) {
            return false;
        }
        for (Coding t : resource.getMeta().getTag()) {
            if (tag.getSystem() == null || !tag.getSystem().equals(t.getSystem()) || tag.getCode() == null || !tag.getCode().equals(t.getCode())) continue;
            return true;
        }
        return false;
    }

    public static <T extends Resource> T addTag(T resource, Coding tag) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(tag);
        if (FHIRUtil.hasTag(resource, tag)) {
            return resource;
        }
        Meta meta = resource.getMeta();
        Meta.Builder metaBuilder = meta == null ? Meta.builder() : meta.toBuilder();
        Resource updatedResource = resource.toBuilder().meta(metaBuilder.tag(tag).build()).build();
        return (T)updatedResource;
    }

    @Deprecated
    public static java.lang.String getResourceTypeName(Resource resource) {
        return resource.getClass().getSimpleName();
    }

    @Deprecated
    public static List<java.lang.String> getResourceTypeNames() {
        return Arrays.stream(ResourceType.Value.values()).map(ResourceType.Value::value).collect(Collectors.toList());
    }

    public static boolean isFailure(IssueSeverity severity) {
        switch (severity.getValueAsEnum()) {
            case INFORMATION: 
            case WARNING: {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static java.lang.String getRandomKey(java.lang.String algorithm) {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
            keyGen.init(256);
            return Base64.getEncoder().encodeToString(keyGen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("Algorithm '" + algorithm + "' is not supported; using SecureRandom instead");
            byte[] buffer = new byte[32];
            RANDOM.nextBytes(buffer);
            return Base64.getEncoder().encodeToString(buffer);
        }
    }

    public static Bundle createStandaloneBundle(BundleType bundleType, Map<java.lang.String, Resource> resources) {
        HashMap<java.lang.String, java.lang.String> localRefMap = new HashMap<java.lang.String, java.lang.String>();
        ArrayList<Bundle.Entry> entries = new ArrayList<Bundle.Entry>();
        for (java.lang.String key : resources.keySet()) {
            Uuid uuid = Uuid.of("urn:uuid:" + UUID.randomUUID());
            localRefMap.put(key, uuid.getValue());
            entries.add(Bundle.Entry.builder().fullUrl(uuid).resource(resources.get(key)).build());
        }
        Bundle bundle = Bundle.builder().type(bundleType).entry(entries).build();
        ReferenceMappingVisitor referenceMappingVisitor = new ReferenceMappingVisitor(localRefMap);
        bundle.accept(referenceMappingVisitor);
        return (Bundle)referenceMappingVisitor.getResult();
    }
}

