/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import com.ibm.fhir.model.annotation.Binding;
import com.ibm.fhir.model.annotation.Choice;
import com.ibm.fhir.model.annotation.Constraint;
import com.ibm.fhir.model.annotation.ReferenceTarget;
import com.ibm.fhir.model.annotation.Required;
import com.ibm.fhir.model.annotation.Summary;
import com.ibm.fhir.model.annotation.System;
import com.ibm.fhir.model.constraint.spi.ConstraintProvider;
import com.ibm.fhir.model.constraint.spi.ModelConstraintProvider;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.Address;
import com.ibm.fhir.model.type.Age;
import com.ibm.fhir.model.type.Annotation;
import com.ibm.fhir.model.type.Attachment;
import com.ibm.fhir.model.type.BackboneElement;
import com.ibm.fhir.model.type.Base64Binary;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.ContactDetail;
import com.ibm.fhir.model.type.ContactPoint;
import com.ibm.fhir.model.type.Contributor;
import com.ibm.fhir.model.type.Count;
import com.ibm.fhir.model.type.DataRequirement;
import com.ibm.fhir.model.type.Date;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Distance;
import com.ibm.fhir.model.type.Dosage;
import com.ibm.fhir.model.type.Duration;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.ElementDefinition;
import com.ibm.fhir.model.type.Expression;
import com.ibm.fhir.model.type.Extension;
import com.ibm.fhir.model.type.HumanName;
import com.ibm.fhir.model.type.Id;
import com.ibm.fhir.model.type.Identifier;
import com.ibm.fhir.model.type.Instant;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.Markdown;
import com.ibm.fhir.model.type.MarketingStatus;
import com.ibm.fhir.model.type.Meta;
import com.ibm.fhir.model.type.Money;
import com.ibm.fhir.model.type.MoneyQuantity;
import com.ibm.fhir.model.type.Narrative;
import com.ibm.fhir.model.type.Oid;
import com.ibm.fhir.model.type.ParameterDefinition;
import com.ibm.fhir.model.type.Period;
import com.ibm.fhir.model.type.Population;
import com.ibm.fhir.model.type.PositiveInt;
import com.ibm.fhir.model.type.ProdCharacteristic;
import com.ibm.fhir.model.type.ProductShelfLife;
import com.ibm.fhir.model.type.Quantity;
import com.ibm.fhir.model.type.Range;
import com.ibm.fhir.model.type.Ratio;
import com.ibm.fhir.model.type.Reference;
import com.ibm.fhir.model.type.RelatedArtifact;
import com.ibm.fhir.model.type.SampledData;
import com.ibm.fhir.model.type.Signature;
import com.ibm.fhir.model.type.SimpleQuantity;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.SubstanceAmount;
import com.ibm.fhir.model.type.Time;
import com.ibm.fhir.model.type.Timing;
import com.ibm.fhir.model.type.TriggerDefinition;
import com.ibm.fhir.model.type.UnsignedInt;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.Url;
import com.ibm.fhir.model.type.UsageContext;
import com.ibm.fhir.model.type.Uuid;
import com.ibm.fhir.model.type.Xhtml;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ModelSupport {
    public static boolean DEBUG = false;
    public static final Class<Boolean> FHIR_BOOLEAN = Boolean.class;
    public static final Class<Integer> FHIR_INTEGER = Integer.class;
    public static final Class<String> FHIR_STRING = String.class;
    public static final Class<Date> FHIR_DATE = Date.class;
    public static final Class<Instant> FHIR_INSTANT = Instant.class;
    private static final Map<Class<?>, Class<?>> CONCRETE_TYPE_MAP = ModelSupport.buildConcreteTypeMap();
    private static final Map<Class<?>, Map<java.lang.String, ElementInfo>> MODEL_CLASS_ELEMENT_INFO_MAP = ModelSupport.buildModelClassElementInfoMap();
    private static final Map<java.lang.String, Class<? extends Resource>> RESOURCE_TYPE_MAP = ModelSupport.buildResourceTypeMap();
    private static final Set<Class<? extends Resource>> CONCRETE_RESOURCE_TYPES = ModelSupport.getResourceTypes().stream().filter(rt -> !ModelSupport.isAbstract(rt)).collect(Collectors.toSet());
    private static final Map<Class<?>, List<Constraint>> MODEL_CLASS_CONSTRAINT_MAP = ModelSupport.buildModelClassConstraintMap();
    private static final Set<Class<? extends Element>> CHOICE_ELEMENT_TYPES = new LinkedHashSet<Class>(Arrays.asList(Base64Binary.class, Boolean.class, Canonical.class, Code.class, Date.class, DateTime.class, Decimal.class, Id.class, Instant.class, Integer.class, Markdown.class, Oid.class, PositiveInt.class, String.class, Time.class, UnsignedInt.class, Uri.class, Url.class, Uuid.class, Address.class, Age.class, Annotation.class, Attachment.class, CodeableConcept.class, Coding.class, ContactPoint.class, Count.class, Distance.class, Duration.class, HumanName.class, Identifier.class, Money.class, MoneyQuantity.class, Period.class, Quantity.class, Range.class, Ratio.class, Reference.class, SampledData.class, SimpleQuantity.class, Signature.class, Timing.class, ContactDetail.class, Contributor.class, DataRequirement.class, Expression.class, ParameterDefinition.class, RelatedArtifact.class, TriggerDefinition.class, UsageContext.class, Dosage.class, Meta.class));
    private static final Set<Class<? extends Element>> DATA_TYPES;
    private static final Map<java.lang.String, Class<?>> DATA_TYPE_MAP;
    private static final Set<java.lang.String> KEYWORDS;

    private ModelSupport() {
    }

    public static void init() {
    }

    private static Map<java.lang.String, Class<?>> buildDataTypeMap() {
        LinkedHashMap<java.lang.String, Class<? extends Element>> dataTypeMap = new LinkedHashMap<java.lang.String, Class<? extends Element>>();
        for (Class<? extends Element> dataType : DATA_TYPES) {
            dataTypeMap.put(ModelSupport.getTypeName(dataType), dataType);
        }
        return Collections.unmodifiableMap(dataTypeMap);
    }

    private static Map<Class<?>, Class<?>> buildConcreteTypeMap() {
        LinkedHashMap<Class, Class<Quantity>> concreteTypeMap = new LinkedHashMap<Class, Class<Quantity>>();
        concreteTypeMap.put(SimpleQuantity.class, Quantity.class);
        concreteTypeMap.put(MoneyQuantity.class, Quantity.class);
        return Collections.unmodifiableMap(concreteTypeMap);
    }

    private static Map<Class<?>, List<Constraint>> buildModelClassConstraintMap() {
        LinkedHashMap modelClassConstraintMap = new LinkedHashMap(1024);
        List<ModelConstraintProvider> providers = ConstraintProvider.providers(ModelConstraintProvider.class);
        for (Class<?> modelClass : ModelSupport.getModelClasses()) {
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            for (Class<?> clazz : ModelSupport.getClosure(modelClass)) {
                for (Constraint constraint : (Constraint[])clazz.getDeclaredAnnotationsByType(Constraint.class)) {
                    constraints.add(Constraint.Factory.createConstraint(constraint.id(), constraint.level(), constraint.location(), constraint.description(), constraint.expression(), constraint.source(), constraint.modelChecked(), constraint.generated()));
                }
            }
            for (ModelConstraintProvider provider : providers) {
                if (!provider.appliesTo(modelClass)) continue;
                for (Predicate predicate : provider.getRemovalPredicates()) {
                    constraints.removeIf(predicate);
                }
                constraints.addAll(provider.getConstraints());
            }
            modelClassConstraintMap.put(modelClass, Collections.unmodifiableList(constraints));
        }
        return Collections.unmodifiableMap(modelClassConstraintMap);
    }

    private static Map<Class<?>, Map<java.lang.String, ElementInfo>> buildModelClassElementInfoMap() {
        Map map;
        block10: {
            InputStream in = ModelSupport.class.getClassLoader().getResourceAsStream("modelClasses");
            try {
                LinkedHashMap modelClassElementInfoMap = new LinkedHashMap(1024);
                List lines = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                for (java.lang.String className : lines) {
                    Class<?> modelClass = Class.forName(className);
                    LinkedHashMap<java.lang.String, ElementInfo> elementInfoMap = new LinkedHashMap<java.lang.String, ElementInfo>();
                    for (Field field : ModelSupport.getAllFields(modelClass)) {
                        java.lang.String elementName = ModelSupport.getElementName(field);
                        Class<?> type = ModelSupport.getFieldType(field);
                        Class<?> declaringType = field.getDeclaringClass();
                        boolean required = ModelSupport.isRequired(field);
                        boolean summary = ModelSupport.isSummary(field);
                        boolean repeating = ModelSupport.isRepeating(field);
                        boolean choice = ModelSupport.isChoice(field);
                        boolean reference = ModelSupport.isReference(field);
                        Binding binding = field.getAnnotation(Binding.class);
                        Set<Class<?>> choiceTypes = choice ? Collections.unmodifiableSet(ModelSupport.getChoiceTypes(field)) : Collections.emptySet();
                        Set<java.lang.String> referenceTypes = reference ? Collections.unmodifiableSet(ModelSupport.getReferenceTypes(field)) : Collections.emptySet();
                        elementInfoMap.put(elementName, new ElementInfo(elementName, type, declaringType, required, repeating, choice, choiceTypes, reference, referenceTypes, binding, summary));
                    }
                    modelClassElementInfoMap.put(modelClass, Collections.unmodifiableMap(elementInfoMap));
                }
                map = Collections.unmodifiableMap(modelClassElementInfoMap);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            in.close();
        }
        return map;
    }

    private static Map<java.lang.String, Class<? extends Resource>> buildResourceTypeMap() {
        LinkedHashMap resourceTypeMap = new LinkedHashMap(256);
        for (Class<?> modelClass : ModelSupport.getModelClasses()) {
            if (!ModelSupport.isResourceType(modelClass)) continue;
            resourceTypeMap.put(modelClass.getSimpleName(), modelClass);
        }
        return Collections.unmodifiableMap(resourceTypeMap);
    }

    private static List<Field> getAllFields(Class<?> modelClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz : ModelSupport.getClosure(modelClass)) {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isVolatile(modifiers)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static java.lang.String getChoiceElementName(java.lang.String name, Class<?> type) {
        return name + ModelSupport.getConcreteType(type).getSimpleName();
    }

    public static Set<Class<?>> getChoiceElementTypes(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getChoiceTypes();
        }
        return Collections.emptySet();
    }

    public static Set<java.lang.String> getReferenceTargetTypes(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getReferenceTypes();
        }
        return Collections.emptySet();
    }

    private static Set<Class<?>> getChoiceTypes(Field field) {
        return new LinkedHashSet(Arrays.asList(field.getAnnotation(Choice.class).value()));
    }

    private static Set<java.lang.String> getReferenceTypes(Field field) {
        return new LinkedHashSet<java.lang.String>(Arrays.asList(field.getAnnotation(ReferenceTarget.class).value()));
    }

    public static List<Class<?>> getClosure(Class<?> modelClass) {
        ArrayList closure = new ArrayList();
        while (!Object.class.equals(modelClass)) {
            closure.add(modelClass);
            modelClass = modelClass.getSuperclass();
        }
        Collections.reverse(closure);
        return closure;
    }

    public static Class<?> getConcreteType(Class<?> type) {
        if (ModelSupport.isProfiledType(type)) {
            return CONCRETE_TYPE_MAP.get(type);
        }
        return type;
    }

    public static List<Constraint> getConstraints(Class<?> modelClass) {
        return MODEL_CLASS_CONSTRAINT_MAP.getOrDefault(modelClass, Collections.emptyList());
    }

    public static ElementInfo getElementInfo(Class<?> modelClass, java.lang.String elementName) {
        return (ElementInfo)MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).get(elementName);
    }

    public static Collection<ElementInfo> getElementInfo(Class<?> modelClass) {
        return MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).values();
    }

    public static ElementInfo getChoiceElementInfo(Class<?> modelClass, java.lang.String typeSpecificElementName) {
        for (ElementInfo elementInfo : ModelSupport.getElementInfo(modelClass)) {
            if (!elementInfo.isChoice() || !elementInfo.getChoiceElementNames().contains(typeSpecificElementName)) continue;
            return elementInfo;
        }
        return null;
    }

    public static java.lang.String getElementName(Field field) {
        return ModelSupport.getElementName(field.getName());
    }

    public static java.lang.String getElementName(java.lang.String fieldName) {
        if ("clazz".equals(fieldName)) {
            return "class";
        }
        if (fieldName.startsWith("_")) {
            return fieldName.substring(1);
        }
        return fieldName;
    }

    public static Set<java.lang.String> getElementNames(Class<?> modelClass) {
        return MODEL_CLASS_ELEMENT_INFO_MAP.getOrDefault(modelClass, Collections.emptyMap()).keySet();
    }

    public static Class<?> getElementType(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getType();
        }
        return null;
    }

    public static Class<?> getElementDeclaringType(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.getDeclaringType();
        }
        return null;
    }

    public static boolean isElementDeclaredBy(Class<?> modelClass, java.lang.String elementName, Class<?> type) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isDeclaredBy(type);
        }
        return false;
    }

    private static Class<?> getFieldType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return field.getType();
    }

    public static Set<Class<?>> getModelClasses() {
        return MODEL_CLASS_ELEMENT_INFO_MAP.keySet();
    }

    public static Class<? extends Resource> getResourceType(java.lang.String name) {
        return RESOURCE_TYPE_MAP.get(name);
    }

    public static Collection<Class<? extends Resource>> getResourceTypes() {
        return RESOURCE_TYPE_MAP.values();
    }

    public static Collection<Class<? extends Resource>> getResourceTypes(boolean includeAbstractTypes) {
        if (includeAbstractTypes) {
            return RESOURCE_TYPE_MAP.values();
        }
        return CONCRETE_RESOURCE_TYPES;
    }

    public static Set<Class<? extends Element>> getDataTypes() {
        return DATA_TYPES;
    }

    public static java.lang.String getTypeName(Class<?> type) {
        java.lang.String typeName = type.getSimpleName();
        if (Code.class.isAssignableFrom(type)) {
            typeName = "code";
        } else if (ModelSupport.isPrimitiveType(type)) {
            typeName = typeName.substring(0, 1).toLowerCase() + typeName.substring(1);
        }
        return typeName;
    }

    public static Set<java.lang.String> getTypeNames(Class<?> modelClass) {
        HashSet<java.lang.String> typeNames = new HashSet<java.lang.String>();
        while (!Object.class.equals(modelClass)) {
            typeNames.add(ModelSupport.getTypeName(modelClass));
            modelClass = modelClass.getSuperclass();
        }
        return typeNames;
    }

    public static boolean isBackboneElementType(Class<?> modelClass) {
        return BackboneElement.class.isAssignableFrom(modelClass);
    }

    private static boolean isChoice(Field field) {
        return field.isAnnotationPresent(Choice.class);
    }

    private static boolean isReference(Field field) {
        return field.isAnnotationPresent(ReferenceTarget.class);
    }

    public static boolean isChoiceElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isChoice();
        }
        return false;
    }

    public static boolean isChoiceElementType(Class<?> type) {
        return CHOICE_ELEMENT_TYPES.contains(type);
    }

    public static boolean isCodeSubtype(Class<?> type) {
        return Code.class.isAssignableFrom(type) && !Code.class.equals(type);
    }

    public static boolean isElement(Object modelObject) {
        return modelObject instanceof Element;
    }

    public static boolean isElementType(Class<?> modelClass) {
        return Element.class.isAssignableFrom(modelClass);
    }

    public static boolean isMetadataType(Class<?> type) {
        return ContactDetail.class.equals(type) || Contributor.class.equals(type) || DataRequirement.class.isAssignableFrom(type) || RelatedArtifact.class.isAssignableFrom(type) || UsageContext.class.equals(type) || ParameterDefinition.class.equals(type) || Expression.class.equals(type) || TriggerDefinition.class.equals(type);
    }

    public static boolean isModelClass(Class<?> type) {
        return ModelSupport.isResourceType(type) || ModelSupport.isElementType(type);
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return Base64Binary.class.equals(type) || Boolean.class.equals(type) || String.class.isAssignableFrom(type) || Uri.class.isAssignableFrom(type) || DateTime.class.equals(type) || Date.class.equals(type) || Time.class.equals(type) || Instant.class.equals(type) || Integer.class.isAssignableFrom(type) || Decimal.class.equals(type) || Xhtml.class.equals(type);
    }

    public static boolean isProfiledType(Class<?> type) {
        return CONCRETE_TYPE_MAP.containsKey(type);
    }

    private static boolean isRepeating(Field field) {
        return List.class.equals(field.getType());
    }

    public static boolean isRepeatingElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isRepeating();
        }
        return false;
    }

    private static boolean isRequired(Field field) {
        return field.isAnnotationPresent(Required.class);
    }

    private static boolean isSummary(Field field) {
        return field.isAnnotationPresent(Summary.class);
    }

    public static boolean isRequiredElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isRequired();
        }
        return false;
    }

    public static boolean isResource(Object modelObject) {
        return modelObject instanceof Resource;
    }

    public static boolean isResourceType(Class<?> modelClass) {
        return Resource.class.isAssignableFrom(modelClass);
    }

    public static boolean isAbstract(Class<?> modelClass) {
        return Modifier.isAbstract(modelClass.getModifiers());
    }

    public static boolean isResourceType(java.lang.String name) {
        return RESOURCE_TYPE_MAP.containsKey(name);
    }

    public static boolean isConcreteResourceType(java.lang.String name) {
        Class<? extends Resource> modelClass = RESOURCE_TYPE_MAP.get(name);
        return modelClass != null && !ModelSupport.isAbstract(modelClass);
    }

    public static boolean isSummaryElement(Class<?> modelClass, java.lang.String elementName) {
        ElementInfo elementInfo = ModelSupport.getElementInfo(modelClass, elementName);
        if (elementInfo != null) {
            return elementInfo.isSummary();
        }
        return false;
    }

    public static ZonedDateTime truncateTime(ZonedDateTime dateTime, ChronoUnit unit) {
        return dateTime == null ? null : dateTime.truncatedTo(unit);
    }

    public static LocalTime truncateTime(LocalTime time, ChronoUnit unit) {
        return time == null ? null : time.truncatedTo(unit);
    }

    public static TemporalAccessor truncateTime(TemporalAccessor ta, ChronoUnit unit) {
        if (ta instanceof java.time.Instant) {
            ta = ((java.time.Instant)ta).truncatedTo(unit);
        } else if (ta instanceof ZonedDateTime) {
            ta = ((ZonedDateTime)ta).truncatedTo(unit);
        } else if (ta instanceof LocalDateTime) {
            ta = ((LocalDateTime)ta).truncatedTo(unit);
        } else if (ta instanceof LocalTime) {
            ta = ((LocalTime)ta).truncatedTo(unit);
        } else if (ta instanceof OffsetTime) {
            ta = ((OffsetTime)ta).truncatedTo(unit);
        } else if (ta instanceof OffsetDateTime) {
            ta = ((OffsetDateTime)ta).truncatedTo(unit);
        }
        return ta;
    }

    public static boolean isKeyword(java.lang.String identifier) {
        return KEYWORDS.contains(identifier);
    }

    public static java.lang.String delimit(java.lang.String identifier) {
        return java.lang.String.format("`%s`", identifier);
    }

    public static java.lang.String getSystem(Code code) {
        if (code != null && code.getClass().isAnnotationPresent(System.class)) {
            return code.getClass().getAnnotation(System.class).value();
        }
        return null;
    }

    public static Class<?> getDataType(java.lang.String typeName) {
        return DATA_TYPE_MAP.get(typeName);
    }

    static {
        LinkedHashSet<Class<? extends Element>> dataTypes = new LinkedHashSet<Class<? extends Element>>(CHOICE_ELEMENT_TYPES);
        dataTypes.add(Xhtml.class);
        dataTypes.add(Narrative.class);
        dataTypes.add(Extension.class);
        dataTypes.add(ElementDefinition.class);
        dataTypes.add(MarketingStatus.class);
        dataTypes.add(Population.class);
        dataTypes.add(ProductShelfLife.class);
        dataTypes.add(ProdCharacteristic.class);
        dataTypes.add(SubstanceAmount.class);
        DATA_TYPES = Collections.unmodifiableSet(dataTypes);
        DATA_TYPE_MAP = ModelSupport.buildDataTypeMap();
        KEYWORDS = new HashSet<java.lang.String>(Arrays.asList("$index", "$this", "$total", "and", "as", "contains", "day", "days", "div", "false", "hour", "hours", "implies", "in", "is", "millisecond", "milliseconds", "minute", "minutes", "mod", "month", "months", "or", "seconds", "true", "week", "weeks", "xor", "year", "years", "second"));
    }

    public static final class ElementInfo {
        private final java.lang.String name;
        private final Class<?> type;
        private final Class<?> declaringType;
        private final boolean required;
        private final boolean repeating;
        private final boolean choice;
        private final Set<Class<?>> choiceTypes;
        private final boolean reference;
        private final Set<java.lang.String> referenceTypes;
        private final Binding binding;
        private final boolean summary;
        private final Set<java.lang.String> choiceElementNames;

        ElementInfo(java.lang.String name, Class<?> type, Class<?> declaringType, boolean required, boolean repeating, boolean choice, Set<Class<?>> choiceTypes, boolean reference, Set<java.lang.String> referenceTypes, Binding binding, boolean isSummary) {
            this.name = name;
            this.declaringType = declaringType;
            this.type = type;
            this.required = required;
            this.repeating = repeating;
            this.choice = choice;
            this.choiceTypes = choiceTypes;
            this.reference = reference;
            this.referenceTypes = referenceTypes;
            this.binding = binding;
            this.summary = isSummary;
            LinkedHashSet<java.lang.String> choiceElementNames = new LinkedHashSet<java.lang.String>();
            if (this.choice) {
                for (Class<?> choiceType : this.choiceTypes) {
                    choiceElementNames.add(ModelSupport.getChoiceElementName(this.name, choiceType));
                }
            }
            this.choiceElementNames = Collections.unmodifiableSet(choiceElementNames);
        }

        public java.lang.String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Class<?> getDeclaringType() {
            return this.declaringType;
        }

        public boolean isDeclaredBy(Class<?> type) {
            return this.declaringType.equals(type);
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isSummary() {
            return this.summary;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public boolean isChoice() {
            return this.choice;
        }

        public Set<Class<?>> getChoiceTypes() {
            return this.choiceTypes;
        }

        public boolean isReference() {
            return this.reference;
        }

        public Set<java.lang.String> getReferenceTypes() {
            return this.referenceTypes;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public boolean hasBinding() {
            return this.binding != null;
        }

        public Set<java.lang.String> getChoiceElementNames() {
            return this.choiceElementNames;
        }
    }
}

