/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.model.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;

public final class XMLSupport {
    public static final String FHIR_NS_URI = "http://hl7.org/fhir";
    public static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";
    private static final String XML_INPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLInputFactoryImpl";
    private static final String XML_OUTPUT_FACTORY_IMPL = "com.sun.xml.internal.stream.XMLOutputFactoryImpl";
    private static final String TRANSFORMER_FACTORY_IMPL = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLSupport.createXMLInputFactory();
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLSupport.createXMLOutputFactory();
    private static final TransformerFactory TRANSFORMER_FACTORY = XMLSupport.createTransformerFactory();

    private XMLSupport() {
    }

    public static void init() {
    }

    public static int checkElementOrder(String elementName, int current, int previous, boolean repeating) {
        if (current > previous) {
            return current;
        }
        if (current == previous) {
            if (repeating) {
                return current;
            }
            throw new IllegalArgumentException("Element: '" + elementName + "' is not allowed to repeat");
        }
        throw new IllegalArgumentException("Element: '" + elementName + "' is out of order");
    }

    public static StreamReaderDelegate createStreamReaderDelegate(InputStream in) throws XMLStreamException {
        return new StreamReaderDelegate(XMLSupport.createXMLStreamReader(in));
    }

    public static StreamReaderDelegate createStreamReaderDelegate(Reader reader) throws XMLStreamException {
        return new StreamReaderDelegate(XMLSupport.createXMLStreamReader(reader));
    }

    public static StreamWriterDelegate createStreamWriterDelegate(OutputStream out) throws XMLStreamException {
        return XMLSupport.createStreamWriterDelegate(XMLSupport.createXMLStreamWriter(out));
    }

    public static StreamWriterDelegate createStreamWriterDelegate(Writer writer) throws XMLStreamException {
        return XMLSupport.createStreamWriterDelegate(XMLSupport.createXMLStreamWriter(writer));
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(in, "UTF-8");
    }

    public static XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(reader);
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(out, "UTF-8");
    }

    public static XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(writer);
    }

    public static boolean isResourceContainer(String elementName) {
        return "contained".equals(elementName) || "resource".equals(elementName) || "outcome".equals(elementName);
    }

    public static String parseDiv(XMLStreamReader reader) throws XMLStreamException {
        int depth = 0;
        StringWriter sw = new StringWriter();
        StreamWriterDelegate writer = XMLSupport.createStreamWriterDelegate(sw);
        XMLSupport.writeStartElement(reader, writer, depth);
        ++depth;
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    XMLSupport.requireNamespace(reader, XHTML_NS_URI);
                    XMLSupport.writeStartElement(reader, writer, depth);
                    ++depth;
                    break;
                }
                case 4: 
                case 6: {
                    writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (!"div".equals(reader.getLocalName()) || --depth != 0) break;
                    writer.flush();
                    writer.close();
                    return sw.toString();
                }
            }
        }
        throw new XMLStreamException("Unexpected end of stream");
    }

    public static void requireNamespace(XMLStreamReader reader, String namespaceURI) throws XMLStreamException {
        reader.require(1, namespaceURI, null);
    }

    private static StreamWriterDelegate createStreamWriterDelegate(XMLStreamWriter writer) {
        return new StreamWriterDelegate(writer){

            @Override
            public void writeEndDocument() {
            }

            @Override
            public void writeStartDocument() throws XMLStreamException {
            }

            @Override
            public void writeStartDocument(String version) throws XMLStreamException {
            }

            @Override
            public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            }
        };
    }

    public static StreamWriterDelegate createNonClosingStreamWriterDelegate(XMLStreamWriter writer) {
        return new StreamWriterDelegate(writer){

            @Override
            public void close() throws XMLStreamException {
            }
        };
    }

    private static XMLInputFactory createXMLInputFactory() {
        try {
            XMLInputFactory factory = (XMLInputFactory)Class.forName(XML_INPUT_FACTORY_IMPL).getConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            return factory;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static XMLOutputFactory createXMLOutputFactory() {
        try {
            return (XMLOutputFactory)Class.forName(XML_OUTPUT_FACTORY_IMPL).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static TransformerFactory createTransformerFactory() {
        try {
            TransformerFactory factory = (TransformerFactory)Class.forName(TRANSFORMER_FACTORY_IMPL).getConstructor(new Class[0]).newInstance(new Object[0]);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            return factory;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static Transformer createTransformer() {
        try {
            return TRANSFORMER_FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Error(e);
        }
    }

    private static void writeAttributes(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String prefix = reader.getAttributePrefix(i);
            String namespaceURI = reader.getAttributeNamespace(i);
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (namespaceURI != null) {
                if (prefix != null) {
                    writer.writeAttribute(prefix, namespaceURI, localName, value);
                    continue;
                }
                writer.writeAttribute(namespaceURI, localName, value);
                continue;
            }
            writer.writeAttribute(localName, value);
        }
    }

    private static void writeNamespaces(XMLStreamReader reader, XMLStreamWriter writer, int depth) throws XMLStreamException {
        if (depth == 0) {
            writer.writeDefaultNamespace(XHTML_NS_URI);
        }
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            if (XHTML_NS_URI.equals(reader.getNamespaceURI(i))) continue;
            writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
    }

    private static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer, int depth) throws XMLStreamException {
        String localName = reader.getLocalName();
        writer.setDefaultNamespace(XHTML_NS_URI);
        writer.writeStartElement(XHTML_NS_URI, localName);
        XMLSupport.writeNamespaces(reader, writer, depth);
        XMLSupport.writeAttributes(reader, writer);
    }

    public static class StreamWriterDelegate
    implements XMLStreamWriter,
    AutoCloseable {
        protected final XMLStreamWriter writer;

        public StreamWriterDelegate(XMLStreamWriter writer) {
            this.writer = writer;
        }

        public XMLStreamWriter getWriter() {
            return this.writer;
        }

        @Override
        public void close() throws XMLStreamException {
            this.writer.close();
        }

        @Override
        public void flush() throws XMLStreamException {
            this.writer.flush();
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.writer.getNamespaceContext();
        }

        @Override
        public String getPrefix(String uri) throws XMLStreamException {
            return this.writer.getPrefix(uri);
        }

        @Override
        public Object getProperty(String name) throws IllegalArgumentException {
            return this.writer.getProperty(name);
        }

        @Override
        public void setDefaultNamespace(String uri) throws XMLStreamException {
            this.writer.setDefaultNamespace(uri);
        }

        @Override
        public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
            this.writer.setNamespaceContext(context);
        }

        @Override
        public void setPrefix(String prefix, String uri) throws XMLStreamException {
            this.writer.setPrefix(prefix, uri);
        }

        @Override
        public void writeAttribute(String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(localName, value);
        }

        @Override
        public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(namespaceURI, localName, value);
        }

        @Override
        public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }

        @Override
        public void writeCData(String data) throws XMLStreamException {
            this.writer.writeCData(data);
        }

        @Override
        public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
            this.writer.writeCharacters(text, start, len);
        }

        @Override
        public void writeCharacters(String text) throws XMLStreamException {
            this.writer.writeCharacters(text);
        }

        @Override
        public void writeComment(String data) throws XMLStreamException {
            this.writer.writeComment(data);
        }

        @Override
        public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
            this.writer.writeDefaultNamespace(namespaceURI);
        }

        @Override
        public void writeDTD(String dtd) throws XMLStreamException {
            this.writer.writeDTD(dtd);
        }

        @Override
        public void writeEmptyElement(String localName) throws XMLStreamException {
            this.writer.writeEmptyElement(localName);
        }

        @Override
        public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
            this.writer.writeEmptyElement(namespaceURI, localName);
        }

        @Override
        public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        }

        @Override
        public void writeEndDocument() throws XMLStreamException {
            this.writer.writeEndDocument();
        }

        @Override
        public void writeEndElement() throws XMLStreamException {
            this.writer.writeEndElement();
        }

        @Override
        public void writeEntityRef(String name) throws XMLStreamException {
            this.writer.writeEntityRef(name);
        }

        @Override
        public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
            this.writer.writeNamespace(prefix, namespaceURI);
        }

        @Override
        public void writeProcessingInstruction(String target) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target);
        }

        @Override
        public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
            this.writer.writeProcessingInstruction(target, data);
        }

        @Override
        public void writeStartDocument() throws XMLStreamException {
            this.writer.writeStartDocument();
        }

        @Override
        public void writeStartDocument(String version) throws XMLStreamException {
            this.writer.writeStartDocument(version);
        }

        @Override
        public void writeStartDocument(String encoding, String version) throws XMLStreamException {
            this.writer.writeStartDocument(encoding, version);
        }

        @Override
        public void writeStartElement(String localName) throws XMLStreamException {
            this.writer.writeStartElement(localName);
        }

        @Override
        public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
            this.writer.writeStartElement(namespaceURI, localName);
        }

        @Override
        public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
    }

    public static class StreamReaderDelegate
    extends javax.xml.stream.util.StreamReaderDelegate
    implements AutoCloseable {
        public StreamReaderDelegate(XMLStreamReader reader) {
            super(reader);
        }
    }
}

