/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.operation.healthcheck;

import com.ibm.fhir.config.FHIRRequestContext;
import com.ibm.fhir.core.HTTPReturnPreference;
import com.ibm.fhir.exception.FHIROperationException;
import com.ibm.fhir.model.format.Format;
import com.ibm.fhir.model.parser.FHIRParser;
import com.ibm.fhir.model.resource.OperationDefinition;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.persistence.FHIRPersistence;
import com.ibm.fhir.persistence.FHIRPersistenceTransaction;
import com.ibm.fhir.search.util.SearchHelper;
import com.ibm.fhir.server.spi.operation.AbstractOperation;
import com.ibm.fhir.server.spi.operation.FHIROperationContext;
import com.ibm.fhir.server.spi.operation.FHIROperationUtil;
import com.ibm.fhir.server.spi.operation.FHIRResourceHelpers;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;

public class HealthcheckOperation
extends AbstractOperation {
    protected OperationDefinition buildOperationDefinition() {
        OperationDefinition operationDefinition;
        block8: {
            InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("healthcheck.json");
            try {
                operationDefinition = (OperationDefinition)FHIRParser.parser((Format)Format.JSON).parse(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
            in.close();
        }
        return operationDefinition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Parameters doInvoke(FHIROperationContext operationContext, Class<? extends Resource> resourceType, String logicalId, String versionId, Parameters parameters, FHIRResourceHelpers resourceHelper, SearchHelper searchHelper) throws FHIROperationException {
        try {
            FHIRPersistence pl = (FHIRPersistence)operationContext.getProperty("PERSISTENCE_IMPL");
            FHIRPersistenceTransaction tx = resourceHelper.getTransaction();
            tx.begin();
            try {
                OperationOutcome operationOutcome = pl.getHealth();
                this.checkOperationOutcome(operationOutcome);
                if (FHIRRequestContext.get().getReturnPreference() == HTTPReturnPreference.OPERATION_OUTCOME) {
                    Parameters parameters2 = FHIROperationUtil.getOutputParameters((Resource)operationOutcome);
                    return parameters2;
                }
                Parameters parameters3 = null;
                return parameters3;
            }
            catch (Throwable t) {
                tx.setRollbackOnly();
                throw t;
            }
            finally {
                tx.end();
            }
        }
        catch (FHIROperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new FHIROperationException("Unexpected error occurred while processing request for operation '" + this.getName() + "': " + this.getCausedByMessage(t), t);
        }
    }

    private void checkOperationOutcome(OperationOutcome oo) throws FHIROperationException {
        List issues = oo.getIssue();
        for (OperationOutcome.Issue issue : issues) {
            IssueSeverity severity = issue.getSeverity();
            if (severity == null || !IssueSeverity.ERROR.getValue().equals(severity.getValue()) && !IssueSeverity.FATAL.getValue().equals(severity.getValue())) continue;
            throw new FHIROperationException("The persistence layer reported one or more issues").withIssue((Collection)issues);
        }
    }

    private String getCausedByMessage(Throwable throwable) {
        return throwable.getClass().getName() + ": " + throwable.getMessage();
    }
}

