/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry.resource;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import java.util.Objects;
import java.util.logging.Logger;

public class FHIRRegistryResource
implements Comparable<FHIRRegistryResource> {
    private static final Logger log = Logger.getLogger(FHIRRegistryResource.class.getName());
    protected final Class<? extends Resource> resourceType;
    protected final String id;
    protected final String url;
    protected final Version version;
    protected final String kind;
    protected final String type;
    protected final boolean defaultVersion;
    protected volatile Resource resource;

    public FHIRRegistryResource(Class<? extends Resource> resourceType, String id, String url, Version version, String kind, String type, boolean defaultVersion) {
        this.resourceType = Objects.requireNonNull(resourceType);
        this.id = id;
        this.url = Objects.requireNonNull(url);
        this.version = Objects.requireNonNull(version);
        this.kind = kind;
        this.type = type;
        this.defaultVersion = defaultVersion;
    }

    public FHIRRegistryResource(Class<? extends Resource> resourceType, String id, String url, Version version, String kind, String type) {
        this(resourceType, id, url, version, kind, type, false);
    }

    public FHIRRegistryResource(Class<? extends Resource> resourceType, String id, String url, Version version, String kind, String type, Resource resource, boolean defaultVersion) {
        this(resourceType, id, url, version, kind, type, defaultVersion);
        this.resource = resource;
    }

    public FHIRRegistryResource(Class<? extends Resource> resourceType, String id, String url, Version version, String kind, String type, Resource resource) {
        this(resourceType, id, url, version, kind, type, false);
    }

    public Class<? extends Resource> getResourceType() {
        return this.resourceType;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDefaultVersion() {
        return this.defaultVersion;
    }

    public Resource getResource() {
        return this.resource;
    }

    public <T extends FHIRRegistryResource> boolean is(Class<T> registryResourceType) {
        return registryResourceType.isInstance(this);
    }

    public <T extends FHIRRegistryResource> T as(Class<T> registryResourceType) {
        return (T)((FHIRRegistryResource)registryResourceType.cast(this));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FHIRRegistryResource other = (FHIRRegistryResource)obj;
        return Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.version);
    }

    @Override
    public int compareTo(FHIRRegistryResource other) {
        int result = this.url.compareTo(other.url);
        if (result == 0) {
            return this.version.compareTo(other.version);
        }
        return result;
    }

    public static FHIRRegistryResource from(Resource resource) {
        return FHIRRegistryResource.from(resource, false);
    }

    public static FHIRRegistryResource from(Resource resource, boolean defaultVersion) {
        if (resource == null) {
            return null;
        }
        Class<?> resourceType = resource.getClass();
        FHIRRegistryUtil.requireDefinitionalResourceType(resourceType);
        String id = resource.getId();
        String url = FHIRRegistryUtil.getUrl(resource);
        String version = FHIRRegistryUtil.getVersion(resource);
        if (url == null) {
            log.warning(String.format("Could not create FHIRRegistryResource from Resource with resourceType: %s, id: %s, url: %s, and version: %s", resourceType.getSimpleName(), id, url, version));
            return null;
        }
        String kind = null;
        String type = null;
        if (resource instanceof StructureDefinition) {
            StructureDefinition structureDefinition = (StructureDefinition)resource;
            kind = structureDefinition.getKind().getValue();
            type = structureDefinition.getType().getValue();
        } else if (resource instanceof SearchParameter) {
            SearchParameter searchParameter = (SearchParameter)resource;
            type = searchParameter.getType().getValue();
        }
        return new FHIRRegistryResource(resourceType, id, url, version != null ? Version.from(version) : Version.NO_VERSION, kind, type, resource, defaultVersion);
    }

    public static class Version
    implements Comparable<Version> {
        public static final Version NO_VERSION = Version.from("<no version>");
        private final String version;
        private final Integer major;
        private final Integer minor;
        private final Integer patch;
        private final CompareMode mode;

        private Version(String version) {
            this.version = version;
            this.patch = null;
            this.minor = null;
            this.major = null;
            this.mode = CompareMode.LEXICAL;
        }

        private Version(String version, Integer major, Integer minor, Integer patch) {
            this.version = version;
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.mode = CompareMode.SEMVER;
        }

        public int major() {
            return this.major;
        }

        public int minor() {
            return this.minor;
        }

        public int patch() {
            return this.patch;
        }

        public static Version from(String version) {
            String[] tokens = version.split("\\.");
            if (tokens.length < 1 || tokens.length > 3) {
                return new Version(version);
            }
            try {
                Integer major = Integer.parseInt(tokens[0]);
                Integer minor = tokens.length >= 2 ? Integer.parseInt(tokens[1]) : 0;
                Integer patch = tokens.length == 3 ? Integer.parseInt(tokens[2]) : 0;
                return new Version(version, major, minor, patch);
            }
            catch (Exception e) {
                return new Version(version);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Version other = (Version)obj;
            if (CompareMode.LEXICAL.equals((Object)this.mode) || CompareMode.LEXICAL.equals((Object)other.mode)) {
                return Objects.equals(this.version, other.version);
            }
            return Objects.equals(this.major, other.major) && Objects.equals(this.minor, other.minor) && Objects.equals(this.patch, other.patch);
        }

        public int hashCode() {
            if (CompareMode.LEXICAL.equals((Object)this.mode)) {
                return Objects.hash(this.version);
            }
            return Objects.hash(this.major, this.minor, this.patch);
        }

        public String toString() {
            return this.version;
        }

        @Override
        public int compareTo(Version version) {
            if (CompareMode.LEXICAL.equals((Object)this.mode) || CompareMode.LEXICAL.equals((Object)version.mode)) {
                return this.version.compareTo(version.version);
            }
            int result = this.major.compareTo(version.major);
            if (result == 0) {
                result = this.minor.compareTo(version.minor);
                if (result == 0) {
                    return this.patch.compareTo(version.patch);
                }
                return result;
            }
            return result;
        }

        public static enum CompareMode {
            SEMVER,
            LEXICAL;

        }
    }
}

