/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry;

import com.ibm.fhir.model.resource.DomainResource;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.code.SearchParamType;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.registry.resource.FHIRRegistryResource;
import com.ibm.fhir.registry.spi.FHIRRegistryResourceProvider;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public final class FHIRRegistry {
    private static final Logger log = Logger.getLogger(FHIRRegistry.class.getName());
    private static final FHIRRegistry INSTANCE = new FHIRRegistry();
    private final List<FHIRRegistryResourceProvider> providers = new CopyOnWriteArrayList<FHIRRegistryResourceProvider>(this.loadProviders());

    private FHIRRegistry() {
    }

    public void addProvider(FHIRRegistryResourceProvider provider) {
        Objects.requireNonNull(provider);
        this.providers.add(provider);
    }

    public String getLatestVersion(String url, Class<? extends Resource> resourceType) {
        FHIRRegistryResource resource;
        if (url == null || resourceType == null || !FHIRRegistryUtil.isDefinitionalResourceType(resourceType)) {
            return null;
        }
        int index = url.indexOf("|");
        if (index != -1) {
            url = url.substring(0, index);
        }
        return (resource = this.findRegistryResource(resourceType, url, null)) != null ? resource.getVersion().toString() : null;
    }

    public Map<String, Set<Canonical>> getProfiles() {
        HashMap<String, Set<Canonical>> map = new HashMap<String, Set<Canonical>>();
        for (FHIRRegistryResourceProvider provider : this.providers) {
            for (FHIRRegistryResource r : provider.getProfileResources()) {
                map.computeIfAbsent(r.getType(), k -> new LinkedHashSet()).add(Canonical.of((String)r.getUrl(), (String)r.getVersion().toString()));
            }
        }
        return map;
    }

    public Collection<Canonical> getProfiles(String type) {
        Objects.requireNonNull(type);
        if (!ModelSupport.isResourceType((String)type)) {
            throw new IllegalArgumentException("The type argument must be a valid FHIR resource type name");
        }
        ArrayList<FHIRRegistryResource> registryResources = new ArrayList<FHIRRegistryResource>();
        for (FHIRRegistryResourceProvider provider : this.providers) {
            registryResources.addAll(provider.getProfileResources(type));
        }
        Collections.sort(registryResources);
        ArrayList<Canonical> profiles = new ArrayList<Canonical>();
        for (FHIRRegistryResource registryResource : registryResources) {
            profiles.add(Canonical.of((String)registryResource.getUrl(), (String)registryResource.getVersion().toString()));
        }
        return Collections.unmodifiableList(profiles);
    }

    public <T extends Resource> T getResource(String url, Class<T> resourceType) {
        Objects.requireNonNull(url);
        Objects.requireNonNull(resourceType);
        FHIRRegistryUtil.requireDefinitionalResourceType(resourceType);
        String id = null;
        int index = url.indexOf("#");
        if (index != -1) {
            id = url.substring(index + 1);
            url = url.substring(0, index);
        }
        String version = null;
        index = url.indexOf("|");
        if (index != -1) {
            version = url.substring(index + 1);
            url = url.substring(0, index);
        }
        return (T)((Resource)resourceType.cast(this.getResource(this.findRegistryResource(resourceType, url, version), url, id)));
    }

    public <T extends Resource> Collection<T> getResources(Class<T> resourceType) {
        Objects.requireNonNull(resourceType);
        FHIRRegistryUtil.requireDefinitionalResourceType(resourceType);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (FHIRRegistryResourceProvider provider : this.providers) {
            for (FHIRRegistryResource registryResource : provider.getRegistryResources(resourceType)) {
                resources.add((Resource)resourceType.cast(registryResource.getResource()));
            }
        }
        return Collections.unmodifiableList(resources);
    }

    public Collection<SearchParameter> getSearchParameters(String type) {
        Objects.requireNonNull(type);
        SearchParamType.ValueSet.from((String)type);
        ArrayList<SearchParameter> searchParameters = new ArrayList<SearchParameter>();
        for (FHIRRegistryResourceProvider provider : this.providers) {
            for (FHIRRegistryResource registryResource : provider.getSearchParameterResources(type)) {
                searchParameters.add((SearchParameter)registryResource.getResource().as(SearchParameter.class));
            }
        }
        return Collections.unmodifiableList(searchParameters);
    }

    public boolean hasResource(String url, Class<? extends Resource> resourceType) {
        if (url == null || resourceType == null || !FHIRRegistryUtil.isDefinitionalResourceType(resourceType)) {
            return false;
        }
        String id = null;
        int index = url.indexOf("#");
        if (index != -1) {
            id = url.substring(index + 1);
            url = url.substring(0, index);
        }
        String version = null;
        index = url.indexOf("|");
        if (index != -1) {
            version = url.substring(index + 1);
            url = url.substring(0, index);
        }
        FHIRRegistryResource registryResource = this.findRegistryResource(resourceType, url, version);
        return id != null ? this.getResource(registryResource, url, id) != null : registryResource != null;
    }

    private FHIRRegistryResource findRegistryResource(Class<? extends Resource> resourceType, String url, String version) {
        if (version == null) {
            HashSet<FHIRRegistryResource> distinct = new HashSet<FHIRRegistryResource>();
            for (FHIRRegistryResourceProvider provider : this.providers) {
                FHIRRegistryResource registryResource = provider.getRegistryResource(resourceType, url, version);
                if (registryResource == null) continue;
                distinct.add(registryResource);
            }
            ArrayList registryResources = new ArrayList(distinct);
            Collections.sort(registryResources);
            return !registryResources.isEmpty() ? (FHIRRegistryResource)registryResources.get(registryResources.size() - 1) : null;
        }
        for (FHIRRegistryResourceProvider provider : this.providers) {
            FHIRRegistryResource registryResource = provider.getRegistryResource(resourceType, url, version);
            if (registryResource == null) continue;
            return registryResource;
        }
        return null;
    }

    private Resource getResource(FHIRRegistryResource registryResource, String url, String id) {
        if (registryResource == null) {
            return null;
        }
        Resource resource = registryResource.getResource();
        if (resource != null && id != null) {
            if (resource.is(DomainResource.class)) {
                for (Resource contained : ((DomainResource)resource.as(DomainResource.class)).getContained()) {
                    if (!id.equals(contained.getId())) continue;
                    return contained;
                }
                log.warning("Unable to find contained resource with id: " + id + " in resource: " + url);
            } else {
                log.warning("Resource: " + url + " is not a DomainResource");
            }
            return null;
        }
        return resource;
    }

    private List<FHIRRegistryResourceProvider> loadProviders() {
        ArrayList<FHIRRegistryResourceProvider> providers = new ArrayList<FHIRRegistryResourceProvider>();
        for (FHIRRegistryResourceProvider provider : ServiceLoader.load(FHIRRegistryResourceProvider.class)) {
            providers.add(provider);
        }
        return providers;
    }

    public static FHIRRegistry getInstance() {
        return INSTANCE;
    }
}

