/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry.core.util;

import com.ibm.fhir.model.format.Format;
import com.ibm.fhir.model.parser.FHIRParser;
import com.ibm.fhir.model.resource.Bundle;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import com.ibm.fhir.registry.util.Index;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;

public class IndexGenerator {
    private static final List<String> DEFINITIONS = Arrays.asList("definitions/conceptmaps.json", "definitions/dataelements.json", "definitions/extension-definitions.json", "definitions/profiles-others.json", "definitions/profiles-resources.json", "definitions/profiles-types.json", "definitions/search-parameters.json", "definitions/v2-tables.json", "definitions/v3-codesystems.json", "definitions/valuesets.json");

    public static void main(String[] args) throws Exception {
        Index index = new Index(1);
        for (String definition : DEFINITIONS) {
            try (FileReader reader = new FileReader(definition);){
                Bundle bundle = (Bundle)FHIRParser.parser((Format)Format.JSON).parse((Reader)reader);
                for (Bundle.Entry entry : bundle.getEntry()) {
                    String id;
                    Resource resource = entry.getResource();
                    if (!FHIRRegistryUtil.isDefinitionalResource(resource) || (id = resource.getId()) == null) continue;
                    String url = FHIRRegistryUtil.getUrl(resource);
                    String version = FHIRRegistryUtil.getVersion(resource);
                    if (url == null || version == null) continue;
                    String fileName = resource.getClass().getSimpleName() + "-" + id + ".json";
                    File file = new File("src/main/resources/hl7/fhir/core/package/" + fileName);
                    if (!file.exists()) {
                        file.getParentFile().mkdirs();
                    }
                    try (FileWriter writer = new FileWriter(file);){
                        writer.write(resource.toString());
                    }
                    index.add(Index.Entry.entry(resource));
                }
            }
        }
        try (FileOutputStream out = new FileOutputStream("src/main/resources/hl7/fhir/core/package/.index.json");){
            index.store(out);
        }
    }
}

