/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry.util;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;

public class Index {
    private static final Logger log = Logger.getLogger(Index.class.getName());
    private static final JsonProvider PROVIDER = JsonProvider.provider();
    private static final JsonParserFactory PARSER_FACTORY = PROVIDER.createParserFactory(null);
    private static final JsonGeneratorFactory GENERATOR_FACTORY = PROVIDER.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
    private int version = -1;
    private final List<Entry> entries = new ArrayList<Entry>();

    public Index() {
    }

    public Index(int version) {
        if (version < 1) {
            throw new IllegalArgumentException("index version must be a positive integer");
        }
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void load(InputStream in) {
        this.load(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
    }

    public void load(Reader reader) {
        JsonParser parser = PARSER_FACTORY.createParser(reader);
        String keyName = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case KEY_NAME: {
                    keyName = parser.getString();
                    break;
                }
                case VALUE_NUMBER: {
                    if ("index-version".equals(keyName)) {
                        this.version = parser.getInt();
                    }
                }
                case START_ARRAY: {
                    if (!"files".equals(keyName)) break;
                    this.parseFiles(parser);
                    break;
                }
            }
        }
        parser.close();
        if (this.version < 1) {
            throw new IllegalStateException("index version was not set");
        }
    }

    private void parseFiles(JsonParser parser) {
        int i = 0;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: {
                    try {
                        this.parseFile(parser);
                    }
                    catch (NullPointerException e) {
                        log.log(Level.WARNING, "Skipping index entry " + i + " due to one or more missing required fields, beginning with: " + e.getMessage());
                    }
                    ++i;
                    break;
                }
                case END_ARRAY: {
                    return;
                }
            }
        }
    }

    private void parseFile(JsonParser parser) {
        String fileName = null;
        String resourceType = null;
        String id = null;
        String url = null;
        String version = null;
        String kind = null;
        String type = null;
        String keyName = null;
        while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            block0 : switch (event) {
                case KEY_NAME: {
                    keyName = parser.getString();
                    break;
                }
                case VALUE_STRING: {
                    switch (keyName) {
                        case "filename": {
                            fileName = parser.getString();
                            break block0;
                        }
                        case "resourceType": {
                            resourceType = parser.getString();
                            break block0;
                        }
                        case "id": {
                            id = parser.getString();
                            break block0;
                        }
                        case "url": {
                            url = parser.getString();
                            break block0;
                        }
                        case "version": {
                            version = parser.getString();
                            break block0;
                        }
                        case "kind": {
                            kind = parser.getString();
                            break block0;
                        }
                        case "type": {
                            type = parser.getString();
                        }
                    }
                    break;
                }
                case END_OBJECT: {
                    this.entries.add(new Entry(fileName, resourceType, id, url, version, kind, type));
                    return;
                }
            }
        }
    }

    public void store(OutputStream out) {
        this.store(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public void store(Writer writer) {
        if (this.version < 1) {
            throw new IllegalStateException("index version was not set");
        }
        if (this.entries.isEmpty()) {
            throw new IllegalStateException("index contains no entries");
        }
        Collections.sort(this.entries);
        JsonGenerator generator = GENERATOR_FACTORY.createGenerator(writer);
        generator.writeStartObject();
        generator.write("index-version", this.version);
        generator.writeStartArray("files");
        for (Entry entry : this.entries) {
            this.write(generator, entry);
        }
        generator.writeEnd();
        generator.writeEnd();
        generator.flush();
        generator.close();
    }

    private void write(JsonGenerator generator, Entry entry) {
        generator.writeStartObject();
        generator.write("filename", entry.getFileName());
        generator.write("resourceType", entry.getResourceType());
        generator.write("id", entry.getId());
        generator.write("url", entry.getUrl());
        generator.write("version", entry.getVersion());
        if (entry.getKind() != null) {
            generator.write("kind", entry.getKind());
        }
        if (entry.getType() != null) {
            generator.write("type", entry.getType());
        }
        generator.writeEnd();
    }

    public boolean add(Entry entry) {
        if (entry == null) {
            return false;
        }
        return this.entries.add(entry);
    }

    public static class Entry
    implements Comparable<Entry> {
        private final String fileName;
        private final String resourceType;
        private final String id;
        private final String url;
        private final String version;
        private final String kind;
        private final String type;

        private Entry(String fileName, String resourceType, String id, String url, String version, String kind, String type) {
            this.fileName = Objects.requireNonNull(fileName, "fileName");
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
            this.id = Objects.requireNonNull(id, "id");
            this.url = Objects.requireNonNull(url, "url");
            this.version = version;
            this.kind = kind;
            this.type = type;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getKind() {
            return this.kind;
        }

        public String getType() {
            return this.type;
        }

        public static Entry entry(Resource resource) {
            Objects.requireNonNull(resource);
            if (!FHIRRegistryUtil.isDefinitionalResource(resource)) {
                return null;
            }
            String id = resource.getId();
            if (id == null) {
                return null;
            }
            String url = FHIRRegistryUtil.getUrl(resource);
            String version = FHIRRegistryUtil.getVersion(resource);
            if (url == null) {
                return null;
            }
            int idx = url.indexOf("|");
            if (idx != -1) {
                version = url.substring(idx + 1);
                url = url.substring(0, idx);
            }
            String resourceType = resource.getClass().getSimpleName();
            String fileName = resourceType + "-" + id + ".json";
            String kind = null;
            String type = null;
            if (resource instanceof StructureDefinition) {
                StructureDefinition structureDefinition = (StructureDefinition)resource;
                kind = structureDefinition.getKind().getValue();
                type = structureDefinition.getType().getValue();
            } else if (resource instanceof SearchParameter) {
                SearchParameter searchParameter = (SearchParameter)resource;
                type = searchParameter.getType().getValue();
            }
            return new Entry(fileName, resourceType, id, url, version, kind, type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.fileName, other.fileName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.id, other.id) && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version) && Objects.equals(this.kind, other.kind) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            return Objects.hash(this.fileName, this.resourceType, this.id, this.url, this.version, this.kind, this.type);
        }

        @Override
        public int compareTo(Entry other) {
            return this.fileName.compareTo(other.fileName);
        }
    }
}

