/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry.util;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.registry.resource.FHIRRegistryResource;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import java.util.Objects;

public class PackageRegistryResource
extends FHIRRegistryResource {
    protected final String path;

    public PackageRegistryResource(Class<? extends Resource> resourceType, String id, String url, FHIRRegistryResource.Version version, String kind, String type, String path) {
        super(resourceType, id, url, version, kind, type);
        this.path = Objects.requireNonNull(path);
    }

    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResource() {
        Resource resource = this.resource;
        if (resource == null) {
            PackageRegistryResource packageRegistryResource = this;
            synchronized (packageRegistryResource) {
                resource = this.resource;
                if (resource == null) {
                    this.resource = resource = FHIRRegistryUtil.loadResource(this.path);
                }
            }
        }
        return resource;
    }
}

