/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.registry.util;

import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.SearchParameter;
import com.ibm.fhir.model.resource.StructureDefinition;
import com.ibm.fhir.model.type.code.ResourceType;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.registry.resource.FHIRRegistryResource;
import com.ibm.fhir.registry.spi.AbstractRegistryResourceProvider;
import com.ibm.fhir.registry.util.FHIRRegistryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class PackageRegistryResourceProvider
extends AbstractRegistryResourceProvider {
    private static final String HL7_STRUCTURE_DEFINITION_URL_PREFIX = "http://hl7.org/fhir/StructureDefinition/";
    protected final Collection<FHIRRegistryResource> registryResources = FHIRRegistryUtil.getRegistryResources(this.getPackageId());
    protected final Map<Class<? extends Resource>, Map<String, List<FHIRRegistryResource>>> registryResourceMap = this.buildRegistryResourceMap();
    protected final Map<String, List<FHIRRegistryResource>> profileResourceMap = this.buildProfileResourceMap();

    public abstract String getPackageId();

    @Override
    protected List<FHIRRegistryResource> getRegistryResources(Class<? extends Resource> resourceType, String url) {
        return this.registryResourceMap.getOrDefault(resourceType, Collections.emptyMap()).getOrDefault(url, Collections.emptyList());
    }

    @Override
    public Collection<FHIRRegistryResource> getRegistryResources(Class<? extends Resource> resourceType) {
        return this.registryResourceMap.getOrDefault(resourceType, Collections.emptyMap()).entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public Collection<FHIRRegistryResource> getRegistryResources() {
        return Collections.unmodifiableCollection(this.registryResources);
    }

    @Override
    public Collection<FHIRRegistryResource> getProfileResources() {
        ArrayList<FHIRRegistryResource> profilesForAll = new ArrayList<FHIRRegistryResource>();
        for (ResourceType.Value type : ResourceType.Value.values()) {
            profilesForAll.addAll(this.getProfileResources(type.value()));
        }
        return Collections.unmodifiableList(profilesForAll);
    }

    @Override
    public Collection<FHIRRegistryResource> getProfileResources(String type) {
        Objects.requireNonNull(type);
        return Collections.unmodifiableList(this.profileResourceMap.getOrDefault(type, Collections.emptyList()));
    }

    @Override
    public Collection<FHIRRegistryResource> getSearchParameterResources(String type) {
        Objects.requireNonNull(type);
        return this.registryResourceMap.getOrDefault(SearchParameter.class, Collections.emptyMap()).entrySet().stream().map(entry -> (List)entry.getValue()).flatMap(Collection::stream).filter(registryResource -> type.equals(registryResource.getType())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private Map<Class<? extends Resource>, Map<String, List<FHIRRegistryResource>>> buildRegistryResourceMap() {
        HashMap<Class<? extends Resource>, Map<String, List<FHIRRegistryResource>>> registryResourceMap = new HashMap<Class<? extends Resource>, Map<String, List<FHIRRegistryResource>>>();
        for (FHIRRegistryResource registryResource : this.registryResources) {
            Map map = registryResourceMap.computeIfAbsent(registryResource.getResourceType(), k -> new HashMap());
            List list = map.computeIfAbsent(registryResource.getUrl(), k -> new ArrayList());
            list.add(registryResource);
            Collections.sort(list);
        }
        return registryResourceMap;
    }

    private Map<String, List<FHIRRegistryResource>> buildProfileResourceMap() {
        HashMap<String, List<FHIRRegistryResource>> profileResourceMap = new HashMap<String, List<FHIRRegistryResource>>();
        for (FHIRRegistryResource registryResource : this.getRegistryResources(StructureDefinition.class)) {
            if (!this.isProfileResource(registryResource)) continue;
            profileResourceMap.computeIfAbsent(registryResource.getType(), k -> new ArrayList()).add(registryResource);
        }
        return profileResourceMap;
    }

    private boolean isProfileResource(FHIRRegistryResource registryResource) {
        String name;
        if (!"resource".equals(registryResource.getKind()) || registryResource.getType() == null) {
            return false;
        }
        String url = registryResource.getUrl();
        return !url.startsWith(HL7_STRUCTURE_DEFINITION_URL_PREFIX) || !ModelSupport.isResourceType((String)(name = url.substring(HL7_STRUCTURE_DEFINITION_URL_PREFIX.length())));
    }
}

