/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.String;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LookupOutcome {
    private final String name;
    private final String version;
    private final String display;
    private final List<Designation> designation;
    private final List<Property> property;

    private LookupOutcome(Builder builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.version = builder.version;
        this.display = Objects.requireNonNull(builder.display);
        this.designation = Collections.unmodifiableList(builder.designation);
        this.property = Collections.unmodifiableList(builder.property);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDisplay() {
        return this.display;
    }

    public List<Designation> getDesignation() {
        return this.designation;
    }

    public List<Property> getProperty() {
        return this.property;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LookupOutcome other = (LookupOutcome)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.display, other.display) && Objects.equals(this.designation, other.designation) && Objects.equals(this.property, other.property);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.display, this.designation, this.property);
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Parameters toParameters() {
        Parameters.Builder parametersBuilder = Parameters.builder();
        parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"name")).value((Element)this.name).build()});
        if (this.version != null) {
            parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"version")).value((Element)this.version).build()});
        }
        parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"display")).value((Element)this.display).build()});
        for (Designation designation : this.designation) {
            Parameters.Parameter.Builder designationParameterBuilder = Parameters.Parameter.builder();
            designationParameterBuilder.name(String.string((java.lang.String)"designation"));
            if (designation.language != null) {
                designationParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"language")).value((Element)designation.language).build()});
            }
            if (designation.use != null) {
                designationParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"use")).value((Element)designation.use).build()});
            }
            designationParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"value")).value((Element)designation.value).build()});
            parametersBuilder.parameter(new Parameters.Parameter[]{designationParameterBuilder.build()});
        }
        for (Property property : this.property) {
            Parameters.Parameter.Builder propertyParameterBuilder = Parameters.Parameter.builder();
            propertyParameterBuilder.name(String.string((java.lang.String)"property"));
            propertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"code")).value((Element)property.code).build()});
            propertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"value")).value(property.value).build()});
            if (property.description != null) {
                propertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"description")).value((Element)property.description).build()});
            }
            for (Property subproperty : property.subproperty) {
                Parameters.Parameter.Builder subpropertyParameterBuilder = Parameters.Parameter.builder();
                subpropertyParameterBuilder.name(String.string((java.lang.String)"subproperty"));
                subpropertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"code")).value((Element)subproperty.code).build()});
                subpropertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"value")).value(subproperty.value).build()});
                if (subproperty.description != null) {
                    subpropertyParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"description")).value((Element)subproperty.description).build()});
                }
                propertyParameterBuilder.part(new Parameters.Parameter[]{subpropertyParameterBuilder.build()});
            }
            parametersBuilder.parameter(new Parameters.Parameter[]{propertyParameterBuilder.build()});
        }
        return parametersBuilder.build();
    }

    public static class Property {
        private final Code code;
        private final Element value;
        private final String description;
        private final List<Property> subproperty;

        public Property(Builder builder) {
            this.code = Objects.requireNonNull(builder.code);
            this.value = Objects.requireNonNull(builder.value);
            this.description = builder.description;
            this.subproperty = Collections.unmodifiableList(builder.subproperty);
        }

        public Code getCode() {
            return this.code;
        }

        public Element getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }

        public List<Property> getSubproperty() {
            return this.subproperty;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            return Objects.equals(this.code, other.code) && Objects.equals(this.value, other.value) && Objects.equals(this.description, other.description) && Objects.equals(this.subproperty, other.subproperty);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.value, this.description, this.subproperty);
        }

        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Code code;
            private Element value;
            private String description;
            private List<Property> subproperty = new ArrayList<Property>();

            private Builder() {
            }

            public Builder code(Code code) {
                this.code = code;
                return this;
            }

            public Builder value(Element value) {
                this.value = value;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder subproperty(Property ... subproperty) {
                for (Property value : subproperty) {
                    this.subproperty.add(value);
                }
                return this;
            }

            public Builder subproperty(Collection<Property> subproperty) {
                this.subproperty = new ArrayList<Property>(subproperty);
                return this;
            }

            public Property build() {
                return new Property(this);
            }

            protected Builder from(Property property) {
                this.code = property.code;
                this.value = property.value;
                this.description = property.description;
                this.subproperty.addAll(property.subproperty);
                return this;
            }
        }
    }

    public static class Designation {
        private final Code language;
        private final Coding use;
        private final String value;

        public Designation(Builder builder) {
            this.language = builder.language;
            this.use = builder.use;
            this.value = Objects.requireNonNull(builder.value);
        }

        public Code getLanguage() {
            return this.language;
        }

        public Coding getUse() {
            return this.use;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Designation other = (Designation)obj;
            return Objects.equals(this.language, other.language) && Objects.equals(this.use, other.use) && Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.language, this.use, this.value);
        }

        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Code language;
            private Coding use;
            private String value;

            private Builder() {
            }

            public Builder language(Code language) {
                this.language = language;
                return this;
            }

            public Builder use(Coding use) {
                this.use = use;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Designation build() {
                return new Designation(this);
            }

            public Builder from(Designation designation) {
                this.language = designation.language;
                this.use = designation.use;
                this.value = designation.value;
                return this;
            }
        }
    }

    public static class Builder {
        private String name;
        private String version;
        private String display;
        private List<Designation> designation = new ArrayList<Designation>();
        private List<Property> property = new ArrayList<Property>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder display(String display) {
            this.display = display;
            return this;
        }

        public Builder designation(Designation ... designation) {
            for (Designation value : designation) {
                this.designation.add(value);
            }
            return this;
        }

        public Builder designation(Collection<Designation> designation) {
            this.designation = new ArrayList<Designation>(designation);
            return this;
        }

        public Builder property(Property ... property) {
            for (Property value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Property> property) {
            this.property = new ArrayList<Property>(property);
            return this;
        }

        public LookupOutcome build() {
            return new LookupOutcome(this);
        }

        public Builder from(LookupOutcome lookupOutcome) {
            this.name = lookupOutcome.name;
            this.version = lookupOutcome.version;
            this.display = lookupOutcome.display;
            this.designation.addAll(lookupOutcome.designation);
            this.property.addAll(lookupOutcome.property);
            return this;
        }
    }
}

