/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.ConceptMapEquivalence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TranslationOutcome {
    private final Boolean result;
    private final String message;
    private final List<Match> match;

    private TranslationOutcome(Builder builder) {
        this.result = Objects.requireNonNull(builder.result);
        this.message = builder.message;
        this.match = Collections.unmodifiableList(builder.match);
    }

    public Boolean getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Match> getMatch() {
        return this.match;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranslationOutcome other = (TranslationOutcome)obj;
        return Objects.equals(this.result, other.result) && Objects.equals(this.message, other.message) && Objects.equals(this.match, other.match);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.message, this.match);
    }

    public Parameters toParameters() {
        Parameters.Builder parametersBuilder = Parameters.builder();
        parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"result")).value((Element)this.result).build()});
        if (this.message != null) {
            parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"message")).value((Element)this.message).build()});
        }
        for (Match match : this.match) {
            Parameters.Parameter.Builder matchParameterBuilder = Parameters.Parameter.builder();
            matchParameterBuilder.name(String.string((java.lang.String)"match"));
            if (match.equivalence != null) {
                matchParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"equivalence")).value((Element)match.equivalence).build()});
            }
            if (match.concept != null) {
                matchParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"concept")).value((Element)match.concept).build()});
            }
            for (Match.Product product : match.product) {
                Parameters.Parameter.Builder productParameterBuilder = Parameters.Parameter.builder();
                productParameterBuilder.name(String.string((java.lang.String)"product"));
                if (product.element != null) {
                    productParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"element")).value((Element)product.element).build()});
                }
                if (product.concept != null) {
                    productParameterBuilder.part(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"concept")).value((Element)product.concept).build()});
                }
                matchParameterBuilder.part(new Parameters.Parameter[]{productParameterBuilder.build()});
            }
            parametersBuilder.parameter(new Parameters.Parameter[]{matchParameterBuilder.build()});
        }
        return parametersBuilder.build();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Match {
        private final ConceptMapEquivalence equivalence;
        private final Coding concept;
        private final List<Product> product;
        private final Uri source;

        private Match(Builder builder) {
            this.equivalence = builder.equivalence;
            this.concept = builder.concept;
            this.product = Collections.unmodifiableList(builder.product);
            this.source = builder.source;
        }

        public ConceptMapEquivalence getEquivalence() {
            return this.equivalence;
        }

        public Coding getConcept() {
            return this.concept;
        }

        public List<Product> getProduct() {
            return this.product;
        }

        public Uri getSource() {
            return this.source;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Match other = (Match)obj;
            return Objects.equals(this.equivalence, other.equivalence) && Objects.equals(this.concept, other.concept) && Objects.equals(this.product, other.product) && Objects.equals(this.source, this.source);
        }

        public int hashCode() {
            return Objects.hash(this.equivalence, this.concept, this.product, this.source);
        }

        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Product {
            private final Uri element;
            private final Coding concept;

            private Product(Builder builder) {
                this.element = builder.element;
                this.concept = builder.concept;
            }

            public Uri getElement() {
                return this.element;
            }

            public Coding getConcept() {
                return this.concept;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Product other = (Product)obj;
                return Objects.equals(this.element, other.element) && Objects.equals(this.concept, other.concept);
            }

            public int hashCode() {
                return Objects.hash(this.element, this.concept);
            }

            public Builder toBuilder() {
                return new Builder().from(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder {
                private Uri element;
                private Coding concept;

                private Builder() {
                }

                public Builder element(Uri element) {
                    this.element = element;
                    return this;
                }

                public Builder concept(Coding concept) {
                    this.concept = concept;
                    return this;
                }

                public Product build() {
                    return new Product(this);
                }

                protected Builder from(Product product) {
                    this.element = product.element;
                    this.concept = product.concept;
                    return this;
                }
            }
        }

        public static class Builder {
            private ConceptMapEquivalence equivalence;
            private Coding concept;
            private List<Product> product = new ArrayList<Product>();
            private Uri source;

            private Builder() {
            }

            public Builder equivalence(ConceptMapEquivalence equivalence) {
                this.equivalence = equivalence;
                return this;
            }

            public Builder concept(Coding concept) {
                this.concept = concept;
                return this;
            }

            public Builder product(Product ... product) {
                for (Product value : product) {
                    this.product.add(value);
                }
                return this;
            }

            public Builder product(Collection<Product> product) {
                this.product = new ArrayList<Product>(product);
                return this;
            }

            public Builder source(Uri source) {
                this.source = source;
                return this;
            }

            public Match build() {
                return new Match(this);
            }

            protected Builder from(Match match) {
                this.equivalence = match.equivalence;
                this.concept = match.concept;
                this.product.addAll(match.product);
                this.source = match.source;
                return this;
            }
        }
    }

    public static class Builder {
        private Boolean result;
        private String message;
        private List<Match> match = new ArrayList<Match>();

        private Builder() {
        }

        public Builder result(Boolean result) {
            this.result = result;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder match(Match ... match) {
            for (Match value : match) {
                this.match.add(value);
            }
            return this;
        }

        public Builder match(Collection<Match> match) {
            this.match = new ArrayList<Match>(match);
            return this;
        }

        public TranslationOutcome build() {
            return new TranslationOutcome(this);
        }

        protected Builder from(TranslationOutcome translationOutcome) {
            this.result = translationOutcome.result;
            this.message = translationOutcome.message;
            this.match.addAll(translationOutcome.match);
            return this;
        }
    }
}

