/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.String;
import java.util.Objects;

public class ValidationOutcome {
    private final Boolean result;
    private final String message;
    private final String display;

    private ValidationOutcome(Builder builder) {
        this.result = Objects.requireNonNull(builder.result);
        this.message = builder.message;
        this.display = builder.display;
    }

    public Boolean getResult() {
        return this.result;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationOutcome other = (ValidationOutcome)obj;
        return Objects.equals(this.result, other.result) && Objects.equals(this.message, other.message) && Objects.equals(this.display, other.display);
    }

    public int hashCode() {
        return Objects.hash(this.result, this.message, this.display);
    }

    public Parameters toParameters() {
        Parameters.Builder parametersBuilder = Parameters.builder();
        parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"result")).value((Element)this.result).build()});
        if (this.message != null) {
            parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"message")).value((Element)this.message).build()});
        }
        if (this.display != null) {
            parametersBuilder.parameter(new Parameters.Parameter[]{Parameters.Parameter.builder().name(String.string((java.lang.String)"display")).value((Element)this.display).build()});
        }
        return parametersBuilder.build();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public java.lang.String toString() {
        return "ValidationOutcome [display=" + this.display + ", message=" + this.message + ", result=" + this.result + "]";
    }

    public static class Builder {
        private Boolean result;
        private String message;
        private String display;

        private Builder() {
        }

        public Builder result(Boolean result) {
            this.result = result;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder display(String display) {
            this.display = display;
            return this;
        }

        public ValidationOutcome build() {
            return new ValidationOutcome(this);
        }

        protected Builder from(ValidationOutcome validationOutcome) {
            this.result = validationOutcome.result;
            this.message = validationOutcome.message;
            this.display = validationOutcome.display;
            return this;
        }
    }
}

