/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.util;

import com.ibm.fhir.cache.CacheKey;
import com.ibm.fhir.cache.CacheManager;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.OperationOutcome;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Decimal;
import com.ibm.fhir.model.type.Element;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.code.CodeSystemHierarchyMeaning;
import com.ibm.fhir.model.type.code.FilterOperator;
import com.ibm.fhir.model.type.code.IssueSeverity;
import com.ibm.fhir.model.type.code.IssueType;
import com.ibm.fhir.model.type.code.PropertyType;
import com.ibm.fhir.model.util.ModelSupport;
import com.ibm.fhir.registry.FHIRRegistry;
import com.ibm.fhir.term.config.FHIRTermConfig;
import com.ibm.fhir.term.exception.FHIRTermException;
import com.ibm.fhir.term.service.FHIRTermService;
import java.text.Normalizer;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class CodeSystemSupport {
    private static final Logger LOG = Logger.getLogger(CodeSystemSupport.class.getName());
    public static final java.lang.String ANCESTORS_AND_SELF_CACHE_NAME = "com.ibm.fhir.term.util.CodeSystemSupport.ancestorsAndSelfCache";
    public static final java.lang.String DESCENDANTS_AND_SELF_CACHE_NAME = "com.ibm.fhir.term.util.CodeSystemSupport.descendantsAndSelfCache";
    public static final CacheManager.Configuration ANCESTORS_AND_SELF_CACHE_CONFIG = CacheManager.Configuration.of((int)128);
    public static final CacheManager.Configuration DESCENDANTS_AND_SELF_CACHE_CONFIG = CacheManager.Configuration.of((int)128);
    public static final Function<CodeSystem.Concept, java.lang.String> CODE_VALUE_FUNCTION = new Function<CodeSystem.Concept, java.lang.String>(){

        @Override
        public java.lang.String apply(CodeSystem.Concept concept) {
            return concept.getCode().getValue();
        }
    };
    public static final Function<CodeSystem.Concept, java.lang.String> NORMALIZED_CODE_VALUE_FUNCTION = new Function<CodeSystem.Concept, java.lang.String>(){

        @Override
        public java.lang.String apply(CodeSystem.Concept concept) {
            return CodeSystemSupport.normalize(concept.getCode().getValue());
        }
    };
    public static final Function<CodeSystem.Concept, java.lang.String> DISPLAY_VALUE_FUNCTION = new Function<CodeSystem.Concept, java.lang.String>(){

        @Override
        public java.lang.String apply(CodeSystem.Concept concept) {
            return concept.getDisplay().getValue();
        }
    };
    public static final Function<CodeSystem.Concept, java.lang.String> NORMALIZED_DISPLAY_VALUE_FUNCTION = new Function<CodeSystem.Concept, java.lang.String>(){

        @Override
        public java.lang.String apply(CodeSystem.Concept concept) {
            return CodeSystemSupport.normalize(concept.getCode().getValue());
        }
    };
    public static final Function<CodeSystem.Concept, CodeSystem.Concept> CONCEPT_NO_CHILDREN_FUNCTION = new Function<CodeSystem.Concept, CodeSystem.Concept>(){

        @Override
        public CodeSystem.Concept apply(CodeSystem.Concept concept) {
            return concept.toBuilder().concept(Collections.emptyList()).build();
        }
    };
    public static final Function<CodeSystem.Concept, CodeSystem.Concept> SIMPLE_CONCEPT_FUNCTION = new Function<CodeSystem.Concept, CodeSystem.Concept>(){

        @Override
        public CodeSystem.Concept apply(CodeSystem.Concept concept) {
            return CodeSystem.Concept.builder().code(concept.getCode()).display(concept.getDisplay()).build();
        }
    };
    private static final Pattern IN_COMBINING_DIACRITICAL_MARKS_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    private CodeSystemSupport() {
    }

    public static boolean convertsToBoolean(String value) {
        return "true".equals(value.getValue()) || "false".equals(value.getValue());
    }

    public static CodeSystem.Concept findConcept(CodeSystem codeSystem, Code code) {
        CodeSystem.Concept concept;
        CodeSystem.Concept result = null;
        Iterator iterator = codeSystem.getConcept().iterator();
        while (iterator.hasNext() && (result = CodeSystemSupport.findConcept(codeSystem, concept = (CodeSystem.Concept)iterator.next(), code)) == null) {
        }
        return result;
    }

    public static CodeSystem.Concept findConcept(CodeSystem codeSystem, CodeSystem.Concept concept, Code code) {
        CodeSystem.Concept child;
        if (concept.getCode().equals((Object)code) || !CodeSystemSupport.isCaseSensitive(codeSystem) && CodeSystemSupport.normalize(concept.getCode().getValue()).equals(CodeSystemSupport.normalize(code.getValue()))) {
            return concept;
        }
        CodeSystem.Concept result = null;
        Iterator iterator = concept.getConcept().iterator();
        while (iterator.hasNext() && (result = CodeSystemSupport.findConcept(codeSystem, child = (CodeSystem.Concept)iterator.next(), code)) == null) {
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<java.lang.String> getAncestorsAndSelf(CodeSystem codeSystem, Code code) {
        if (FHIRTermConfig.isCachingDisabled()) {
            return CodeSystemSupport.computeAncestorsAndSelf(codeSystem, code);
        }
        CacheKey key = CacheKey.key((Object[])new Object[]{codeSystem, code});
        Map cacheAsMap = CacheManager.getCacheAsMap((java.lang.String)ANCESTORS_AND_SELF_CACHE_NAME, (CacheManager.Configuration)ANCESTORS_AND_SELF_CACHE_CONFIG);
        CacheManager.reportCacheStats((Logger)LOG, (java.lang.String)ANCESTORS_AND_SELF_CACHE_NAME);
        try {
            Set set = cacheAsMap.computeIfAbsent(key, k -> CodeSystemSupport.computeAncestorsAndSelf(codeSystem, code));
            return set;
        }
        finally {
            CacheManager.reportCacheStats((Logger)LOG, (java.lang.String)ANCESTORS_AND_SELF_CACHE_NAME);
        }
    }

    public static CodeSystem getCodeSystem(java.lang.String url) {
        return (CodeSystem)FHIRRegistry.getInstance().getResource(url, CodeSystem.class);
    }

    public static CodeSystem.Filter getCodeSystemFilter(CodeSystem codeSystem, Code code, FilterOperator operator) {
        for (CodeSystem.Filter filter : codeSystem.getFilter()) {
            if (!filter.getCode().equals((Object)code) || !filter.getOperator().contains(operator)) continue;
            return filter;
        }
        return null;
    }

    public static CodeSystem.Property getCodeSystemProperty(CodeSystem codeSystem, Code code) {
        for (CodeSystem.Property property : codeSystem.getProperty()) {
            if (!property.getCode().equals((Object)code)) continue;
            return property;
        }
        return null;
    }

    public static PropertyType getCodeSystemPropertyType(CodeSystem codeSystem, Code code) {
        CodeSystem.Property property = CodeSystemSupport.getCodeSystemProperty(codeSystem, code);
        if (property != null) {
            return property.getType();
        }
        return null;
    }

    public static Function<CodeSystem.Concept, java.lang.String> getCodeValueFunction(CodeSystem codeSystem) {
        return CodeSystemSupport.isCaseSensitive(codeSystem) ? CODE_VALUE_FUNCTION : NORMALIZED_CODE_VALUE_FUNCTION;
    }

    public static CodeSystem.Concept.Property getConceptProperty(CodeSystem.Concept concept, Code code) {
        for (CodeSystem.Concept.Property property : concept.getProperty()) {
            if (!property.getCode().equals((Object)code)) continue;
            return property;
        }
        return null;
    }

    public static Element getConceptPropertyValue(CodeSystem.Concept concept, Code code) {
        CodeSystem.Concept.Property property = CodeSystemSupport.getConceptProperty(concept, code);
        return property != null ? property.getValue() : null;
    }

    public static Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem) {
        return CodeSystemSupport.getConcepts(codeSystem, Function.identity());
    }

    public static <R> Set<R> getConcepts(CodeSystem codeSystem, Function<CodeSystem.Concept, ? extends R> function) {
        LinkedHashSet<? extends R> result = codeSystem.getCount() != null ? new LinkedHashSet<R>(codeSystem.getCount().getValue()) : new LinkedHashSet();
        for (CodeSystem.Concept concept : codeSystem.getConcept()) {
            result.addAll(CodeSystemSupport.getConcepts(concept, function));
        }
        return result;
    }

    public static Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
        return CodeSystemSupport.getConcepts(codeSystem, filters, Function.identity());
    }

    public static <R> Set<R> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters, Function<CodeSystem.Concept, ? extends R> function) {
        LinkedHashSet<R> result = new LinkedHashSet<R>();
        List<ConceptFilter> conceptFilters = CodeSystemSupport.buildConceptFilters(codeSystem, filters);
        for (CodeSystem.Concept concept : CodeSystemSupport.getConcepts(codeSystem)) {
            if (!CodeSystemSupport.accept(conceptFilters, concept)) continue;
            result.add(function.apply(concept));
        }
        return result;
    }

    public static Set<CodeSystem.Concept> getConcepts(CodeSystem.Concept concept) {
        return CodeSystemSupport.getConcepts(concept, Function.identity());
    }

    public static <R> Set<R> getConcepts(CodeSystem.Concept concept, Function<CodeSystem.Concept, ? extends R> function) {
        if (concept == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        result.add(function.apply(concept));
        for (CodeSystem.Concept c : concept.getConcept()) {
            result.addAll(CodeSystemSupport.getConcepts(c, function));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<java.lang.String> getDescendantsAndSelf(CodeSystem codeSystem, Code code) {
        if (FHIRTermConfig.isCachingDisabled()) {
            return CodeSystemSupport.computeDescendantsAndSelf(codeSystem, code);
        }
        CacheKey key = CacheKey.key((Object[])new Object[]{codeSystem, code});
        Map cacheAsMap = CacheManager.getCacheAsMap((java.lang.String)DESCENDANTS_AND_SELF_CACHE_NAME, (CacheManager.Configuration)DESCENDANTS_AND_SELF_CACHE_CONFIG);
        CacheManager.reportCacheStats((Logger)LOG, (java.lang.String)DESCENDANTS_AND_SELF_CACHE_NAME);
        try {
            Set set = cacheAsMap.computeIfAbsent(key, k -> CodeSystemSupport.computeDescendantsAndSelf(codeSystem, code));
            return set;
        }
        finally {
            CacheManager.reportCacheStats((Logger)LOG, (java.lang.String)DESCENDANTS_AND_SELF_CACHE_NAME);
        }
    }

    public static boolean hasCodeSystemFilter(CodeSystem codeSystem, Code code, FilterOperator operator) {
        return CodeSystemSupport.getCodeSystemFilter(codeSystem, code, operator) != null;
    }

    public static boolean hasCodeSystemProperty(CodeSystem codeSystem, Code code) {
        return CodeSystemSupport.getCodeSystemProperty(codeSystem, code) != null;
    }

    public static boolean hasConceptProperty(CodeSystem.Concept concept, Code code) {
        return CodeSystemSupport.getConceptProperty(concept, code) != null;
    }

    public static boolean isCaseSensitive(CodeSystem codeSystem) {
        if (codeSystem != null && codeSystem.getCaseSensitive() != null) {
            return java.lang.Boolean.TRUE.equals(codeSystem.getCaseSensitive().getValue());
        }
        return false;
    }

    public static boolean isCaseSensitive(java.lang.String url) {
        return CodeSystemSupport.isCaseSensitive(CodeSystemSupport.getCodeSystem(url));
    }

    public static java.lang.String normalize(java.lang.String value) {
        if (value != null) {
            return IN_COMBINING_DIACRITICAL_MARKS_PATTERN.matcher(Normalizer.normalize(value, Normalizer.Form.NFD)).replaceAll("").toLowerCase();
        }
        return null;
    }

    public static Boolean toBoolean(String value) {
        return "true".equals(value.getValue()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Element toElement(java.lang.String value, PropertyType type) {
        switch (type.getValueAsEnum()) {
            case BOOLEAN: {
                return Boolean.of((java.lang.String)value);
            }
            case CODE: {
                return Code.of((java.lang.String)value);
            }
            case DATE_TIME: {
                return DateTime.of((java.lang.String)value);
            }
            case DECIMAL: {
                return Decimal.of((java.lang.String)value);
            }
            case INTEGER: {
                return Integer.of((java.lang.String)value);
            }
            case STRING: {
                return String.string((java.lang.String)value);
            }
        }
        return null;
    }

    public static Element toElement(String value, PropertyType type) {
        switch (type.getValueAsEnum()) {
            case BOOLEAN: {
                return Boolean.of((java.lang.String)value.getValue());
            }
            case CODE: {
                return Code.of((java.lang.String)value.getValue());
            }
            case DATE_TIME: {
                return DateTime.of((java.lang.String)value.getValue());
            }
            case DECIMAL: {
                return Decimal.of((java.lang.String)value.getValue());
            }
            case INTEGER: {
                return Integer.of((java.lang.String)value.getValue());
            }
            case STRING: {
                return value;
            }
        }
        return null;
    }

    public static Long toLong(DateTime dateTime) {
        TemporalAccessor value = dateTime.getValue();
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return zonedDateTime.toInstant().toEpochMilli();
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return localDate.atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        if (value instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)value;
            return yearMonth.atDay(1).atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        if (value instanceof Year) {
            Year year = (Year)value;
            return year.atMonth(1).atDay(1).atStartOfDay().atZone(ZoneOffset.UTC).toInstant().toEpochMilli();
        }
        throw new IllegalArgumentException();
    }

    public static Object toObject(Element value) {
        if (value.is(ModelSupport.FHIR_BOOLEAN)) {
            return ((Boolean)value.as(ModelSupport.FHIR_BOOLEAN)).getValue();
        }
        if (value.is(Code.class)) {
            return ((Code)value.as(Code.class)).getValue();
        }
        if (value.is(DateTime.class)) {
            return DateTime.PARSER_FORMATTER.format(((DateTime)value.as(DateTime.class)).getValue());
        }
        if (value.is(Decimal.class)) {
            return ((Decimal)value.as(Decimal.class)).getValue().doubleValue();
        }
        if (value.is(ModelSupport.FHIR_INTEGER)) {
            return ((Integer)value.as(ModelSupport.FHIR_INTEGER)).getValue();
        }
        if (value.is(ModelSupport.FHIR_STRING)) {
            return ((String)value.as(ModelSupport.FHIR_STRING)).getValue();
        }
        throw new IllegalArgumentException();
    }

    private static boolean accept(List<ConceptFilter> conceptFilters, CodeSystem.Concept concept) {
        for (ConceptFilter conceptFilter : conceptFilters) {
            if (conceptFilter.accept(concept)) continue;
            return false;
        }
        return true;
    }

    private static List<ConceptFilter> buildConceptFilters(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
        ArrayList<ConceptFilter> conceptFilters = new ArrayList<ConceptFilter>(filters.size());
        for (ValueSet.Compose.Include.Filter filter : filters) {
            ConceptFilter conceptFilter = null;
            switch (filter.getOp().getValueAsEnum()) {
                case DESCENDENT_OF: {
                    conceptFilter = CodeSystemSupport.createDescendentOfFilter(codeSystem, filter);
                    break;
                }
                case EQUALS: {
                    conceptFilter = CodeSystemSupport.createEqualsFilter(codeSystem, filter);
                    break;
                }
                case EXISTS: {
                    conceptFilter = CodeSystemSupport.createExistsFilter(codeSystem, filter);
                    break;
                }
                case GENERALIZES: {
                    conceptFilter = CodeSystemSupport.createGeneralizesFilter(codeSystem, filter);
                    break;
                }
                case IN: {
                    conceptFilter = CodeSystemSupport.createInFilter(codeSystem, filter);
                    break;
                }
                case IS_A: {
                    conceptFilter = CodeSystemSupport.createIsAFilter(codeSystem, filter);
                    break;
                }
                case IS_NOT_A: {
                    conceptFilter = CodeSystemSupport.createIsNotAFilter(codeSystem, filter);
                    break;
                }
                case NOT_IN: {
                    conceptFilter = CodeSystemSupport.createNotInFilter(codeSystem, filter);
                    break;
                }
                case REGEX: {
                    conceptFilter = CodeSystemSupport.createRegexFilter(codeSystem, filter);
                }
            }
            conceptFilters.add(conceptFilter);
        }
        return conceptFilters;
    }

    private static FHIRTermException conceptFilterNotCreated(Class<? extends ConceptFilter> conceptFilterType, ValueSet.Compose.Include.Filter filter) {
        java.lang.String message = java.lang.String.format("%s not created (property: %s, op: %s, value: %s)", conceptFilterType.getSimpleName(), filter.getProperty().getValue(), filter.getOp().getValue(), filter.getValue().getValue());
        throw new FHIRTermException(message, Collections.singletonList(OperationOutcome.Issue.builder().severity(IssueSeverity.ERROR).code(IssueType.NOT_SUPPORTED).details(CodeableConcept.builder().text(String.string((java.lang.String)message)).build()).build()));
    }

    private static Code code(String value) {
        return Code.of((java.lang.String)value.getValue());
    }

    private static Set<java.lang.String> computeAncestorsAndSelf(CodeSystem codeSystem, Code code) {
        return FHIRTermService.getInstance().getConcepts(codeSystem, Collections.singletonList(ValueSet.Compose.Include.Filter.builder().property(Code.of((java.lang.String)"concept")).op(FilterOperator.GENERALIZES).value((String)code).build()), CodeSystemSupport.getCodeValueFunction(codeSystem));
    }

    private static Set<java.lang.String> computeDescendantsAndSelf(CodeSystem codeSystem, Code code) {
        return FHIRTermService.getInstance().getConcepts(codeSystem, Collections.singletonList(ValueSet.Compose.Include.Filter.builder().property(Code.of((java.lang.String)"concept")).op(FilterOperator.IS_A).value((String)code).build()), CodeSystemSupport.getCodeValueFunction(codeSystem));
    }

    private static ConceptFilter createDescendentOfFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        CodeSystem.Concept concept;
        if ("concept".equals(filter.getProperty().getValue()) && CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) && (concept = CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(filter.getValue()))) != null) {
            return new DescendentOfFilter(codeSystem, concept);
        }
        throw CodeSystemSupport.conceptFilterNotCreated(DescendentOfFilter.class, filter);
    }

    private static ConceptFilter createEqualsFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        Code property = filter.getProperty();
        if (("parent".equals(property.getValue()) || "child".equals(property.getValue())) && CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) || CodeSystemSupport.hasCodeSystemProperty(codeSystem, property) && !PropertyType.CODING.equals((Object)CodeSystemSupport.getCodeSystemPropertyType(codeSystem, property))) {
            return new EqualsFilter(codeSystem, property, filter.getValue());
        }
        throw CodeSystemSupport.conceptFilterNotCreated(EqualsFilter.class, filter);
    }

    private static ConceptFilter createExistsFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        Code property = filter.getProperty();
        String value = filter.getValue();
        if (CodeSystemSupport.hasCodeSystemProperty(codeSystem, property) && CodeSystemSupport.convertsToBoolean(value)) {
            return new ExistsFilter(property, CodeSystemSupport.toBoolean(value));
        }
        throw CodeSystemSupport.conceptFilterNotCreated(ExistsFilter.class, filter);
    }

    private static ConceptFilter createGeneralizesFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        CodeSystem.Concept concept;
        if ("concept".equals(filter.getProperty().getValue()) && (CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) || codeSystem.getHierarchyMeaning() == null) && (concept = CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(filter.getValue()))) != null) {
            return new GeneralizesFilter(codeSystem, concept);
        }
        throw CodeSystemSupport.conceptFilterNotCreated(GeneralizesFilter.class, filter);
    }

    private static ConceptFilter createInFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        Code property = filter.getProperty();
        if ("concept".equals(property.getValue()) || CodeSystemSupport.hasCodeSystemProperty(codeSystem, property)) {
            if ("concept".equals(property.getValue())) {
                return CodeSystemSupport.isCaseSensitive(codeSystem) ? new InFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().collect(Collectors.toSet())) : new InFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().map(CodeSystemSupport::normalize).collect(Collectors.toSet()));
            }
            PropertyType type = CodeSystemSupport.getCodeSystemPropertyType(codeSystem, property);
            return new InFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().map(s -> CodeSystemSupport.toElement(s, type)).map(e -> e.is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)e.as(DateTime.class)) : CodeSystemSupport.toObject(e)).collect(Collectors.toSet()));
        }
        throw CodeSystemSupport.conceptFilterNotCreated(InFilter.class, filter);
    }

    private static ConceptFilter createIsAFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        CodeSystem.Concept concept;
        if ("concept".equals(filter.getProperty().getValue()) && (CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) || codeSystem.getHierarchyMeaning() == null) && (concept = CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(filter.getValue()))) != null) {
            return new IsAFilter(codeSystem, concept);
        }
        throw CodeSystemSupport.conceptFilterNotCreated(IsAFilter.class, filter);
    }

    private static ConceptFilter createIsNotAFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        CodeSystem.Concept concept;
        if ("concept".equals(filter.getProperty().getValue()) && (CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) || codeSystem.getHierarchyMeaning() == null) && (concept = CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(filter.getValue()))) != null) {
            return new IsNotAFilter(codeSystem, concept);
        }
        throw CodeSystemSupport.conceptFilterNotCreated(IsNotAFilter.class, filter);
    }

    private static ConceptFilter createNotInFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        Code property = filter.getProperty();
        if ("concept".equals(property.getValue()) || CodeSystemSupport.hasCodeSystemProperty(codeSystem, property)) {
            if ("concept".equals(property.getValue())) {
                return CodeSystemSupport.isCaseSensitive(codeSystem) ? new NotInFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().collect(Collectors.toSet())) : new NotInFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().map(CodeSystemSupport::normalize).collect(Collectors.toSet()));
            }
            PropertyType type = CodeSystemSupport.getCodeSystemPropertyType(codeSystem, property);
            return new NotInFilter(codeSystem, property, Arrays.asList(filter.getValue().getValue().split(",")).stream().map(s -> CodeSystemSupport.toElement(s, type)).map(e -> e.is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)e.as(DateTime.class)) : CodeSystemSupport.toObject(e)).collect(Collectors.toSet()));
        }
        throw CodeSystemSupport.conceptFilterNotCreated(NotInFilter.class, filter);
    }

    private static ConceptFilter createRegexFilter(CodeSystem codeSystem, ValueSet.Compose.Include.Filter filter) {
        Code property = filter.getProperty();
        PropertyType type = CodeSystemSupport.getCodeSystemPropertyType(codeSystem, property);
        if (CodeSystemSupport.hasCodeSystemProperty(codeSystem, property) && (PropertyType.CODE.equals((Object)type) || PropertyType.STRING.equals((Object)type))) {
            return new RegexFilter(property, filter.getValue());
        }
        throw CodeSystemSupport.conceptFilterNotCreated(RegexFilter.class, filter);
    }

    private static java.lang.String toCodeValue(CodeSystem codeSystem, CodeSystem.Concept concept) {
        return CodeSystemSupport.getCodeValueFunction(codeSystem).apply(concept);
    }

    private static class RegexFilter
    implements ConceptFilter {
        private final Code property;
        private final Pattern pattern;

        public RegexFilter(Code property, String value) {
            this.property = property;
            this.pattern = Pattern.compile(value.getValue());
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            Element value;
            if (CodeSystemSupport.hasConceptProperty(concept, this.property) && (value = CodeSystemSupport.getConceptPropertyValue(concept, this.property)).is(String.class)) {
                return this.pattern.matcher(((String)value.as(String.class)).getValue()).matches();
            }
            return false;
        }
    }

    private static class NotInFilter
    extends InFilter {
        public NotInFilter(CodeSystem codeSystem, Code property, Set<Object> set) {
            super(codeSystem, property, set);
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            if ("concept".equals(this.property.getValue())) {
                return !this.set.contains(CodeSystemSupport.toCodeValue(this.codeSystem, concept));
            }
            if (CodeSystemSupport.hasConceptProperty(concept, this.property)) {
                Element value = CodeSystemSupport.getConceptPropertyValue(concept, this.property);
                return !this.set.contains(value.is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)value.as(DateTime.class)) : CodeSystemSupport.toObject(value));
            }
            return false;
        }
    }

    private static class IsNotAFilter
    extends IsAFilter {
        public IsNotAFilter(CodeSystem codeSystem, CodeSystem.Concept concept) {
            super(codeSystem, concept);
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            return !super.accept(concept);
        }
    }

    private static class IsAFilter
    implements ConceptFilter {
        private final CodeSystem codeSystem;
        private final Set<java.lang.String> descendantsAndSelf;

        public IsAFilter(CodeSystem codeSystem, CodeSystem.Concept concept) {
            this.codeSystem = codeSystem;
            this.descendantsAndSelf = CodeSystemSupport.getConcepts(concept, CodeSystemSupport.getCodeValueFunction(codeSystem));
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            return this.descendantsAndSelf.contains(CodeSystemSupport.toCodeValue(this.codeSystem, concept));
        }
    }

    private static class InFilter
    implements ConceptFilter {
        protected final CodeSystem codeSystem;
        protected final Code property;
        protected final Set<Object> set;

        public InFilter(CodeSystem codeSystem, Code property, Set<Object> set) {
            this.codeSystem = codeSystem;
            this.property = property;
            this.set = set;
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            if ("concept".equals(this.property.getValue())) {
                return this.set.contains(CodeSystemSupport.toCodeValue(this.codeSystem, concept));
            }
            if (CodeSystemSupport.hasConceptProperty(concept, this.property)) {
                Element value = CodeSystemSupport.getConceptPropertyValue(concept, this.property);
                return this.set.contains(value.is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)value.as(DateTime.class)) : CodeSystemSupport.toObject(value));
            }
            return false;
        }
    }

    private static class GeneralizesFilter
    implements ConceptFilter {
        private final CodeSystem codeSystem;
        private final java.lang.String concept;

        public GeneralizesFilter(CodeSystem codeSystem, CodeSystem.Concept concept) {
            this.codeSystem = codeSystem;
            this.concept = CodeSystemSupport.toCodeValue(codeSystem, concept);
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            return CodeSystemSupport.getConcepts(concept, CodeSystemSupport.getCodeValueFunction(this.codeSystem)).contains(this.concept);
        }
    }

    private static class ExistsFilter
    implements ConceptFilter {
        private Code property;
        private Boolean value;

        public ExistsFilter(Code property, Boolean value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            return Boolean.TRUE.equals((Object)this.value) ? CodeSystemSupport.hasConceptProperty(concept, this.property) : !CodeSystemSupport.hasConceptProperty(concept, this.property);
        }
    }

    private static class EqualsFilter
    implements ConceptFilter {
        private final CodeSystem codeSystem;
        private final PropertyType type;
        private final Code property;
        private final Object value;
        private final Set<java.lang.String> children;
        private final java.lang.String child;

        public EqualsFilter(CodeSystem codeSystem, Code property, String value) {
            CodeSystem.Concept parent;
            Element e;
            this.codeSystem = codeSystem;
            this.type = CodeSystemSupport.getCodeSystemPropertyType(codeSystem, property);
            this.property = property;
            this.value = CodeSystemSupport.hasCodeSystemProperty(codeSystem, property) ? ((e = CodeSystemSupport.toElement(value.getValue(), this.type)).is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)e.as(DateTime.class)) : CodeSystemSupport.toObject(e)) : null;
            this.children = new LinkedHashSet<java.lang.String>();
            if ("parent".equals(property.getValue()) && (parent = CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(value))) != null) {
                this.children.addAll(parent.getConcept().stream().map(CodeSystemSupport.getCodeValueFunction(codeSystem)).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            this.child = "child".equals(property.getValue()) ? CodeSystemSupport.toCodeValue(codeSystem, CodeSystemSupport.findConcept(codeSystem, CodeSystemSupport.code(value))) : null;
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            if ("parent".equals(this.property.getValue())) {
                return this.children.contains(CodeSystemSupport.toCodeValue(this.codeSystem, concept));
            }
            if ("child".equals(this.property.getValue())) {
                return concept.getConcept().stream().map(CodeSystemSupport.getCodeValueFunction(this.codeSystem)).collect(Collectors.toCollection(LinkedHashSet::new)).contains(this.child);
            }
            if (CodeSystemSupport.hasConceptProperty(concept, this.property)) {
                Element value = CodeSystemSupport.getConceptPropertyValue(concept, this.property);
                return this.value.equals(value.is(DateTime.class) ? CodeSystemSupport.toLong((DateTime)value.as(DateTime.class)) : CodeSystemSupport.toObject(value));
            }
            return false;
        }
    }

    private static class DescendentOfFilter
    implements ConceptFilter {
        private final CodeSystem codeSystem;
        private final Set<java.lang.String> descendants;

        public DescendentOfFilter(CodeSystem codeSystem, CodeSystem.Concept concept) {
            this.codeSystem = codeSystem;
            this.descendants = CodeSystemSupport.getConcepts(concept, CodeSystemSupport.getCodeValueFunction(codeSystem));
            this.descendants.remove(CodeSystemSupport.toCodeValue(codeSystem, concept));
        }

        @Override
        public boolean accept(CodeSystem.Concept concept) {
            return this.descendants.contains(CodeSystemSupport.toCodeValue(this.codeSystem, concept));
        }
    }

    private static interface ConceptFilter {
        public boolean accept(CodeSystem.Concept var1);
    }
}

