/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Canonical;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.model.type.Integer;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.term.service.util.FHIRTermServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExpansionParameters {
    public static final ExpansionParameters EMPTY = ExpansionParameters.builder().build();
    private final Uri context;
    private final Code contextDirection;
    private final String filter;
    private final DateTime date;
    private final Integer offset;
    private final Integer count;
    private final Boolean includeDesignations;
    private final Boolean activeOnly;
    private final Boolean excludeNested;
    private final Boolean excludeNotForUI;
    private final Boolean excludePostCoordinated;
    private final Code displayLanguage;
    private final List<Canonical> excludeSystem;
    private final List<Canonical> systemVersion;
    private final List<Canonical> checkSystemVersion;
    private final List<Canonical> forceSystemVersion;

    private ExpansionParameters(Builder builder) {
        this.context = builder.context;
        this.contextDirection = builder.contextDirection;
        this.filter = builder.filter;
        this.date = builder.date;
        this.offset = builder.offset;
        this.count = builder.count;
        this.includeDesignations = builder.includeDesignations;
        this.activeOnly = builder.activeOnly;
        this.excludeNested = builder.excludeNested;
        this.excludeNotForUI = builder.excludeNotForUI;
        this.excludePostCoordinated = builder.excludePostCoordinated;
        this.displayLanguage = builder.displayLanguage;
        this.excludeSystem = Collections.unmodifiableList(builder.excludeSystem);
        this.systemVersion = Collections.unmodifiableList(builder.systemVersion);
        this.checkSystemVersion = Collections.unmodifiableList(builder.checkSystemVersion);
        this.forceSystemVersion = Collections.unmodifiableList(builder.forceSystemVersion);
    }

    public Uri getContext() {
        return this.context;
    }

    public Code getContextDirection() {
        return this.contextDirection;
    }

    public String getFilter() {
        return this.filter;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getCount() {
        return this.count;
    }

    public Boolean getIncludeDesignations() {
        return this.includeDesignations;
    }

    public Boolean getActiveOnly() {
        return this.activeOnly;
    }

    public Boolean getExcludeNested() {
        return this.excludeNested;
    }

    public Boolean getExcludeNotForUI() {
        return this.excludeNotForUI;
    }

    public Boolean getExcludePostCoordinated() {
        return this.excludePostCoordinated;
    }

    public Code getDisplayLanguage() {
        return this.displayLanguage;
    }

    public List<Canonical> getExcludeSystem() {
        return this.excludeSystem;
    }

    public List<Canonical> getSystemVersion() {
        return this.systemVersion;
    }

    public List<Canonical> getCheckSystemVersion() {
        return this.checkSystemVersion;
    }

    public List<Canonical> getForceSystemVersion() {
        return this.forceSystemVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpansionParameters other = (ExpansionParameters)obj;
        return Objects.equals(this.context, other.context) && Objects.equals(this.contextDirection, other.contextDirection) && Objects.equals(this.filter, other.filter) && Objects.equals(this.date, other.date) && Objects.equals(this.offset, other.offset) && Objects.equals(this.count, other.count) && Objects.equals(this.includeDesignations, other.includeDesignations) && Objects.equals(this.activeOnly, other.activeOnly) && Objects.equals(this.excludeNested, other.excludeNested) && Objects.equals(this.excludeNotForUI, other.excludeNotForUI) && Objects.equals(this.excludePostCoordinated, other.excludePostCoordinated) && Objects.equals(this.displayLanguage, other.displayLanguage) && Objects.equals(this.excludeSystem, other.excludeSystem) && Objects.equals(this.systemVersion, other.systemVersion) && Objects.equals(this.checkSystemVersion, other.checkSystemVersion) && Objects.equals(this.forceSystemVersion, other.forceSystemVersion);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.contextDirection, this.filter, this.date, this.offset, this.count, this.includeDesignations, this.activeOnly, this.excludeNested, this.excludeNotForUI, this.excludePostCoordinated, this.displayLanguage, this.excludeSystem, this.systemVersion, this.checkSystemVersion, this.forceSystemVersion);
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ExpansionParameters from(Parameters parameters) {
        Parameters.Parameter context = FHIRTermServiceUtil.getParameter(parameters, "context");
        Parameters.Parameter contextDirection = FHIRTermServiceUtil.getParameter(parameters, "contextDirection");
        Parameters.Parameter filter = FHIRTermServiceUtil.getParameter(parameters, "filter");
        Parameters.Parameter date = FHIRTermServiceUtil.getParameter(parameters, "date");
        Parameters.Parameter offset = FHIRTermServiceUtil.getParameter(parameters, "offset");
        Parameters.Parameter count = FHIRTermServiceUtil.getParameter(parameters, "count");
        Parameters.Parameter includeDesignations = FHIRTermServiceUtil.getParameter(parameters, "includeDesignations");
        Parameters.Parameter activeOnly = FHIRTermServiceUtil.getParameter(parameters, "activeOnly");
        Parameters.Parameter excludeNested = FHIRTermServiceUtil.getParameter(parameters, "excludeNested");
        Parameters.Parameter excludeNotForUI = FHIRTermServiceUtil.getParameter(parameters, "excludeNotForUI");
        Parameters.Parameter excludePostCoordinated = FHIRTermServiceUtil.getParameter(parameters, "excludePostCoordinated");
        Parameters.Parameter displayLanguage = FHIRTermServiceUtil.getParameter(parameters, "displayLanguage");
        return ExpansionParameters.builder().context(context != null ? (Uri)context.getValue().as(Uri.class) : null).contextDirection(contextDirection != null ? (Code)contextDirection.getValue().as(Code.class) : null).filter(filter != null ? (String)filter.getValue().as(String.class) : null).date(date != null ? (DateTime)date.getValue().as(DateTime.class) : null).offset(offset != null ? (Integer)offset.getValue().as(Integer.class) : null).count(count != null ? (Integer)count.getValue().as(Integer.class) : null).includeDesignations(includeDesignations != null ? (Boolean)includeDesignations.getValue().as(Boolean.class) : null).activeOnly(activeOnly != null ? (Boolean)activeOnly.getValue().as(Boolean.class) : null).excludeNested(excludeNested != null ? (Boolean)excludeNested.getValue().as(Boolean.class) : null).excludeNotForUI(excludeNotForUI != null ? (Boolean)excludeNotForUI.getValue().as(Boolean.class) : null).excludePostCoordinated(excludePostCoordinated != null ? (Boolean)excludePostCoordinated.getValue().as(Boolean.class) : null).displayLanguage(displayLanguage != null ? (Code)displayLanguage.getValue().as(Code.class) : null).excludeSystem(FHIRTermServiceUtil.getParameters(parameters, "excludeSystem").stream().map(parameter -> (Canonical)parameter.getValue().as(Canonical.class)).collect(Collectors.toList())).systemVersion(FHIRTermServiceUtil.getParameters(parameters, "systemVersion").stream().map(parameter -> (Canonical)parameter.getValue().as(Canonical.class)).collect(Collectors.toList())).checkSystemVersion(FHIRTermServiceUtil.getParameters(parameters, "checkSystemVersion").stream().map(parameter -> (Canonical)parameter.getValue().as(Canonical.class)).collect(Collectors.toList())).forceSystemVersion(FHIRTermServiceUtil.getParameters(parameters, "forceSystemVersion").stream().map(parameter -> (Canonical)parameter.getValue().as(Canonical.class)).collect(Collectors.toList())).build();
    }

    public static class Builder {
        private Uri context;
        private Code contextDirection;
        private String filter;
        private DateTime date;
        private Integer offset;
        private Integer count;
        private Boolean includeDesignations;
        private Boolean activeOnly;
        private Boolean excludeNested;
        private Boolean excludeNotForUI;
        private Boolean excludePostCoordinated;
        private Code displayLanguage;
        private List<Canonical> excludeSystem = new ArrayList<Canonical>();
        private List<Canonical> systemVersion = new ArrayList<Canonical>();
        private List<Canonical> checkSystemVersion = new ArrayList<Canonical>();
        private List<Canonical> forceSystemVersion = new ArrayList<Canonical>();

        private Builder() {
        }

        public Builder context(Uri context) {
            this.context = context;
            return this;
        }

        public Builder contextDirection(Code contextDirection) {
            this.contextDirection = contextDirection;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder includeDesignations(Boolean includeDesignations) {
            this.includeDesignations = includeDesignations;
            return this;
        }

        public Builder activeOnly(Boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public Builder excludeNested(Boolean excludeNested) {
            this.excludeNested = excludeNested;
            return this;
        }

        public Builder excludeNotForUI(Boolean excludeNotForUI) {
            this.excludeNotForUI = excludeNotForUI;
            return this;
        }

        public Builder excludePostCoordinated(Boolean excludePostCoordinated) {
            this.excludePostCoordinated = excludePostCoordinated;
            return this;
        }

        public Builder displayLanguage(Code displayLanguage) {
            this.displayLanguage = displayLanguage;
            return this;
        }

        public Builder excludeSystem(Canonical ... excludeSystem) {
            for (Canonical value : excludeSystem) {
                this.excludeSystem.add(value);
            }
            return this;
        }

        public Builder excludeSystem(Collection<Canonical> excludeSystem) {
            this.excludeSystem = new ArrayList<Canonical>(excludeSystem);
            return this;
        }

        public Builder systemVersion(Canonical ... systemVersion) {
            for (Canonical value : systemVersion) {
                this.systemVersion.add(value);
            }
            return this;
        }

        public Builder systemVersion(Collection<Canonical> systemVersion) {
            this.systemVersion = new ArrayList<Canonical>(systemVersion);
            return this;
        }

        public Builder checkSystemVersion(Canonical ... checkSystemVersion) {
            for (Canonical value : checkSystemVersion) {
                this.checkSystemVersion.add(value);
            }
            return this;
        }

        public Builder checkSystemVersion(Collection<Canonical> checkSystemVersion) {
            this.checkSystemVersion = new ArrayList<Canonical>(checkSystemVersion);
            return this;
        }

        public Builder forceSystemVersion(Canonical ... forceSystemVersion) {
            for (Canonical value : forceSystemVersion) {
                this.forceSystemVersion.add(value);
            }
            return this;
        }

        public Builder forceSystemVersion(Collection<Canonical> forceSystemVersion) {
            this.forceSystemVersion = new ArrayList<Canonical>(this.excludeSystem);
            return this;
        }

        public ExpansionParameters build() {
            return new ExpansionParameters(this);
        }

        protected Builder from(ExpansionParameters expansionParameters) {
            this.context = expansionParameters.context;
            this.contextDirection = expansionParameters.contextDirection;
            this.filter = expansionParameters.filter;
            this.date = expansionParameters.date;
            this.offset = expansionParameters.offset;
            this.count = expansionParameters.count;
            this.includeDesignations = expansionParameters.includeDesignations;
            this.activeOnly = expansionParameters.activeOnly;
            this.excludeNested = expansionParameters.excludeNested;
            this.excludeNotForUI = expansionParameters.excludeNotForUI;
            this.excludePostCoordinated = expansionParameters.excludePostCoordinated;
            this.displayLanguage = expansionParameters.displayLanguage;
            this.excludeSystem.addAll(expansionParameters.excludeSystem);
            this.systemVersion.addAll(expansionParameters.systemVersion);
            this.checkSystemVersion.addAll(expansionParameters.checkSystemVersion);
            this.forceSystemVersion.addAll(expansionParameters.forceSystemVersion);
            return this;
        }
    }
}

