/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.cache.CachingProxy;
import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.ConceptMap;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Coding;
import com.ibm.fhir.model.type.String;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.model.type.code.CodeSystemHierarchyMeaning;
import com.ibm.fhir.model.type.code.ConceptSubsumptionOutcome;
import com.ibm.fhir.model.util.FHIRUtil;
import com.ibm.fhir.term.config.FHIRTermConfig;
import com.ibm.fhir.term.service.ExpansionParameters;
import com.ibm.fhir.term.service.LookupOutcome;
import com.ibm.fhir.term.service.LookupParameters;
import com.ibm.fhir.term.service.TranslationOutcome;
import com.ibm.fhir.term.service.TranslationParameters;
import com.ibm.fhir.term.service.ValidationOutcome;
import com.ibm.fhir.term.service.ValidationParameters;
import com.ibm.fhir.term.service.provider.RegistryTermServiceProvider;
import com.ibm.fhir.term.spi.FHIRTermServiceProvider;
import com.ibm.fhir.term.util.CodeSystemSupport;
import com.ibm.fhir.term.util.ValueSetSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class FHIRTermService {
    private static final Logger LOGGER = Logger.getLogger(FHIRTermService.class.getName());
    private static final FHIRTermService INSTANCE = new FHIRTermService();
    private static final FHIRTermServiceProvider NULL_TERM_SERVICE_PROVIDER = new FHIRTermServiceProvider(){

        @Override
        public Set<CodeSystem.Concept> closure(CodeSystem codeSystem, Code code) {
            return Collections.emptySet();
        }

        @Override
        public CodeSystem.Concept getConcept(CodeSystem codeSystem, Code code) {
            return null;
        }

        @Override
        public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem) {
            return Collections.emptySet();
        }

        @Override
        public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
            return Collections.emptySet();
        }

        @Override
        public boolean hasConcept(CodeSystem codeSystem, Code code) {
            return false;
        }

        @Override
        public boolean isSupported(CodeSystem codeSystem) {
            return false;
        }

        @Override
        public boolean subsumes(CodeSystem codeSystem, Code codeA, Code codeB) {
            return false;
        }
    };
    private final List<FHIRTermServiceProvider> providers = new CopyOnWriteArrayList<FHIRTermServiceProvider>(this.loadProviders());

    private FHIRTermService() {
    }

    public void addProvider(FHIRTermServiceProvider provider) {
        Objects.requireNonNull(provider);
        this.providers.add(provider);
    }

    public Set<CodeSystem.Concept> closure(CodeSystem codeSystem, Code code) {
        return this.findProvider(codeSystem).closure(codeSystem, code);
    }

    public Set<CodeSystem.Concept> closure(Coding coding) {
        FHIRTermServiceProvider provider;
        java.lang.String url;
        CodeSystem codeSystem;
        Uri system = coding.getSystem();
        java.lang.String version = coding.getVersion() != null ? coding.getVersion().getValue() : null;
        Code code = coding.getCode();
        if (system != null && code != null && (codeSystem = CodeSystemSupport.getCodeSystem(url = version != null ? system.getValue() + "|" + version : system.getValue())) != null && (CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) || codeSystem.getHierarchyMeaning() == null) && (provider = this.findProvider(codeSystem)).hasConcept(codeSystem, code)) {
            return provider.closure(codeSystem, code);
        }
        return Collections.emptySet();
    }

    public Map<Coding, Set<CodeSystem.Concept>> closure(Set<Coding> codings) {
        LinkedHashMap<Coding, Set<CodeSystem.Concept>> result = new LinkedHashMap<Coding, Set<CodeSystem.Concept>>();
        LinkedHashMap<CodeSystem, Set> codeSetMap = new LinkedHashMap<CodeSystem, Set>();
        LinkedHashMap<CodeSystem, Map> codingMapMap = new LinkedHashMap<CodeSystem, Map>();
        for (Coding coding : codings) {
            Uri system = coding.getSystem();
            java.lang.String version = coding.getVersion() != null ? coding.getVersion().getValue() : null;
            Code code = coding.getCode();
            if (system == null || code == null) {
                return Collections.emptyMap();
            }
            Object url = version != null ? system.getValue() + "|" + version : system.getValue();
            CodeSystem codeSystem = CodeSystemSupport.getCodeSystem((java.lang.String)url);
            if (codeSystem == null || !CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) && codeSystem.getHierarchyMeaning() != null) {
                return Collections.emptyMap();
            }
            codeSetMap.computeIfAbsent(codeSystem, k -> new LinkedHashSet()).add(code);
            codingMapMap.computeIfAbsent(codeSystem, k -> new LinkedHashMap()).put(code, coding);
        }
        for (CodeSystem codeSystem : codeSetMap.keySet()) {
            Set codes = (Set)codeSetMap.get(codeSystem);
            FHIRTermServiceProvider provider = this.findProvider(codeSystem);
            if (!provider.hasConcepts(codeSystem, codes)) {
                return Collections.emptyMap();
            }
            Map<Code, Set<CodeSystem.Concept>> closureMap = provider.closure(codeSystem, codes);
            for (Code code : closureMap.keySet()) {
                Coding coding = (Coding)((Map)codingMapMap.get(codeSystem)).get(code);
                Set<CodeSystem.Concept> closure = closureMap.get(code);
                result.put(coding, closure);
            }
        }
        return result;
    }

    public Map<Code, Set<CodeSystem.Concept>> closure(CodeSystem codeSystem, Set<Code> codes) {
        return this.findProvider(codeSystem).closure(codeSystem, codes);
    }

    public ValueSet expand(ValueSet valueSet) {
        return ValueSetSupport.expand(valueSet);
    }

    public ValueSet expand(ValueSet valueSet, ExpansionParameters parameters) {
        if (!ExpansionParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Expansion parameters are not supported");
        }
        return ValueSetSupport.expand(valueSet);
    }

    public CodeSystem.Concept getConcept(CodeSystem codeSystem, Code code) {
        return this.findProvider(codeSystem).getConcept(codeSystem, code);
    }

    public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem) {
        return this.findProvider(codeSystem).getConcepts(codeSystem);
    }

    public <R> Set<R> getConcepts(CodeSystem codeSystem, Function<CodeSystem.Concept, ? extends R> function) {
        return this.findProvider(codeSystem).getConcepts(codeSystem, function);
    }

    public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
        return this.findProvider(codeSystem).getConcepts(codeSystem, filters);
    }

    public <R> Set<R> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters, Function<CodeSystem.Concept, ? extends R> function) {
        return this.findProvider(codeSystem).getConcepts(codeSystem, filters, function);
    }

    public boolean hasConcept(CodeSystem codeSystem, Code code) {
        return this.findProvider(codeSystem).hasConcept(codeSystem, code);
    }

    public boolean hasConcepts(CodeSystem codeSystem, Set<Code> codes) {
        return this.findProvider(codeSystem).hasConcepts(codeSystem, codes);
    }

    public boolean isExpandable(ValueSet valueSet) {
        return ValueSetSupport.isExpandable(valueSet);
    }

    public boolean isSupported(CodeSystem codeSystem) {
        if (codeSystem != null) {
            for (FHIRTermServiceProvider provider : this.providers) {
                if (!provider.isSupported(codeSystem)) continue;
                return true;
            }
        }
        return false;
    }

    public LookupOutcome lookup(Coding coding) {
        return this.lookup(coding, LookupParameters.EMPTY);
    }

    public LookupOutcome lookup(Coding coding, LookupParameters parameters) {
        CodeSystem.Concept concept;
        java.lang.String version;
        java.lang.String url;
        CodeSystem codeSystem;
        if (!LookupParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Lookup parameters are not suppored");
        }
        Uri system = coding.getSystem();
        Code code = coding.getCode();
        if (system != null && code != null && (codeSystem = CodeSystemSupport.getCodeSystem(url = (version = coding.getVersion() != null ? coding.getVersion().getValue() : null) != null ? system.getValue() + "|" + version : system.getValue())) != null && (concept = this.findProvider(codeSystem).getConcept(codeSystem, code)) != null) {
            return LookupOutcome.builder().name(codeSystem.getName() != null ? codeSystem.getName() : FHIRUtil.STRING_DATA_ABSENT_REASON_UNKNOWN).version(codeSystem.getVersion()).display(concept.getDisplay() != null ? concept.getDisplay() : FHIRUtil.STRING_DATA_ABSENT_REASON_UNKNOWN).property(concept.getProperty().stream().map(property -> LookupOutcome.Property.builder().code(property.getCode()).value(property.getValue()).build()).collect(Collectors.toList())).designation(concept.getDesignation().stream().map(designation -> LookupOutcome.Designation.builder().language(designation.getLanguage()).use(designation.getUse()).value(designation.getValue()).build()).collect(Collectors.toList())).build();
        }
        return null;
    }

    public LookupOutcome lookup(Uri system, String version, Code code) {
        return this.lookup(system, version, code, LookupParameters.EMPTY);
    }

    public LookupOutcome lookup(Uri system, String version, Code code, LookupParameters parameters) {
        if (!LookupParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Lookup parameters are not suppored");
        }
        Coding coding = Coding.builder().system(system).version(version).code(code).build();
        return this.lookup(coding, parameters);
    }

    public boolean subsumes(CodeSystem codeSystem, Code codeA, Code codeB) {
        return this.findProvider(codeSystem).subsumes(codeSystem, codeA, codeB);
    }

    public ConceptSubsumptionOutcome subsumes(Coding codingA, Coding codingB) {
        Uri systemA = codingA.getSystem();
        java.lang.String versionA = codingA.getVersion() != null ? codingA.getVersion().getValue() : null;
        Code codeA = codingA.getCode();
        Uri systemB = codingB.getSystem();
        java.lang.String versionB = codingB.getVersion() != null ? codingB.getVersion().getValue() : null;
        Code codeB = codingB.getCode();
        if (systemA != null && systemB != null && codeA != null && codeB != null && systemA.equals((Object)systemB)) {
            FHIRTermServiceProvider provider;
            CodeSystem codeSystem;
            Object url = systemA.getValue();
            if (versionA != null || versionB != null) {
                if (versionA != null && versionB != null && !versionA.equals(versionB)) {
                    return null;
                }
                Object object = url = versionA != null ? (java.lang.String)url + "|" + versionA : (java.lang.String)url + "|" + versionB;
            }
            if ((codeSystem = CodeSystemSupport.getCodeSystem((java.lang.String)url)) != null && CodeSystemHierarchyMeaning.IS_A.equals((Object)codeSystem.getHierarchyMeaning()) && (provider = this.findProvider(codeSystem)).hasConcept(codeSystem, codeA) && provider.hasConcept(codeSystem, codeB)) {
                if (provider.subsumes(codeSystem, codeA, codeB)) {
                    return codeA.equals((Object)codeB) || !CodeSystemSupport.isCaseSensitive(codeSystem) && CodeSystemSupport.normalize(codeA.getValue()).equals(CodeSystemSupport.normalize(codeB.getValue())) ? ConceptSubsumptionOutcome.EQUIVALENT : ConceptSubsumptionOutcome.SUBSUMES;
                }
                return provider.subsumes(codeSystem, codeB, codeA) ? ConceptSubsumptionOutcome.SUBSUMED_BY : ConceptSubsumptionOutcome.NOT_SUBSUMED;
            }
        }
        return null;
    }

    public TranslationOutcome translate(ConceptMap conceptMap, CodeableConcept codeableConcept) {
        return this.translate(conceptMap, codeableConcept, TranslationParameters.EMPTY);
    }

    public TranslationOutcome translate(ConceptMap conceptMap, CodeableConcept codeableConcept, TranslationParameters parameters) {
        if (!TranslationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Translation parameters are not supported");
        }
        for (Coding coding : codeableConcept.getCoding()) {
            TranslationOutcome outcome = this.translate(conceptMap, coding, parameters);
            if (!Boolean.TRUE.equals((Object)outcome.getResult())) continue;
            return outcome;
        }
        return TranslationOutcome.builder().result(Boolean.FALSE).message(String.string((java.lang.String)"No matches found")).build();
    }

    public TranslationOutcome translate(ConceptMap conceptMap, Coding coding) {
        return this.translate(conceptMap, coding, TranslationParameters.EMPTY);
    }

    public TranslationOutcome translate(ConceptMap conceptMap, Coding coding, TranslationParameters parameters) {
        if (!TranslationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Translation parameters are not supported");
        }
        Uri source = this.getSource(conceptMap);
        ArrayList<TranslationOutcome.Match> match = new ArrayList<TranslationOutcome.Match>();
        for (ConceptMap.Group group : conceptMap.getGroup()) {
            if (group.getSource() == null || !group.getSource().equals((Object)coding.getSystem()) || group.getSourceVersion() != null && coding.getVersion() != null && !group.getSourceVersion().equals((Object)coding.getVersion())) continue;
            for (ConceptMap.Group.Element element : group.getElement()) {
                if (element.getCode() == null || !element.getCode().equals((Object)coding.getCode())) continue;
                for (ConceptMap.Group.Element.Target target : element.getTarget()) {
                    match.add(TranslationOutcome.Match.builder().equivalence(target.getEquivalence()).concept(Coding.builder().system(group.getTarget()).version(group.getTargetVersion()).code(target.getCode()).display(target.getDisplay()).build()).source(source).build());
                }
            }
        }
        return TranslationOutcome.builder().result(match.isEmpty() ? Boolean.FALSE : Boolean.TRUE).message(match.isEmpty() ? String.string((java.lang.String)"No matches found") : null).match(match).build();
    }

    public TranslationOutcome translate(ConceptMap conceptMap, Uri system, String version, Code code) {
        return this.translate(conceptMap, system, version, code, TranslationParameters.EMPTY);
    }

    public TranslationOutcome translate(ConceptMap conceptMap, Uri system, String version, Code code, TranslationParameters parameters) {
        if (!TranslationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Translation parameters are not supported");
        }
        Coding coding = Coding.builder().system(system).version(version).code(code).build();
        return this.translate(conceptMap, coding, parameters);
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, CodeableConcept codeableConcept) {
        return this.validateCode(codeSystem, codeableConcept, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, CodeableConcept codeableConcept, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        for (Coding coding : codeableConcept.getCoding()) {
            ValidationOutcome outcome = this.validateCode(codeSystem, coding, parameters);
            if (!Boolean.TRUE.equals((Object)outcome.getResult())) continue;
            return outcome;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder().append("None of the Coding values in the CodeableConcept were found to be valid in CodeSystem with URL=").append(codeSystem.getUrl() == null ? null : codeSystem.getUrl().getValue()).append(" and version=").append(codeSystem.getVersion() == null ? null : codeSystem.getVersion().getValue());
            LOGGER.fine(message.toString());
        }
        return this.buildValidationOutcome(false);
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, Coding coding) {
        return this.validateCode(codeSystem, coding, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, Coding coding, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        LookupOutcome outcome = this.lookup(coding, LookupParameters.EMPTY);
        if (outcome != null) {
            return this.validateDisplay(null, coding, outcome);
        }
        StringBuilder message = new StringBuilder("Code '");
        if (coding != null && coding.getCode() != null) {
            message.append(coding.getCode().getValue());
        }
        message.append("' was not found in system '");
        if (coding != null && coding.getSystem() != null) {
            message.append(coding.getSystem().getValue());
        }
        message.append("'");
        return this.buildValidationOutcome(false, message.toString());
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, Code code, String display) {
        return this.validateCode(codeSystem, code, display, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(CodeSystem codeSystem, Code code, String display, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        Coding coding = Coding.builder().system(codeSystem.getUrl()).version(codeSystem.getVersion()).code(code).display(display).build();
        return this.validateCode(codeSystem, coding, parameters);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Code code) {
        return this.validateCode(valueSet, code, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Code code, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        boolean result = ValueSetSupport.validateCode(valueSet, code);
        if (result) {
            return this.buildValidationOutcome(true, null);
        }
        StringBuilder message = new StringBuilder().append("Code '").append(code.getValue()).append("' is not a valid member of ValueSet with URL=").append(valueSet.getUrl() == null ? null : valueSet.getUrl().getValue()).append(" and version=").append(valueSet.getVersion() == null ? null : valueSet.getVersion().getValue());
        return this.buildValidationOutcome(false, message.toString());
    }

    public ValidationOutcome validateCode(ValueSet valueSet, CodeableConcept codeableConcept) {
        return this.validateCode(valueSet, codeableConcept, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, CodeableConcept codeableConcept, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        for (Coding coding : codeableConcept.getCoding()) {
            boolean result = ValueSetSupport.validateCode(valueSet, coding);
            if (!result) continue;
            LookupOutcome outcome = this.lookup(coding);
            return this.validateDisplay(null, coding, outcome);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder message = new StringBuilder().append("None of the Coding values in the CodeableConcept were found to be valid in ValueSet with URL=").append(valueSet.getUrl() == null ? null : valueSet.getUrl().getValue()).append(" and version=").append(valueSet.getVersion() == null ? null : valueSet.getVersion().getValue());
            LOGGER.fine(message.toString());
        }
        return this.buildValidationOutcome(false);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Coding coding) {
        return this.validateCode(valueSet, coding, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Coding coding, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        boolean result = ValueSetSupport.validateCode(valueSet, coding);
        if (result) {
            LookupOutcome outcome = this.lookup(coding);
            return this.validateDisplay(null, coding, outcome);
        }
        StringBuilder message = new StringBuilder().append("Code '").append(coding.getCode() == null ? null : coding.getCode().getValue()).append("' in system '").append(coding.getSystem() == null ? null : coding.getSystem().getValue()).append("' is not a valid member of ValueSet with URL=").append(valueSet.getUrl() == null ? null : valueSet.getUrl().getValue()).append(" and version=").append(valueSet.getVersion() == null ? null : valueSet.getVersion().getValue());
        return this.buildValidationOutcome(false, message.toString());
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Uri system, String version, Code code, String display) {
        return this.validateCode(valueSet, system, version, code, display, ValidationParameters.EMPTY);
    }

    public ValidationOutcome validateCode(ValueSet valueSet, Uri system, String version, Code code, String display, ValidationParameters parameters) {
        if (!ValidationParameters.EMPTY.equals(parameters)) {
            throw new UnsupportedOperationException("Validation parameters are not supported");
        }
        Coding coding = Coding.builder().system(system).version(version).code(code).build();
        return this.validateCode(valueSet, coding, parameters);
    }

    private FHIRTermServiceProvider findProvider(CodeSystem codeSystem) {
        for (FHIRTermServiceProvider provider : this.providers) {
            if (!provider.isSupported(codeSystem)) continue;
            return provider;
        }
        return NULL_TERM_SERVICE_PROVIDER;
    }

    private Uri getSource(ConceptMap conceptMap) {
        StringBuilder sb = new StringBuilder(conceptMap.getUrl().getValue());
        if (conceptMap.getVersion() != null) {
            sb.append("|").append(conceptMap.getVersion().getValue());
        }
        return Uri.of((java.lang.String)sb.toString());
    }

    private List<FHIRTermServiceProvider> loadProviders() {
        ArrayList<FHIRTermServiceProvider> providers = new ArrayList<FHIRTermServiceProvider>();
        providers.add(FHIRTermConfig.isCachingDisabled() ? new RegistryTermServiceProvider() : (FHIRTermServiceProvider)CachingProxy.newInstance(FHIRTermServiceProvider.class, (Object)new RegistryTermServiceProvider()));
        Iterator<FHIRTermServiceProvider> iterator = ServiceLoader.load(FHIRTermServiceProvider.class).iterator();
        while (iterator.hasNext()) {
            providers.add(iterator.next());
        }
        return providers;
    }

    private ValidationOutcome validateDisplay(CodeSystem codeSystem, Coding coding, LookupOutcome lookupOutcome) {
        boolean caseSensitive;
        if (lookupOutcome == null || coding == null || lookupOutcome.getDisplay() == null || coding.getDisplay() == null || lookupOutcome.getDisplay().getValue() == null && coding.getDisplay().getValue() == null) {
            return this.buildValidationOutcome(true, null, lookupOutcome);
        }
        java.lang.String system = null;
        if (coding.getSystem() != null) {
            system = coding.getSystem().getValue();
        } else if (codeSystem != null && codeSystem.getUrl() != null) {
            system = codeSystem.getUrl().getValue();
        }
        boolean bl = caseSensitive = codeSystem != null ? CodeSystemSupport.isCaseSensitive(codeSystem) : false;
        if (codeSystem == null && system != null) {
            java.lang.String version = coding.getVersion() != null ? coding.getVersion().getValue() : null;
            java.lang.String url = version != null ? system + "|" + version : system;
            caseSensitive = CodeSystemSupport.isCaseSensitive(url);
        }
        boolean result = caseSensitive ? lookupOutcome.getDisplay().equals((Object)coding.getDisplay()) : CodeSystemSupport.normalize(lookupOutcome.getDisplay().getValue()).equals(CodeSystemSupport.normalize(coding.getDisplay().getValue()));
        java.lang.String message = !result ? java.lang.String.format("The display '%s' is incorrect for code '%s' from code system '%s'", coding.getDisplay().getValue(), coding.getCode().getValue(), system) : null;
        return this.buildValidationOutcome(result, message, lookupOutcome);
    }

    public static FHIRTermService getInstance() {
        return INSTANCE;
    }

    private ValidationOutcome buildValidationOutcome(boolean result) {
        return this.buildValidationOutcome(result, null, null);
    }

    private ValidationOutcome buildValidationOutcome(boolean result, java.lang.String message) {
        return this.buildValidationOutcome(result, message, null);
    }

    private ValidationOutcome buildValidationOutcome(boolean result, java.lang.String message, LookupOutcome lookupOutcome) {
        return ValidationOutcome.builder().result(result ? Boolean.TRUE : Boolean.FALSE).message(message != null ? String.string((java.lang.String)message) : null).display(lookupOutcome != null ? lookupOutcome.getDisplay() : null).build();
    }
}

