/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.registry;

import com.ibm.fhir.cache.util.CacheSupport;
import com.ibm.fhir.model.resource.Resource;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.registry.resource.FHIRRegistryResource;
import com.ibm.fhir.registry.spi.FHIRRegistryResourceProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class ImplicitValueSetRegistryResourceProvider
implements FHIRRegistryResourceProvider {
    private static final Map<String, FHIRRegistryResource> IMPLICIT_VALUE_SET_REGISTRY_RESOURCE_CACHE = CacheSupport.createCacheAsMap((int)1024);

    public Collection<FHIRRegistryResource> getProfileResources(String type) {
        return Collections.emptyList();
    }

    public FHIRRegistryResource getRegistryResource(Class<? extends Resource> resourceType, String url, String version) {
        if (url == null) {
            return null;
        }
        if (ValueSet.class.equals(resourceType) && this.isSupported(url)) {
            return IMPLICIT_VALUE_SET_REGISTRY_RESOURCE_CACHE.computeIfAbsent(url, k -> FHIRRegistryResource.from((Resource)this.buildImplicitValueSet(url)));
        }
        return null;
    }

    public Collection<FHIRRegistryResource> getRegistryResources() {
        return Collections.emptyList();
    }

    public Collection<FHIRRegistryResource> getRegistryResources(Class<? extends Resource> resourceType) {
        return Collections.emptyList();
    }

    public Collection<FHIRRegistryResource> getSearchParameterResources(String type) {
        return Collections.emptyList();
    }

    protected abstract ValueSet buildImplicitValueSet(String var1);

    protected abstract boolean isSupported(String var1);
}

