/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.term.service.util.FHIRTermServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class LookupParameters {
    public static final LookupParameters EMPTY = LookupParameters.builder().build();
    private final DateTime date;
    private final Code displayLanguage;
    private final List<Code> property;

    private LookupParameters(Builder builder) {
        this.date = builder.date;
        this.displayLanguage = builder.displayLanguage;
        this.property = Collections.unmodifiableList(builder.property);
    }

    public DateTime getDate() {
        return this.date;
    }

    public Code getDisplayLanguage() {
        return this.displayLanguage;
    }

    public List<Code> getProperty() {
        return this.property;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LookupParameters other = (LookupParameters)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this.displayLanguage, other.displayLanguage) && Objects.equals(this.property, other.property);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.displayLanguage, this.property);
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static LookupParameters from(Parameters parameters) {
        Parameters.Parameter date = FHIRTermServiceUtil.getParameter(parameters, "date");
        Parameters.Parameter displayLanguage = FHIRTermServiceUtil.getParameter(parameters, "displayLanguage");
        return LookupParameters.builder().date(date != null ? (DateTime)date.getValue().as(DateTime.class) : null).displayLanguage(displayLanguage != null ? (Code)displayLanguage.getValue().as(Code.class) : null).property(FHIRTermServiceUtil.getParameters(parameters, "property").stream().map(parameter -> (Code)parameter.getValue().as(Code.class)).collect(Collectors.toList())).build();
    }

    public static class Builder {
        private DateTime date;
        private Code displayLanguage;
        private List<Code> property = new ArrayList<Code>();

        private Builder() {
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder displayLanguage(Code displayLanguage) {
            this.displayLanguage = displayLanguage;
            return this;
        }

        public Builder property(Code ... property) {
            for (Code value : property) {
                this.property.add(value);
            }
            return this;
        }

        public Builder property(Collection<Code> property) {
            this.property = new ArrayList<Code>(property);
            return this;
        }

        public LookupParameters build() {
            return new LookupParameters(this);
        }

        protected Builder from(LookupParameters lookupParameters) {
            this.date = lookupParameters.date;
            this.displayLanguage = lookupParameters.displayLanguage;
            this.property.addAll(lookupParameters.property);
            return this;
        }
    }
}

