/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.CodeableConcept;
import com.ibm.fhir.model.type.Uri;
import com.ibm.fhir.term.service.util.FHIRTermServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TranslationParameters {
    public static final TranslationParameters EMPTY = TranslationParameters.builder().build();
    private final List<Dependency> dependency;
    private final Boolean reverse;

    private TranslationParameters(Builder builder) {
        this.dependency = Collections.unmodifiableList(builder.dependency);
        this.reverse = builder.reverse;
    }

    public List<Dependency> getDependency() {
        return this.dependency;
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TranslationParameters other = (TranslationParameters)obj;
        return Objects.equals(this.dependency, other.dependency) && Objects.equals(this.reverse, other.reverse);
    }

    public int hashCode() {
        return Objects.hash(this.dependency, this.reverse);
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static TranslationParameters from(Parameters parameters) {
        Parameters.Parameter reverse = FHIRTermServiceUtil.getParameter(parameters, "reverse");
        return TranslationParameters.builder().dependency(FHIRTermServiceUtil.getParameters(parameters, "dependency").stream().map(Dependency::from).collect(Collectors.toList())).reverse(reverse != null ? (Boolean)reverse.getValue().as(Boolean.class) : null).build();
    }

    public static class Dependency {
        private final Uri element;
        private final CodeableConcept concept;

        private Dependency(Builder builder) {
            this.element = builder.element;
            this.concept = builder.concept;
        }

        public Uri getElement() {
            return this.element;
        }

        public CodeableConcept getConcept() {
            return this.concept;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dependency other = (Dependency)obj;
            return Objects.equals(this.element, other.element) && Objects.equals(this.concept, other.concept);
        }

        public int hashCode() {
            return Objects.hash(this.element, this.concept);
        }

        public Builder toBuilder() {
            return new Builder().from(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Dependency from(Parameters.Parameter parameter) {
            Parameters.Parameter element = FHIRTermServiceUtil.getPart(parameter, "element");
            Parameters.Parameter concept = FHIRTermServiceUtil.getPart(parameter, "concept");
            return Dependency.builder().element(element != null ? (Uri)element.getValue().as(Uri.class) : null).concept(concept != null ? (CodeableConcept)concept.getValue().as(CodeableConcept.class) : null).build();
        }

        public static class Builder {
            private Uri element;
            private CodeableConcept concept;

            private Builder() {
            }

            public Builder element(Uri element) {
                this.element = element;
                return this;
            }

            public Builder concept(CodeableConcept concept) {
                this.concept = concept;
                return this;
            }

            public Dependency build() {
                return new Dependency(this);
            }

            protected Builder from(Dependency dependency) {
                this.element = dependency.element;
                this.concept = dependency.concept;
                return this;
            }
        }
    }

    public static class Builder {
        private List<Dependency> dependency = new ArrayList<Dependency>();
        private Boolean reverse;

        private Builder() {
        }

        public Builder dependency(Dependency ... dependency) {
            for (Dependency value : dependency) {
                this.dependency.add(value);
            }
            return this;
        }

        public Builder dependency(Collection<Dependency> dependency) {
            this.dependency = new ArrayList<Dependency>(dependency);
            return this;
        }

        public Builder reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public TranslationParameters build() {
            return new TranslationParameters(this);
        }

        protected Builder from(TranslationParameters translationParameters) {
            this.dependency.addAll(translationParameters.dependency);
            this.reverse = translationParameters.reverse;
            return this;
        }
    }
}

