/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Boolean;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.DateTime;
import com.ibm.fhir.term.service.util.FHIRTermServiceUtil;
import java.util.Objects;

public class ValidationParameters {
    public static final ValidationParameters EMPTY = ValidationParameters.builder().build();
    private final DateTime date;
    private final Boolean _abstract;
    private final Code displayLanguage;

    private ValidationParameters(Builder builder) {
        this.date = builder.date;
        this._abstract = builder._abstract;
        this.displayLanguage = builder.displayLanguage;
    }

    public DateTime getDate() {
        return this.date;
    }

    public Boolean getAbstract() {
        return this._abstract;
    }

    public Code getDisplayLanguage() {
        return this.displayLanguage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationParameters other = (ValidationParameters)obj;
        return Objects.equals(this.date, other.date) && Objects.equals(this._abstract, other._abstract) && Objects.equals(this.displayLanguage, other.displayLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.date, this._abstract, this.displayLanguage);
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ValidationParameters from(Parameters parameters) {
        Parameters.Parameter date = FHIRTermServiceUtil.getParameter(parameters, "date");
        Parameters.Parameter _abstract = FHIRTermServiceUtil.getParameter(parameters, "abstract");
        Parameters.Parameter displayLanguage = FHIRTermServiceUtil.getParameter(parameters, "displayLanguage");
        return ValidationParameters.builder().date(date != null ? (DateTime)date.getValue().as(DateTime.class) : null)._abstract(_abstract != null ? (Boolean)_abstract.getValue().as(Boolean.class) : null).displayLanguage(displayLanguage != null ? (Code)displayLanguage.getValue().as(Code.class) : null).build();
    }

    public static class Builder {
        private DateTime date;
        private Boolean _abstract;
        private Code displayLanguage;

        private Builder() {
        }

        public Builder date(DateTime date) {
            this.date = date;
            return this;
        }

        public Builder _abstract(Boolean _abstract) {
            this._abstract = _abstract;
            return this;
        }

        public Builder displayLanguage(Code displayLanguage) {
            this.displayLanguage = displayLanguage;
            return this;
        }

        public ValidationParameters build() {
            return new ValidationParameters(this);
        }

        protected Builder from(ValidationParameters validationParameters) {
            this.date = validationParameters.date;
            this._abstract = validationParameters._abstract;
            this.displayLanguage = validationParameters.displayLanguage;
            return this;
        }
    }
}

