/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service.provider;

import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.term.spi.FHIRTermServiceProvider;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractTermServiceProvider
implements FHIRTermServiceProvider {
    @Override
    public abstract Set<CodeSystem.Concept> closure(CodeSystem var1, Code var2);

    @Override
    public abstract CodeSystem.Concept getConcept(CodeSystem var1, Code var2);

    @Override
    public abstract Set<CodeSystem.Concept> getConcepts(CodeSystem var1);

    @Override
    public abstract Set<CodeSystem.Concept> getConcepts(CodeSystem var1, List<ValueSet.Compose.Include.Filter> var2);

    @Override
    public abstract boolean hasConcept(CodeSystem var1, Code var2);

    @Override
    public abstract boolean isSupported(CodeSystem var1);

    @Override
    public abstract boolean subsumes(CodeSystem var1, Code var2, Code var3);

    private void checkArgument(Code code, String message) {
        Objects.requireNonNull(code, message);
        Objects.requireNonNull(code.getValue(), "Code.value");
    }

    private void checkArgument(ValueSet.Compose.Include.Filter filter) {
        Objects.requireNonNull(filter, "filter");
        Objects.requireNonNull(filter.getProperty(), "Filter.property");
        Objects.requireNonNull(filter.getProperty().getValue(), "Filter.property.value");
        Objects.requireNonNull(filter.getOp(), "Filter.op");
        Objects.requireNonNull(filter.getOp().getValue(), "Filter.op.value");
        Objects.requireNonNull(filter.getValue(), "Filter.value");
        Objects.requireNonNull(filter.getValue().getValue(), "Filter.value.value");
    }

    private <R> void checkArgument(Function<CodeSystem.Concept, ? extends R> function) {
        Objects.requireNonNull(function, "function");
    }

    protected void checkArgument(CodeSystem codeSystem) {
        Objects.requireNonNull(codeSystem, "codeSystem");
        Objects.requireNonNull(codeSystem.getUrl(), "CodeSystem.url");
        Objects.requireNonNull(codeSystem.getUrl().getValue(), "CodeSystem.url.value");
        if (codeSystem.getVersion() != null) {
            Objects.requireNonNull(codeSystem.getVersion().getValue(), "CodeSystem.version.value");
        }
    }

    protected void checkArguments(CodeSystem codeSystem, Code code) {
        this.checkArgument(codeSystem);
        this.checkArgument(code, "code");
    }

    protected void checkArguments(CodeSystem codeSystem, Code codeA, Code codeB) {
        this.checkArgument(codeSystem);
        this.checkArgument(codeA, "codeA");
        this.checkArgument(codeB, "codeB");
    }

    protected <R> void checkArguments(CodeSystem codeSystem, Function<CodeSystem.Concept, ? extends R> function) {
        this.checkArgument(codeSystem);
        this.checkArgument(function);
    }

    protected void checkArguments(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
        this.checkArgument(codeSystem);
        Objects.requireNonNull(filters, "filters");
        filters.forEach(filter -> this.checkArgument((ValueSet.Compose.Include.Filter)filter));
    }

    protected <R> void checkArguments(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters, Function<CodeSystem.Concept, ? extends R> function) {
        this.checkArguments(codeSystem, filters);
        this.checkArgument(function);
    }
}

