/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service.provider;

import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Code;
import com.ibm.fhir.model.type.code.CodeSystemContentMode;
import com.ibm.fhir.term.exception.FHIRTermException;
import com.ibm.fhir.term.service.exception.FHIRTermServiceException;
import com.ibm.fhir.term.service.provider.AbstractTermServiceProvider;
import com.ibm.fhir.term.util.CodeSystemSupport;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class RegistryTermServiceProvider
extends AbstractTermServiceProvider {
    @Override
    public Set<CodeSystem.Concept> closure(CodeSystem codeSystem, Code code) {
        this.checkArguments(codeSystem, code);
        CodeSystem.Concept concept = CodeSystemSupport.findConcept(codeSystem, code);
        return CodeSystemSupport.getConcepts(concept);
    }

    @Override
    public CodeSystem.Concept getConcept(CodeSystem codeSystem, Code code) {
        this.checkArguments(codeSystem, code);
        CodeSystem.Concept concept = CodeSystemSupport.findConcept(codeSystem, code);
        if (concept != null) {
            return CodeSystemSupport.CONCEPT_NO_CHILDREN_FUNCTION.apply(concept);
        }
        return null;
    }

    @Override
    public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem) {
        return this.getConcepts(codeSystem, CodeSystemSupport.SIMPLE_CONCEPT_FUNCTION);
    }

    @Override
    public <R> Set<R> getConcepts(CodeSystem codeSystem, Function<CodeSystem.Concept, ? extends R> function) {
        this.checkArguments(codeSystem, function);
        return CodeSystemSupport.getConcepts(codeSystem, function);
    }

    @Override
    public Set<CodeSystem.Concept> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters) {
        return this.getConcepts(codeSystem, filters, CodeSystemSupport.SIMPLE_CONCEPT_FUNCTION);
    }

    @Override
    public <R> Set<R> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters, Function<CodeSystem.Concept, ? extends R> function) {
        this.checkArguments(codeSystem, filters, function);
        try {
            return CodeSystemSupport.getConcepts(codeSystem, filters, function);
        }
        catch (FHIRTermException e) {
            throw new FHIRTermServiceException(e.getMessage(), e, e.getIssues());
        }
    }

    @Override
    public boolean hasConcept(CodeSystem codeSystem, Code code) {
        return this.getConcept(codeSystem, code) != null;
    }

    @Override
    public boolean isSupported(CodeSystem codeSystem) {
        this.checkArgument(codeSystem);
        return CodeSystemContentMode.COMPLETE.equals((Object)codeSystem.getContent());
    }

    @Override
    public boolean subsumes(CodeSystem codeSystem, Code codeA, Code codeB) {
        this.checkArguments(codeSystem, codeA, codeB);
        CodeSystem.Concept concept = CodeSystemSupport.findConcept(codeSystem, codeA);
        return CodeSystemSupport.findConcept(codeSystem, concept, codeB) != null;
    }
}

