/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.service.util;

import com.ibm.fhir.model.resource.Parameters;
import com.ibm.fhir.model.type.Element;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class FHIRTermServiceUtil {
    private FHIRTermServiceUtil() {
    }

    public static Parameters.Parameter getParameter(Parameters parameters, String name) {
        return parameters.getParameter().stream().filter(parameter -> parameter.getName() != null).filter(parameter -> parameter.getName().getValue().equals(name)).findFirst().orElse(null);
    }

    public static <T extends Element> T getParameterValue(Parameters parameters, String name, Class<T> elementType) {
        Parameters.Parameter parameter = FHIRTermServiceUtil.getParameter(parameters, name);
        return (T)(parameter != null ? (Element)elementType.cast(FHIRTermServiceUtil.getParameter(parameters, name).getValue()) : null);
    }

    public static List<Parameters.Parameter> getParameters(Parameters parameters, String name) {
        return parameters.getParameter().stream().filter(parameter -> parameter.getName() != null).filter(parameter -> parameter.getName().getValue().equals(name)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static <T extends Element> List<T> getParameterValues(Parameters parameters, String name, Class<T> elementType) {
        return FHIRTermServiceUtil.getParameters(parameters, name).stream().map(parameter -> (Element)elementType.cast(parameter.getValue())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static Parameters.Parameter getPart(Parameters.Parameter parameter, String name) {
        return parameter.getPart().stream().filter(part -> part.getName() != null).filter(part -> part.getName().getValue().equals(name)).findFirst().orElse(null);
    }

    public static <T extends Element> T getPartValue(Parameters.Parameter parameter, String name, Class<T> elementType) {
        Parameters.Parameter part = FHIRTermServiceUtil.getPart(parameter, name);
        return (T)(part != null ? (Element)elementType.cast(FHIRTermServiceUtil.getPart(parameter, name).getValue()) : null);
    }

    public static List<Parameters.Parameter> getParts(Parameters.Parameter parameter, String name) {
        return parameter.getPart().stream().filter(part -> part.getName() != null).filter(part -> part.getName().getValue().equals(name)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static <T extends Element> List<T> getPartValues(Parameters.Parameter parameter, String name, Class<T> elementType) {
        return FHIRTermServiceUtil.getParts(parameter, name).stream().map(part -> (Element)elementType.cast(part.getValue())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }
}

