/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.term.spi;

import com.ibm.fhir.model.resource.CodeSystem;
import com.ibm.fhir.model.resource.ValueSet;
import com.ibm.fhir.model.type.Code;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface FHIRTermServiceProvider {
    public Set<CodeSystem.Concept> closure(CodeSystem var1, Code var2);

    default public Map<Code, Set<CodeSystem.Concept>> closure(CodeSystem codeSystem, Set<Code> codes) {
        LinkedHashMap<Code, Set<CodeSystem.Concept>> result = new LinkedHashMap<Code, Set<CodeSystem.Concept>>();
        for (Code code : codes) {
            Set<CodeSystem.Concept> closure = this.closure(codeSystem, code);
            result.put(code, closure);
        }
        return result;
    }

    public CodeSystem.Concept getConcept(CodeSystem var1, Code var2);

    public Set<CodeSystem.Concept> getConcepts(CodeSystem var1);

    default public <R> Set<R> getConcepts(CodeSystem codeSystem, Function<CodeSystem.Concept, ? extends R> function) {
        return this.getConcepts(codeSystem).stream().map(function).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<CodeSystem.Concept> getConcepts(CodeSystem var1, List<ValueSet.Compose.Include.Filter> var2);

    default public <R> Set<R> getConcepts(CodeSystem codeSystem, List<ValueSet.Compose.Include.Filter> filters, Function<CodeSystem.Concept, ? extends R> function) {
        return this.getConcepts(codeSystem, filters).stream().map(function).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean hasConcept(CodeSystem var1, Code var2);

    default public boolean hasConcepts(CodeSystem codeSystem, Set<Code> codes) {
        for (Code code : codes) {
            if (this.hasConcept(codeSystem, code)) continue;
            return false;
        }
        return true;
    }

    public boolean isSupported(CodeSystem var1);

    public boolean subsumes(CodeSystem var1, Code var2, Code var3);
}

